/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.repository;

import com.google.gson.JsonObject;
import com.metallicus.protonsdk.api.ProtonChainService;
import com.metallicus.protonsdk.db.CurrencyBalanceDao;
import com.metallicus.protonsdk.model.CurrencyBalance;
import com.metallicus.protonsdk.model.TokenCurrencyBalance;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;

@Singleton
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ'\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J!\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\u0006\u0010\u0011\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u0011\u0010\u0019\u001a\u00020\bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lcom/metallicus/protonsdk/repository/CurrencyBalanceRepository;", "", "currencyBalanceDao", "Lcom/metallicus/protonsdk/db/CurrencyBalanceDao;", "protonChainService", "Lcom/metallicus/protonsdk/api/ProtonChainService;", "(Lcom/metallicus/protonsdk/db/CurrencyBalanceDao;Lcom/metallicus/protonsdk/api/ProtonChainService;)V", "addCurrencyBalance", "", "currencyBalance", "Lcom/metallicus/protonsdk/model/CurrencyBalance;", "(Lcom/metallicus/protonsdk/model/CurrencyBalance;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchCurrencyBalances", "Lretrofit2/Response;", "Lcom/google/gson/JsonObject;", "chainUrl", "", "accountName", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTokenCurrencyBalance", "Lcom/metallicus/protonsdk/model/TokenCurrencyBalance;", "tokenContractId", "getTokenCurrencyBalances", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeAll", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "protonsdk_release"})
public final class CurrencyBalanceRepository {
    private final CurrencyBalanceDao currencyBalanceDao;
    private final ProtonChainService protonChainService;

    @Nullable
    public final Object removeAll(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.currencyBalanceDao.removeAll($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object addCurrencyBalance(@NotNull CurrencyBalance currencyBalance, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.currencyBalanceDao.insert(currencyBalance, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object fetchCurrencyBalances(@NotNull String chainUrl, @NotNull String accountName, @NotNull Continuation<? super Response<JsonObject>> $completion) {
        return this.protonChainService.getCurrencyBalances(chainUrl + "/v2/state/get_tokens", accountName, $completion);
    }

    @Nullable
    public final Object getTokenCurrencyBalance(@NotNull String accountName, @NotNull String tokenContractId, @NotNull Continuation<? super TokenCurrencyBalance> $completion) {
        return this.currencyBalanceDao.findByTokenContract(accountName, tokenContractId, $completion);
    }

    @Nullable
    public final Object getTokenCurrencyBalances(@NotNull String accountName, @NotNull Continuation<? super List<TokenCurrencyBalance>> $completion) {
        return this.currencyBalanceDao.findByAccountName(accountName, $completion);
    }

    @Inject
    public CurrencyBalanceRepository(@NotNull CurrencyBalanceDao currencyBalanceDao, @NotNull ProtonChainService protonChainService) {
        Intrinsics.checkNotNullParameter((Object)currencyBalanceDao, (String)"currencyBalanceDao");
        Intrinsics.checkNotNullParameter((Object)protonChainService, (String)"protonChainService");
        this.currencyBalanceDao = currencyBalanceDao;
        this.protonChainService = protonChainService;
    }
}

