/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.model.types;

import com.metallicus.protonsdk.eosio.commander.StringUtils;
import com.metallicus.protonsdk.eosio.commander.model.types.EosType;
import com.metallicus.protonsdk.eosio.commander.model.types.TypeSymbol;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypeAsset
implements EosType.Packer {
    public static final long MAX_AMOUNT = 0x3FFFFFFFFFFFFFFFL;
    private long mAmount;
    private TypeSymbol mSymbol;

    public static boolean isValidAmount(long amount) {
        return -4611686018427387903L <= amount && amount <= 0x3FFFFFFFFFFFFFFFL;
    }

    public static boolean isValidAmount(String amountStr) {
        boolean isValid = false;
        String amt = amountStr.trim();
        Pattern pattern = Pattern.compile("^([0-9]+)\\.?([0-9]*)([ ][a-zA-Z0-9]{1,7})?$");
        Matcher matcher = pattern.matcher(amt);
        if (matcher.find()) {
            String beforeDotVal = matcher.group(1);
            String afterDotVal = matcher.group(2);
            try {
                long amount = Long.valueOf(beforeDotVal + afterDotVal);
                isValid = TypeAsset.isValidAmount(amount);
            }
            catch (NumberFormatException e) {
                isValid = false;
            }
        }
        return isValid;
    }

    public TypeAsset(String value) {
        value = value.trim();
        Pattern pattern = Pattern.compile("^([0-9]+)\\.?([0-9]*)([ ][a-zA-Z0-9]{1,7})?$");
        Matcher matcher = pattern.matcher(value);
        if (matcher.find()) {
            String beforeDotVal = matcher.group(1);
            String afterDotVal = matcher.group(2);
            String symbolStr = StringUtils.isEmpty(matcher.group(3)) ? null : matcher.group(3).trim();
            this.mAmount = Long.valueOf(beforeDotVal + afterDotVal);
            this.mSymbol = new TypeSymbol(afterDotVal.length(), symbolStr);
        } else {
            this.mAmount = 0L;
            this.mSymbol = new TypeSymbol();
        }
    }

    public TypeAsset(long amount) {
        this(amount, new TypeSymbol());
    }

    public TypeAsset(long amount, TypeSymbol symbol) {
        this.mAmount = amount;
        this.mSymbol = symbol;
    }

    public boolean isValid() {
        return TypeAsset.isValidAmount(this.mAmount) && this.mSymbol != null && this.mSymbol.valid();
    }

    public short decimals() {
        return this.mSymbol != null ? this.mSymbol.decimals() : (short)0;
    }

    public long precision() {
        return this.mSymbol != null ? this.mSymbol.precision() : 0L;
    }

    public String symbolName() {
        if (this.mSymbol != null) {
            return this.mSymbol.name();
        }
        return "";
    }

    public long getAmount() {
        return this.mAmount;
    }

    public String toString() {
        long precisionVal = this.precision();
        String result = String.valueOf(this.mAmount / precisionVal);
        if (this.decimals() > 0) {
            long fract = this.mAmount % precisionVal;
            result = result + "." + String.valueOf(precisionVal + fract).substring(1);
        }
        return result + " " + this.symbolName();
    }

    @Override
    public void pack(EosType.Writer writer) {
        writer.putLongLE(this.mAmount);
        if (this.mSymbol != null) {
            this.mSymbol.pack(writer);
        } else {
            writer.putLongLE(0L);
        }
    }
}

