/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.model.types;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.annotations.Expose;
import com.metallicus.protonsdk.eosio.commander.HexUtils;
import com.metallicus.protonsdk.eosio.commander.Utils;
import com.metallicus.protonsdk.eosio.commander.model.types.EosByteWriter;
import com.metallicus.protonsdk.eosio.commander.model.types.EosType;
import com.metallicus.protonsdk.eosio.commander.model.types.TypeAccountName;
import com.metallicus.protonsdk.eosio.commander.model.types.TypeAsset;

public class EosTransfer
implements EosType.Packer {
    @Expose
    private TypeAccountName from;
    @Expose
    private TypeAccountName to;
    @Expose
    private TypeAsset quantity;
    @Expose
    private String memo;

    public EosTransfer(String from, String to, long quantity, String memo) {
        this(new TypeAccountName(from), new TypeAccountName(to), quantity, memo);
    }

    public EosTransfer(TypeAccountName from, TypeAccountName to, long quantity, String memo) {
        this.from = from;
        this.to = to;
        this.quantity = new TypeAsset(quantity);
        this.memo = memo != null ? memo : "";
    }

    public EosTransfer(String from, String to, String quantity, String memo) {
        this(new TypeAccountName(from), new TypeAccountName(to), quantity, memo);
    }

    public EosTransfer(TypeAccountName from, TypeAccountName to, String quantity, String memo) {
        this.from = from;
        this.to = to;
        this.quantity = new TypeAsset(quantity);
        this.memo = memo != null ? memo : "";
    }

    public String getAction() {
        return "transfer";
    }

    public String[] getActivePermission() {
        return new String[]{this.from + "@active"};
    }

    @Override
    public void pack(EosType.Writer writer) {
        this.from.pack(writer);
        this.to.pack(writer);
        writer.putLongLE(this.quantity.getAmount());
        writer.putString(this.memo);
    }

    public String getAsHex() {
        EosByteWriter writer = new EosByteWriter(128);
        this.pack(writer);
        return HexUtils.toHex(writer.toBytes());
    }

    public JsonElement jsonToBinArgs() {
        String json = Utils.prettyPrintJson(this);
        return JsonParser.parseString((String)json);
    }
}

