/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.ec;

import android.annotation.SuppressLint;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import com.metallicus.protonsdk.eosio.commander.Base58;
import com.metallicus.protonsdk.eosio.commander.digest.Sha256;
import com.metallicus.protonsdk.eosio.commander.digest.Sha512;
import com.metallicus.protonsdk.eosio.commander.ec.CurveParam;
import com.metallicus.protonsdk.eosio.commander.ec.EcDsa;
import com.metallicus.protonsdk.eosio.commander.ec.EcPoint;
import com.metallicus.protonsdk.eosio.commander.ec.EcSignature;
import com.metallicus.protonsdk.eosio.commander.ec.EcTools;
import com.metallicus.protonsdk.eosio.commander.ec.EosEcUtil;
import com.metallicus.protonsdk.eosio.commander.ec.EosPublicKey;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;

@SuppressLint(value={"Assert"})
public class EosPrivateKey {
    private static final String PREFIX = "PVT";
    private final BigInteger mPrivateKey;
    private final EosPublicKey mPublicKey;
    private final CurveParam mCurveParam;
    private static final SecureRandom mSecRandom = new SecureRandom();

    public static SecureRandom getSecureRandom() {
        return mSecRandom;
    }

    public static String getPublicKey(String privateKey) {
        String publicKey;
        try {
            EosPrivateKey p = new EosPrivateKey(privateKey);
            publicKey = p.getPublicKey().toString();
        }
        catch (Exception e) {
            publicKey = "";
        }
        return publicKey;
    }

    public EosPrivateKey() {
        this(0, null);
    }

    public EosPrivateKey(int curveParamType) {
        this(curveParamType, null);
    }

    public EosPrivateKey(byte[] keyBytes) {
        this(0, keyBytes);
    }

    public EosPrivateKey(int curveParamType, byte[] keyBytes) {
        this.mCurveParam = EcTools.getCurveParam(curveParamType);
        this.mPrivateKey = this.getOrCreatePrivKeyBigInteger(keyBytes);
        this.mPublicKey = new EosPublicKey(this.findPubKey(this.mPrivateKey), this.mCurveParam);
    }

    public EosPrivateKey(String base58Str) {
        byte[] keyBytes;
        String[] split = EosEcUtil.safeSplitEosCryptoString(base58Str);
        if (split.length == 1) {
            this.mCurveParam = EcTools.getCurveParam(0);
            keyBytes = EosEcUtil.getBytesIfMatchedSha256(base58Str, null);
        } else {
            if (split.length < 3) {
                throw new IllegalArgumentException("Invalid private key format: " + base58Str);
            }
            this.mCurveParam = EosEcUtil.getCurveParamFrom(split[1]);
            keyBytes = EosEcUtil.getBytesIfMatchedRipemd160(split[2], split[1], null);
        }
        if (null == keyBytes || keyBytes.length < 5) {
            throw new IllegalArgumentException("Invalid private key length");
        }
        this.mPrivateKey = this.getOrCreatePrivKeyBigInteger(keyBytes);
        this.mPublicKey = new EosPublicKey(this.findPubKey(this.mPrivateKey), this.mCurveParam);
    }

    public byte[] getSharedSecret(EosPublicKey eosPublicKey, long nonce) {
        byte[] r = this.getBytes();
        byte[] publicKeyBytes = eosPublicKey.getBytes();
        CurveParam param = EcTools.getCurveParam(0);
        EcPoint publicKeyPoint = param.getCurve().decodePoint(publicKeyBytes);
        EcPoint p = EcTools.multiply(publicKeyPoint, this.toUnsignedBigInteger(r));
        byte[] encodedx = p.getX().toBigInteger().toByteArray();
        if (encodedx.length > 32) {
            encodedx = Arrays.copyOfRange(encodedx, 1, encodedx.length);
        }
        byte[] retval = encodedx;
        if (nonce != 0L) {
            byte[] nonceBytes = Longs.toByteArray((long)nonce);
            retval = Bytes.concat((byte[][])new byte[][]{nonceBytes, encodedx});
        }
        Sha512 sha512 = Sha512.from(retval);
        return sha512.getBytes();
    }

    public void clear() {
        this.mPrivateKey.multiply(BigInteger.ZERO);
    }

    private byte[] findPubKey(BigInteger bnum) {
        EcPoint Q = EcTools.multiply(this.mCurveParam.G(), bnum);
        Q = new EcPoint(Q.getCurve(), Q.getX(), Q.getY(), true);
        return Q.getEncoded();
    }

    public EosPublicKey getPublicKey() {
        return this.mPublicKey;
    }

    public String toWif() {
        byte[] rawPrivKey = this.getBytes();
        byte[] resultWIFBytes = new byte[37];
        resultWIFBytes[0] = -128;
        System.arraycopy(rawPrivKey, rawPrivKey.length > 32 ? 1 : 0, resultWIFBytes, 1, 32);
        Sha256 hash = Sha256.doubleHash(resultWIFBytes, 0, 33);
        System.arraycopy(hash.getBytes(), 0, resultWIFBytes, 33, 4);
        return Base58.encode(resultWIFBytes);
    }

    public CurveParam getCurveParam() {
        return this.mCurveParam;
    }

    public EcSignature sign(Sha256 digest) {
        return EcDsa.sign(digest, this);
    }

    public String toString() {
        if (this.mCurveParam.isType(0)) {
            return this.toWif();
        }
        return EosEcUtil.encodeEosCrypto(PREFIX, this.mCurveParam, this.getBytes());
    }

    public BigInteger getAsBigInteger() {
        return this.mPrivateKey;
    }

    public byte[] getBytes() {
        byte[] result = new byte[32];
        byte[] bytes = this.mPrivateKey.toByteArray();
        if (bytes.length <= result.length) {
            System.arraycopy(bytes, 0, result, result.length - bytes.length, bytes.length);
        } else {
            assert (bytes.length == 33 && bytes[0] == 0);
            System.arraycopy(bytes, 1, result, 0, bytes.length - 1);
        }
        return result;
    }

    public byte[] getBytes(BigInteger value) {
        byte[] result = new byte[32];
        byte[] bytes = value.toByteArray();
        if (bytes.length <= result.length) {
            System.arraycopy(bytes, 0, result, result.length - bytes.length, bytes.length);
        } else {
            assert (bytes.length == 33 && bytes[0] == 0);
            System.arraycopy(bytes, 1, result, 0, bytes.length - 1);
        }
        return result;
    }

    private BigInteger toUnsignedBigInteger(BigInteger value) {
        if (value.signum() < 0) {
            return new BigInteger(1, value.toByteArray());
        }
        return value;
    }

    private BigInteger toUnsignedBigInteger(byte[] value) {
        if ((value[0] & 0x80) != 0) {
            return new BigInteger(1, value);
        }
        return new BigInteger(value);
    }

    private BigInteger getOrCreatePrivKeyBigInteger(byte[] value) {
        byte[] bytes;
        BigInteger d;
        if (null != value) {
            if ((value[0] & 0x80) != 0) {
                return new BigInteger(1, value);
            }
            return new BigInteger(value);
        }
        int nBitLength = this.mCurveParam.n().bitLength();
        do {
            bytes = new byte[nBitLength / 8];
            mSecRandom.nextBytes(bytes);
            bytes[0] = (byte)(bytes[0] & 0x7F);
        } while ((d = new BigInteger(bytes)).equals(BigInteger.ZERO) || d.compareTo(this.mCurveParam.n()) >= 0);
        return d;
    }
}

