/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.digest;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.metallicus.protonsdk.eosio.commander.HexUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class Sha512
implements Comparable<Sha512> {
    public static final int HASH_LENGTH = 64;
    public static final Sha512 ZERO_HASH = new Sha512(new byte[64]);
    private final byte[] mHashBytes;

    public Sha512(byte[] bytes) {
        Preconditions.checkArgument((bytes.length == 64 ? 1 : 0) != 0);
        this.mHashBytes = bytes;
    }

    public static Sha512 from(byte[] data) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        digest.update(data, 0, data.length);
        return new Sha512(digest.digest());
    }

    private Sha512(byte[] bytes, int offset) {
        this.mHashBytes = new byte[64];
        System.arraycopy(bytes, offset, this.mHashBytes, 0, 64);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Sha512)) {
            return false;
        }
        return Arrays.equals(this.mHashBytes, ((Sha512)other).mHashBytes);
    }

    public String toString() {
        return HexUtils.toHex(this.mHashBytes);
    }

    public byte[] getBytes() {
        return this.mHashBytes;
    }

    @Override
    public int compareTo(Sha512 o) {
        for (int i = 0; i < 64; ++i) {
            byte myByte = this.mHashBytes[i];
            byte otherByte = o.mHashBytes[i];
            int compare = Ints.compare((int)myByte, (int)otherByte);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

