/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.di;

import android.content.Context;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.metallicus.protonsdk.R;
import com.metallicus.protonsdk.api.ESRCallbackService;
import com.metallicus.protonsdk.api.ProtonChainService;
import com.metallicus.protonsdk.common.Prefs;
import com.metallicus.protonsdk.common.SecureKeys;
import com.metallicus.protonsdk.db.AccountContactDao;
import com.metallicus.protonsdk.db.AccountDao;
import com.metallicus.protonsdk.db.ActionDao;
import com.metallicus.protonsdk.db.ChainProviderDao;
import com.metallicus.protonsdk.db.CurrencyBalanceDao;
import com.metallicus.protonsdk.db.ProtonDb;
import com.metallicus.protonsdk.db.TokenContractDao;
import com.metallicus.protonsdk.eosio.commander.GsonEosTypeAdapterFactory;
import dagger.Module;
import dagger.Provides;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Module
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u001c"}, d2={"Lcom/metallicus/protonsdk/di/ProtonModule;", "", "()V", "provideAccountContactDao", "Lcom/metallicus/protonsdk/db/AccountContactDao;", "db", "Lcom/metallicus/protonsdk/db/ProtonDb;", "provideAccountDao", "Lcom/metallicus/protonsdk/db/AccountDao;", "provideActionDao", "Lcom/metallicus/protonsdk/db/ActionDao;", "provideChainProviderDao", "Lcom/metallicus/protonsdk/db/ChainProviderDao;", "provideCurrencyBalanceDao", "Lcom/metallicus/protonsdk/db/CurrencyBalanceDao;", "provideDb", "context", "Landroid/content/Context;", "provideESRCallbackService", "Lcom/metallicus/protonsdk/api/ESRCallbackService;", "providePrefs", "Lcom/metallicus/protonsdk/common/Prefs;", "provideProtonChainService", "Lcom/metallicus/protonsdk/api/ProtonChainService;", "provideSecureKeys", "Lcom/metallicus/protonsdk/common/SecureKeys;", "provideTokenContractDao", "Lcom/metallicus/protonsdk/db/TokenContractDao;", "protonsdk_release"})
public final class ProtonModule {
    @Singleton
    @Provides
    @NotNull
    public final ProtonDb provideDb(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RoomDatabase roomDatabase = Room.databaseBuilder((Context)context, ProtonDb.class, (String)"protonsdk.db").fallbackToDestructiveMigration().build();
        Intrinsics.checkNotNullExpressionValue((Object)roomDatabase, (String)"Room\n\t\t\t.databaseBuilder\u2026veMigration()\n\t\t\t.build()");
        return (ProtonDb)roomDatabase;
    }

    @Singleton
    @Provides
    @NotNull
    public final ChainProviderDao provideChainProviderDao(@NotNull ProtonDb db) {
        Intrinsics.checkNotNullParameter((Object)((Object)db), (String)"db");
        return db.chainProviderDao();
    }

    @Singleton
    @Provides
    @NotNull
    public final TokenContractDao provideTokenContractDao(@NotNull ProtonDb db) {
        Intrinsics.checkNotNullParameter((Object)((Object)db), (String)"db");
        return db.tokenContractDao();
    }

    @Singleton
    @Provides
    @NotNull
    public final AccountDao provideAccountDao(@NotNull ProtonDb db) {
        Intrinsics.checkNotNullParameter((Object)((Object)db), (String)"db");
        return db.accountDao();
    }

    @Singleton
    @Provides
    @NotNull
    public final AccountContactDao provideAccountContactDao(@NotNull ProtonDb db) {
        Intrinsics.checkNotNullParameter((Object)((Object)db), (String)"db");
        return db.accountContactDao();
    }

    @Singleton
    @Provides
    @NotNull
    public final CurrencyBalanceDao provideCurrencyBalanceDao(@NotNull ProtonDb db) {
        Intrinsics.checkNotNullParameter((Object)((Object)db), (String)"db");
        return db.currencyBalanceDao();
    }

    @Singleton
    @Provides
    @NotNull
    public final ActionDao provideActionDao(@NotNull ProtonDb db) {
        Intrinsics.checkNotNullParameter((Object)((Object)db), (String)"db");
        return db.actionDao();
    }

    @Singleton
    @Provides
    @NotNull
    public final ProtonChainService provideProtonChainService(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder().callTimeout(30L, TimeUnit.SECONDS).connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS);
        Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new GsonEosTypeAdapterFactory()).serializeNulls().create();
        Object object = new Retrofit.Builder().baseUrl(context.getString(R.string.defaultProtonChainUrl)).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).client(httpClient.build()).build().create(ProtonChainService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Retrofit.Builder()\n\t\t\t.b\u2026ChainService::class.java)");
        return (ProtonChainService)object;
    }

    @Singleton
    @Provides
    @NotNull
    public final ESRCallbackService provideESRCallbackService(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor(null, 1, null);
        logging.level(HttpLoggingInterceptor.Level.BODY);
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder().callTimeout(30L, TimeUnit.SECONDS).connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).addInterceptor((Interceptor)logging);
        Gson gson = new GsonBuilder().setLenient().serializeNulls().create();
        Object object = new Retrofit.Builder().baseUrl(context.getString(R.string.defaultESRCallbackUrl)).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).client(httpClient.build()).build().create(ESRCallbackService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Retrofit.Builder()\n\t\t\t.b\u2026lbackService::class.java)");
        return (ESRCallbackService)object;
    }

    @Singleton
    @Provides
    @NotNull
    public final Prefs providePrefs(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Prefs(context);
    }

    @Singleton
    @Provides
    @NotNull
    public final SecureKeys provideSecureKeys(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new SecureKeys(context);
    }
}

