/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.common;

import android.content.Context;
import android.content.SharedPreferences;
import com.metallicus.protonsdk.eosio.commander.ec.EosPrivateKey;
import com.metallicus.protonsdk.securestorage.SecurePreferences;
import com.metallicus.protonsdk.securestorage.SecureStorageException;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bJ\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/metallicus/protonsdk/common/SecureKeys;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "addKey", "", "publicKey", "", "privateKey", "pin", "checkPin", "getPrivateKey", "hasKeys", "keyExists", "removeAll", "", "removeKey", "resetKeys", "oldPin", "newPin", "Companion", "protonsdk_release"})
public final class SecureKeys {
    private final Context context;
    @NotNull
    public static final String SHARED_PREFS_FILENAME = "protonsdk.secure_keys";
    public static final Companion Companion = new Companion(null);

    public final boolean hasKeys() {
        SecurePreferences.setSharedPreferencesName(SHARED_PREFS_FILENAME);
        SharedPreferences sharedPreferences = SecurePreferences.getSharedPreferences(this.context);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"SecurePreferences.getSharedPreferences(context)");
        SharedPreferences securePrefs = sharedPreferences;
        Map map = securePrefs.getAll();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"securePrefs.all");
        Map map2 = map;
        boolean bl = false;
        return !map2.isEmpty();
    }

    public final boolean checkPin(@NotNull String pin) {
        Intrinsics.checkNotNullParameter((Object)pin, (String)"pin");
        boolean isValid = false;
        SecurePreferences.setSharedPreferencesName(SHARED_PREFS_FILENAME);
        SharedPreferences sharedPreferences = SecurePreferences.getSharedPreferences(this.context);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"SecurePreferences.getSharedPreferences(context)");
        SharedPreferences securePrefs = sharedPreferences;
        Map map = securePrefs.getAll();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"securePrefs.all");
        Map map2 = map;
        boolean bl = false;
        if (!map2.isEmpty()) {
            boolean bl2;
            try {
                Map.Entry firstAccount = securePrefs.getAll().entrySet().iterator().next();
                String publicKey = (String)firstAccount.getKey();
                String privateKey = SecurePreferences.getStringValue(this.context, publicKey, pin, "");
                bl2 = Intrinsics.areEqual((Object)new EosPrivateKey(privateKey).getPublicKey().toString(), (Object)publicKey);
            }
            catch (Exception e) {
                bl2 = false;
            }
            isValid = bl2;
        }
        return isValid;
    }

    public final boolean resetKeys(@NotNull String oldPin, @NotNull String newPin) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)oldPin, (String)"oldPin");
        Intrinsics.checkNotNullParameter((Object)newPin, (String)"newPin");
        try {
            SecurePreferences.setSharedPreferencesName(SHARED_PREFS_FILENAME);
            SharedPreferences sharedPreferences = SecurePreferences.getSharedPreferences(this.context);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"SecurePreferences.getSharedPreferences(context)");
            SharedPreferences securePrefs = sharedPreferences;
            Map map = securePrefs.getAll();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"securePrefs.all");
            Map $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Map map2 = $this$forEach$iv;
            boolean bl2 = false;
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                String string2;
                Map.Entry element$iv;
                Map.Entry secureKey = element$iv = iterator.next();
                boolean bl3 = false;
                String publicKey = (String)secureKey.getKey();
                String privateKey = SecurePreferences.getStringValue(this.context, publicKey, oldPin, "");
                if (privateKey == null) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                String it = string2;
                boolean bl6 = false;
                SecurePreferences.setValue(this.context, publicKey, it, newPin);
            }
            bl = true;
        }
        catch (SecureStorageException e) {
            Timber.d((Throwable)e);
            bl = false;
        }
        return bl;
    }

    public final boolean keyExists(@NotNull String publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        SecurePreferences.setSharedPreferencesName(SHARED_PREFS_FILENAME);
        return SecurePreferences.contains(this.context, publicKey);
    }

    @Nullable
    public final String getPrivateKey(@NotNull String publicKey, @NotNull String pin) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)pin, (String)"pin");
        SecurePreferences.setSharedPreferencesName(SHARED_PREFS_FILENAME);
        return SecurePreferences.getStringValue(this.context, publicKey, pin, "");
    }

    public final boolean addKey(@NotNull String publicKey, @NotNull String privateKey, @NotNull String pin) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)pin, (String)"pin");
        try {
            SecurePreferences.setSharedPreferencesName(SHARED_PREFS_FILENAME);
            SecurePreferences.setValue(this.context, publicKey, privateKey, pin);
            bl = true;
        }
        catch (SecureStorageException e) {
            Timber.d((Throwable)e);
            bl = false;
        }
        return bl;
    }

    public final void removeKey(@NotNull String publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        try {
            SecurePreferences.setSharedPreferencesName(SHARED_PREFS_FILENAME);
            SecurePreferences.removeValue(this.context, publicKey);
        }
        catch (SecureStorageException e) {
            Timber.d((Throwable)e);
        }
    }

    public final void removeAll() {
        try {
            SecurePreferences.setSharedPreferencesName(SHARED_PREFS_FILENAME);
            SecurePreferences.clearAllValues(this.context);
        }
        catch (SecureStorageException e) {
            Timber.d((Throwable)e);
        }
    }

    public SecureKeys(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/metallicus/protonsdk/common/SecureKeys$Companion;", "", "()V", "SHARED_PREFS_FILENAME", "", "protonsdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

