/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.model.types;

import com.metallicus.protonsdk.eosio.commander.StringUtils;
import com.metallicus.protonsdk.eosio.commander.Utils;
import com.metallicus.protonsdk.eosio.commander.model.types.EosType;

public class TypeSymbol
implements EosType.Packer {
    private static final int MAX_PRECISION = 18;
    public static String sCoreSymbolString = "EOS";
    public static int sCoreSymbolPrecision = 4;
    private long mValue;

    public static long stringToSymbol(int precision, CharSequence str) {
        long result = 0L;
        if (StringUtils.isEmpty(str)) {
            str = sCoreSymbolString;
            precision = sCoreSymbolPrecision;
        }
        for (int index = 0; index < str.length(); ++index) {
            long value = str.charAt(index);
            if (value < 65L || value > 90L) {
                throw new IllegalArgumentException("invalid symbol string: " + str);
            }
            result |= value << 8 * (1 + index);
        }
        return result |= (long)precision;
    }

    public static TypeSymbol fromString(String str) {
        String[] split = str.trim().split(",");
        if (split.length != 2) {
            throw new IllegalArgumentException("invalid symbol string: " + str);
        }
        int precision = Utils.parseIntSafely(split[0], 0);
        if (precision > 18) {
            throw new IllegalArgumentException("precision should be <= 18: " + str);
        }
        return new TypeSymbol(precision, split[1]);
    }

    public static boolean validName(String name) {
        for (int index = 0; index < name.length(); ++index) {
            char value = name.charAt(index);
            if (value >= 'A' && value <= 'Z') continue;
            return false;
        }
        return true;
    }

    public TypeSymbol() {
        this(sCoreSymbolPrecision, sCoreSymbolString);
    }

    public TypeSymbol(int precision, CharSequence symbolName) {
        this.mValue = TypeSymbol.stringToSymbol(precision, symbolName);
    }

    public short decimals() {
        return (short)(this.mValue & 0xFFL);
    }

    public long precision() {
        short decimalVal = this.decimals();
        if (decimalVal > 18) {
            throw new IllegalArgumentException("precision should be <= 18, precision: " + decimalVal);
        }
        long p10 = 1L;
        for (long p = (long)decimalVal; p > 0L; --p) {
            p10 *= 10L;
        }
        return p10;
    }

    public String name() {
        long v = this.mValue;
        v >>= 8;
        StringBuilder result = new StringBuilder(8);
        while (v > 0L) {
            result.append((char)(v & 0xFFL));
            v >>= 8;
        }
        return result.toString();
    }

    public boolean valid() {
        return this.decimals() <= 18 && TypeSymbol.validName(this.name());
    }

    public String toString() {
        return this.decimals() + "," + this.name();
    }

    @Override
    public void pack(EosType.Writer writer) {
        writer.putLongLE(this.mValue);
    }
}

