/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.db;

import android.database.Cursor;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.metallicus.protonsdk.db.CurrencyBalanceDao;
import com.metallicus.protonsdk.db.DefaultTypeConverters;
import com.metallicus.protonsdk.model.CurrencyBalance;
import com.metallicus.protonsdk.model.TokenContract;
import com.metallicus.protonsdk.model.TokenCurrencyBalance;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class CurrencyBalanceDao_Impl
implements CurrencyBalanceDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CurrencyBalance> __insertionAdapterOfCurrencyBalance;
    private final SharedSQLiteStatement __preparedStmtOfUpdateAmount;
    private final SharedSQLiteStatement __preparedStmtOfRemoveAll;

    public CurrencyBalanceDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCurrencyBalance = new EntityInsertionAdapter<CurrencyBalance>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `CurrencyBalance` (`tokenContractId`,`accountName`,`contract`,`symbol`,`amount`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, CurrencyBalance value) {
                if (value.tokenContractId == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.tokenContractId);
                }
                if (value.accountName == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.accountName);
                }
                if (value.getContract() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getContract());
                }
                if (value.getSymbol() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getSymbol());
                }
                if (value.getAmount() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getAmount());
                }
            }
        };
        this.__preparedStmtOfUpdateAmount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE currencyBalance SET amount = ? WHERE accountName = ? AND contract = ? AND symbol = ?";
                return "UPDATE currencyBalance SET amount = ? WHERE accountName = ? AND contract = ? AND symbol = ?";
            }
        };
        this.__preparedStmtOfRemoveAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM currencyBalance";
                return "DELETE FROM currencyBalance";
            }
        };
    }

    @Override
    public Object insert(final CurrencyBalance currencyBalance, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                CurrencyBalanceDao_Impl.this.__db.beginTransaction();
                try {
                    CurrencyBalanceDao_Impl.this.__insertionAdapterOfCurrencyBalance.insert((Object)currencyBalance);
                    CurrencyBalanceDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CurrencyBalanceDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object updateAmount(final String accountName, final String contract, final String symbol, final String amount, Continuation<? super Unit> p4) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = CurrencyBalanceDao_Impl.this.__preparedStmtOfUpdateAmount.acquire();
                int _argIndex = 1;
                if (amount == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, amount);
                }
                _argIndex = 2;
                if (accountName == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, accountName);
                }
                _argIndex = 3;
                if (contract == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, contract);
                }
                _argIndex = 4;
                if (symbol == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, symbol);
                }
                CurrencyBalanceDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    CurrencyBalanceDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CurrencyBalanceDao_Impl.this.__db.endTransaction();
                    CurrencyBalanceDao_Impl.this.__preparedStmtOfUpdateAmount.release(_stmt);
                }
            }
        }, p4);
    }

    @Override
    public Object removeAll(Continuation<? super Unit> p0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = CurrencyBalanceDao_Impl.this.__preparedStmtOfRemoveAll.acquire();
                CurrencyBalanceDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    CurrencyBalanceDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CurrencyBalanceDao_Impl.this.__db.endTransaction();
                    CurrencyBalanceDao_Impl.this.__preparedStmtOfRemoveAll.release(_stmt);
                }
            }
        }, p0);
    }

    @Override
    public Object findByTokenContract(String accountName, String tokenContractId, Continuation<? super TokenCurrencyBalance> p2) {
        String _sql = "SELECT * FROM currencyBalance WHERE accountName = ? AND tokenContractId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM currencyBalance WHERE accountName = ? AND tokenContractId = ?", (int)2);
        int _argIndex = 1;
        if (accountName == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountName);
        }
        _argIndex = 2;
        if (tokenContractId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, tokenContractId);
        }
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<TokenCurrencyBalance>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TokenCurrencyBalance call() throws Exception {
                CurrencyBalanceDao_Impl.this.__db.beginTransaction();
                try {
                    TokenCurrencyBalance tokenCurrencyBalance;
                    Cursor _cursor = DBUtil.query((RoomDatabase)CurrencyBalanceDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        TokenCurrencyBalance _result;
                        int _cursorIndexOfTokenContractId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tokenContractId");
                        int _cursorIndexOfAccountName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accountName");
                        int _cursorIndexOfContract = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contract");
                        int _cursorIndexOfSymbol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"symbol");
                        int _cursorIndexOfAmount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"amount");
                        ArrayMap _collectionTokenContract = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey = _cursor.getString(_cursorIndexOfTokenContractId);
                            _collectionTokenContract.put((Object)_tmpKey, null);
                        }
                        _cursor.moveToPosition(-1);
                        CurrencyBalanceDao_Impl.this.__fetchRelationshipTokenContractAscomMetallicusProtonsdkModelTokenContract((ArrayMap<String, TokenContract>)_collectionTokenContract);
                        if (_cursor.moveToFirst()) {
                            CurrencyBalance _tmpCurrencyBalance;
                            if (!(_cursor.isNull(_cursorIndexOfTokenContractId) && _cursor.isNull(_cursorIndexOfAccountName) && _cursor.isNull(_cursorIndexOfContract) && _cursor.isNull(_cursorIndexOfSymbol) && _cursor.isNull(_cursorIndexOfAmount))) {
                                String _tmpContract = _cursor.getString(_cursorIndexOfContract);
                                String _tmpSymbol = _cursor.getString(_cursorIndexOfSymbol);
                                String _tmpAmount = _cursor.getString(_cursorIndexOfAmount);
                                _tmpCurrencyBalance = new CurrencyBalance(_tmpContract, _tmpSymbol, _tmpAmount);
                                _tmpCurrencyBalance.tokenContractId = _cursor.getString(_cursorIndexOfTokenContractId);
                                _tmpCurrencyBalance.accountName = _cursor.getString(_cursorIndexOfAccountName);
                            } else {
                                _tmpCurrencyBalance = null;
                            }
                            TokenContract _tmpTokenContract = null;
                            String _tmpKey_1 = _cursor.getString(_cursorIndexOfTokenContractId);
                            _tmpTokenContract = (TokenContract)_collectionTokenContract.get((Object)_tmpKey_1);
                            _result = new TokenCurrencyBalance(_tmpCurrencyBalance, _tmpTokenContract);
                        } else {
                            _result = null;
                        }
                        CurrencyBalanceDao_Impl.this.__db.setTransactionSuccessful();
                        tokenCurrencyBalance = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return tokenCurrencyBalance;
                }
                finally {
                    CurrencyBalanceDao_Impl.this.__db.endTransaction();
                }
            }
        }, p2);
    }

    @Override
    public Object findByAccountName(String accountName, Continuation<? super List<TokenCurrencyBalance>> p1) {
        String _sql = "SELECT * FROM currencyBalance WHERE accountName = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM currencyBalance WHERE accountName = ?", (int)1);
        int _argIndex = 1;
        if (accountName == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountName);
        }
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<List<TokenCurrencyBalance>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<TokenCurrencyBalance> call() throws Exception {
                CurrencyBalanceDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<TokenCurrencyBalance> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)CurrencyBalanceDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfTokenContractId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tokenContractId");
                        int _cursorIndexOfAccountName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accountName");
                        int _cursorIndexOfContract = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contract");
                        int _cursorIndexOfSymbol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"symbol");
                        int _cursorIndexOfAmount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"amount");
                        ArrayMap _collectionTokenContract = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey = _cursor.getString(_cursorIndexOfTokenContractId);
                            _collectionTokenContract.put((Object)_tmpKey, null);
                        }
                        _cursor.moveToPosition(-1);
                        CurrencyBalanceDao_Impl.this.__fetchRelationshipTokenContractAscomMetallicusProtonsdkModelTokenContract((ArrayMap<String, TokenContract>)_collectionTokenContract);
                        ArrayList<TokenCurrencyBalance> _result = new ArrayList<TokenCurrencyBalance>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            CurrencyBalance _tmpCurrencyBalance;
                            if (!(_cursor.isNull(_cursorIndexOfTokenContractId) && _cursor.isNull(_cursorIndexOfAccountName) && _cursor.isNull(_cursorIndexOfContract) && _cursor.isNull(_cursorIndexOfSymbol) && _cursor.isNull(_cursorIndexOfAmount))) {
                                String _tmpContract = _cursor.getString(_cursorIndexOfContract);
                                String _tmpSymbol = _cursor.getString(_cursorIndexOfSymbol);
                                String _tmpAmount = _cursor.getString(_cursorIndexOfAmount);
                                _tmpCurrencyBalance = new CurrencyBalance(_tmpContract, _tmpSymbol, _tmpAmount);
                                _tmpCurrencyBalance.tokenContractId = _cursor.getString(_cursorIndexOfTokenContractId);
                                _tmpCurrencyBalance.accountName = _cursor.getString(_cursorIndexOfAccountName);
                            } else {
                                _tmpCurrencyBalance = null;
                            }
                            TokenContract _tmpTokenContract = null;
                            String _tmpKey_1 = _cursor.getString(_cursorIndexOfTokenContractId);
                            _tmpTokenContract = (TokenContract)_collectionTokenContract.get((Object)_tmpKey_1);
                            TokenCurrencyBalance _item = new TokenCurrencyBalance(_tmpCurrencyBalance, _tmpTokenContract);
                            _result.add(_item);
                        }
                        CurrencyBalanceDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return arrayList;
                }
                finally {
                    CurrencyBalanceDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __fetchRelationshipTokenContractAscomMetallicusProtonsdkModelTokenContract(ArrayMap<String, TokenContract> _map) {
        Set __mapKeySet = _map.keySet();
        if (__mapKeySet.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            ArrayMap _tmpInnerMap = new ArrayMap(999);
            int _tmpIndex = 0;
            int _limit = _map.size();
            for (int _mapIndex = 0; _mapIndex < _limit; ++_mapIndex) {
                _tmpInnerMap.put(_map.keyAt(_mapIndex), null);
                if (++_tmpIndex != 999) continue;
                this.__fetchRelationshipTokenContractAscomMetallicusProtonsdkModelTokenContract((ArrayMap<String, TokenContract>)_tmpInnerMap);
                _map.putAll((Map)_tmpInnerMap);
                _tmpInnerMap = new ArrayMap(999);
                _tmpIndex = 0;
            }
            if (_tmpIndex > 0) {
                this.__fetchRelationshipTokenContractAscomMetallicusProtonsdkModelTokenContract((ArrayMap<String, TokenContract>)_tmpInnerMap);
                _map.putAll((Map)_tmpInnerMap);
            }
            return;
        }
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT `rates`,`id`,`contract`,`name`,`url`,`description`,`iconUrl`,`precisionSymbol`,`blacklisted` FROM `TokenContract` WHERE `id` IN (");
        int _inputSize = __mapKeySet.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : __mapKeySet) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_stmt, (boolean)false, null);){
            int _itemKeyIndex = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"id");
            if (_itemKeyIndex == -1) {
                return;
            }
            int _cursorIndexOfRates = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"rates");
            int _cursorIndexOfId = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"id");
            int _cursorIndexOfContract = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"contract");
            int _cursorIndexOfName = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"name");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"url");
            int _cursorIndexOfDescription = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"description");
            int _cursorIndexOfIconUrl = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"iconUrl");
            int _cursorIndexOfPrecisionSymbol = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"precisionSymbol");
            int _cursorIndexOfBlacklisted = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"blacklisted");
            while (_cursor.moveToNext()) {
                String _tmpKey = _cursor.getString(_itemKeyIndex);
                if (!_map.containsKey((Object)_tmpKey)) continue;
                String _tmpId = _cursorIndexOfId == -1 ? null : _cursor.getString(_cursorIndexOfId);
                String _tmpContract = _cursorIndexOfContract == -1 ? null : _cursor.getString(_cursorIndexOfContract);
                String _tmpName = _cursorIndexOfName == -1 ? null : _cursor.getString(_cursorIndexOfName);
                String _tmpUrl = _cursorIndexOfUrl == -1 ? null : _cursor.getString(_cursorIndexOfUrl);
                String _tmpDescription = _cursorIndexOfDescription == -1 ? null : _cursor.getString(_cursorIndexOfDescription);
                String _tmpIconUrl = _cursorIndexOfIconUrl == -1 ? null : _cursor.getString(_cursorIndexOfIconUrl);
                String _tmpPrecisionSymbol = _cursorIndexOfPrecisionSymbol == -1 ? null : _cursor.getString(_cursorIndexOfPrecisionSymbol);
                int _tmpBlacklisted = _cursorIndexOfBlacklisted == -1 ? 0 : _cursor.getInt(_cursorIndexOfBlacklisted);
                TokenContract _item_1 = new TokenContract(_tmpId, _tmpContract, _tmpName, _tmpUrl, _tmpDescription, _tmpIconUrl, _tmpPrecisionSymbol, _tmpBlacklisted);
                if (_cursorIndexOfRates != -1) {
                    String _tmp = _cursor.getString(_cursorIndexOfRates);
                    _item_1.rates = DefaultTypeConverters.stringToStringDoubleMap(_tmp);
                }
                _map.put((Object)_tmpKey, (Object)_item_1);
            }
        }
    }
}

