/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.model;

import androidx.room.Embedded;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import com.google.gson.annotations.SerializedName;
import com.metallicus.protonsdk.db.DefaultTypeConverters;
import com.metallicus.protonsdk.db.EOSTypeConverters;
import com.metallicus.protonsdk.db.ProtonTypeConverters;
import com.metallicus.protonsdk.model.AccountContact;
import com.metallicus.protonsdk.model.AccountCpuLimit;
import com.metallicus.protonsdk.model.AccountNetLimit;
import com.metallicus.protonsdk.model.AccountPermission;
import com.metallicus.protonsdk.model.AccountSelfDelegatedBandwidth;
import com.metallicus.protonsdk.model.AccountTotalResources;
import com.metallicus.protonsdk.model.AccountVoterInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b4\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0087\b\u0018\u00002\u00020\u0001B\u0099\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u0012\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u00a2\u0006\u0002\u0010\u001eJ\t\u0010D\u001a\u00020\u0003H\u00c6\u0003J\t\u0010E\u001a\u00020\u000eH\u00c6\u0003J\t\u0010F\u001a\u00020\u000eH\u00c6\u0003J\t\u0010G\u001a\u00020\u0012H\u00c6\u0003J\t\u0010H\u001a\u00020\u0014H\u00c6\u0003J\u000f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u00c6\u0003J\t\u0010J\u001a\u00020\u0019H\u00c6\u0003J\u000b\u0010K\u001a\u0004\u0018\u00010\u001bH\u00c6\u0003J\u000b\u0010L\u001a\u0004\u0018\u00010\u001dH\u00c6\u0003J\t\u0010M\u001a\u00020\u0005H\u00c6\u0003J\t\u0010N\u001a\u00020\u0003H\u00c6\u0003J\t\u0010O\u001a\u00020\bH\u00c6\u0003J\t\u0010P\u001a\u00020\u0003H\u00c6\u0003J\t\u0010Q\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010R\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010S\u001a\u00020\u0005H\u00c6\u0003J\t\u0010T\u001a\u00020\u000eH\u00c6\u0003J\u00bf\u0001\u0010U\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00c6\u0001J\u0013\u0010V\u001a\u00020\b2\b\u0010W\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010X\u001a\u00020\u0003J\u0006\u0010Y\u001a\u00020ZJ\u0006\u0010[\u001a\u00020ZJ\u0006\u0010\\\u001a\u00020ZJ\t\u0010]\u001a\u00020\u0005H\u00d6\u0001J\t\u0010^\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u001f\u001a\u00020\u0003X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010!R\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010!R\u0016\u0010\u0013\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0016\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0016\u0010\n\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010!R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0016\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010!R\u0016\u0010\t\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010!R\u0016\u0010\u0011\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0016\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010/R\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0016\u0010\f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u00102R\u0016\u0010\u0010\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010/R\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0016\u0010\u0018\u001a\u00020\u00198\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u001d8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010C\u00a8\u0006_"}, d2={"Lcom/metallicus/protonsdk/model/Account;", "", "accountName", "", "headBlockNum", "", "headBlockTime", "privileged", "", "lastCodeUpdate", "created", "coreLiquidBalance", "ramQuota", "netWeight", "", "cpuWeight", "ramUsage", "netLimit", "Lcom/metallicus/protonsdk/model/AccountNetLimit;", "cpuLimit", "Lcom/metallicus/protonsdk/model/AccountCpuLimit;", "permissions", "", "Lcom/metallicus/protonsdk/model/AccountPermission;", "totalResources", "Lcom/metallicus/protonsdk/model/AccountTotalResources;", "selfDelegatedBandwidth", "Lcom/metallicus/protonsdk/model/AccountSelfDelegatedBandwidth;", "voterInfo", "Lcom/metallicus/protonsdk/model/AccountVoterInfo;", "(Ljava/lang/String;ILjava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;IJJJLcom/metallicus/protonsdk/model/AccountNetLimit;Lcom/metallicus/protonsdk/model/AccountCpuLimit;Ljava/util/List;Lcom/metallicus/protonsdk/model/AccountTotalResources;Lcom/metallicus/protonsdk/model/AccountSelfDelegatedBandwidth;Lcom/metallicus/protonsdk/model/AccountVoterInfo;)V", "accountChainId", "getAccountChainId", "()Ljava/lang/String;", "setAccountChainId", "(Ljava/lang/String;)V", "accountContact", "Lcom/metallicus/protonsdk/model/AccountContact;", "getAccountContact", "()Lcom/metallicus/protonsdk/model/AccountContact;", "setAccountContact", "(Lcom/metallicus/protonsdk/model/AccountContact;)V", "getAccountName", "getCoreLiquidBalance", "getCpuLimit", "()Lcom/metallicus/protonsdk/model/AccountCpuLimit;", "getCpuWeight", "()J", "getCreated", "getHeadBlockNum", "()I", "getHeadBlockTime", "getLastCodeUpdate", "getNetLimit", "()Lcom/metallicus/protonsdk/model/AccountNetLimit;", "getNetWeight", "getPermissions", "()Ljava/util/List;", "getPrivileged", "()Z", "getRamQuota", "getRamUsage", "getSelfDelegatedBandwidth", "()Lcom/metallicus/protonsdk/model/AccountSelfDelegatedBandwidth;", "getTotalResources", "()Lcom/metallicus/protonsdk/model/AccountTotalResources;", "getVoterInfo", "()Lcom/metallicus/protonsdk/model/AccountVoterInfo;", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "getBalance", "getDelegatedCPU", "", "getDelegatedNet", "getSelfDelegatedResources", "hashCode", "toString", "protonsdk_release"})
@Entity
@TypeConverters(value={DefaultTypeConverters.class, EOSTypeConverters.class, ProtonTypeConverters.class})
public final class Account {
    @NotNull
    public String accountChainId;
    @NotNull
    public AccountContact accountContact;
    @SerializedName(value="account_name")
    @PrimaryKey
    @NotNull
    private final String accountName;
    @SerializedName(value="head_block_num")
    private final int headBlockNum;
    @SerializedName(value="head_block_time")
    @NotNull
    private final String headBlockTime;
    @SerializedName(value="privileged")
    private final boolean privileged;
    @SerializedName(value="last_code_update")
    @NotNull
    private final String lastCodeUpdate;
    @SerializedName(value="created")
    @NotNull
    private final String created;
    @SerializedName(value="core_liquid_balance")
    @Nullable
    private final String coreLiquidBalance;
    @SerializedName(value="ram_quota")
    private final int ramQuota;
    @SerializedName(value="net_weight")
    private final long netWeight;
    @SerializedName(value="cpu_weight")
    private final long cpuWeight;
    @SerializedName(value="ram_usage")
    private final long ramUsage;
    @SerializedName(value="net_limit")
    @Embedded(prefix="net_limit_")
    @NotNull
    private final AccountNetLimit netLimit;
    @SerializedName(value="cpu_limit")
    @Embedded(prefix="cpu_limit_")
    @NotNull
    private final AccountCpuLimit cpuLimit;
    @SerializedName(value="permissions")
    @NotNull
    private final List<AccountPermission> permissions;
    @SerializedName(value="total_resources")
    @Embedded(prefix="total_resources_")
    @NotNull
    private final AccountTotalResources totalResources;
    @SerializedName(value="self_delegated_bandwidth")
    @Embedded(prefix="self_delegated_bandwidth_")
    @Nullable
    private final AccountSelfDelegatedBandwidth selfDelegatedBandwidth;
    @SerializedName(value="voter_info")
    @Embedded(prefix="voter_info_")
    @Nullable
    private final AccountVoterInfo voterInfo;

    @NotNull
    public final String getAccountChainId() {
        String string = this.accountChainId;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"accountChainId");
        }
        return string;
    }

    public final void setAccountChainId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.accountChainId = string;
    }

    @NotNull
    public final AccountContact getAccountContact() {
        AccountContact accountContact = this.accountContact;
        if (accountContact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"accountContact");
        }
        return accountContact;
    }

    public final void setAccountContact(@NotNull AccountContact accountContact) {
        Intrinsics.checkNotNullParameter((Object)accountContact, (String)"<set-?>");
        this.accountContact = accountContact;
    }

    @NotNull
    public final String getBalance() {
        String string = this.coreLiquidBalance;
        if (string == null) {
            string = "0";
        }
        return string;
    }

    public final double getDelegatedCPU() {
        double delegatedCPU = 0.0;
        if (this.selfDelegatedBandwidth != null) {
            delegatedCPU = this.totalResources.cpuWeightToDouble() - this.selfDelegatedBandwidth.cpuWeightToDouble();
        }
        return delegatedCPU;
    }

    public final double getDelegatedNet() {
        double delegatedNet = 0.0;
        if (this.selfDelegatedBandwidth != null) {
            delegatedNet = this.totalResources.netWeightToDouble() - this.selfDelegatedBandwidth.netWeightToDouble();
        }
        return delegatedNet;
    }

    public final double getSelfDelegatedResources() {
        double selfDelegatedResources = 0.0;
        if (this.selfDelegatedBandwidth != null) {
            selfDelegatedResources = this.selfDelegatedBandwidth.cpuWeightToDouble() + this.selfDelegatedBandwidth.netWeightToDouble();
        }
        return selfDelegatedResources;
    }

    @NotNull
    public final String getAccountName() {
        return this.accountName;
    }

    public final int getHeadBlockNum() {
        return this.headBlockNum;
    }

    @NotNull
    public final String getHeadBlockTime() {
        return this.headBlockTime;
    }

    public final boolean getPrivileged() {
        return this.privileged;
    }

    @NotNull
    public final String getLastCodeUpdate() {
        return this.lastCodeUpdate;
    }

    @NotNull
    public final String getCreated() {
        return this.created;
    }

    @Nullable
    public final String getCoreLiquidBalance() {
        return this.coreLiquidBalance;
    }

    public final int getRamQuota() {
        return this.ramQuota;
    }

    public final long getNetWeight() {
        return this.netWeight;
    }

    public final long getCpuWeight() {
        return this.cpuWeight;
    }

    public final long getRamUsage() {
        return this.ramUsage;
    }

    @NotNull
    public final AccountNetLimit getNetLimit() {
        return this.netLimit;
    }

    @NotNull
    public final AccountCpuLimit getCpuLimit() {
        return this.cpuLimit;
    }

    @NotNull
    public final List<AccountPermission> getPermissions() {
        return this.permissions;
    }

    @NotNull
    public final AccountTotalResources getTotalResources() {
        return this.totalResources;
    }

    @Nullable
    public final AccountSelfDelegatedBandwidth getSelfDelegatedBandwidth() {
        return this.selfDelegatedBandwidth;
    }

    @Nullable
    public final AccountVoterInfo getVoterInfo() {
        return this.voterInfo;
    }

    public Account(@NotNull String accountName, int headBlockNum, @NotNull String headBlockTime, boolean privileged, @NotNull String lastCodeUpdate, @NotNull String created, @Nullable String coreLiquidBalance, int ramQuota, long netWeight, long cpuWeight, long ramUsage, @NotNull AccountNetLimit netLimit, @NotNull AccountCpuLimit cpuLimit, @NotNull List<AccountPermission> permissions, @NotNull AccountTotalResources totalResources, @Nullable AccountSelfDelegatedBandwidth selfDelegatedBandwidth, @Nullable AccountVoterInfo voterInfo) {
        Intrinsics.checkNotNullParameter((Object)accountName, (String)"accountName");
        Intrinsics.checkNotNullParameter((Object)headBlockTime, (String)"headBlockTime");
        Intrinsics.checkNotNullParameter((Object)lastCodeUpdate, (String)"lastCodeUpdate");
        Intrinsics.checkNotNullParameter((Object)created, (String)"created");
        Intrinsics.checkNotNullParameter((Object)netLimit, (String)"netLimit");
        Intrinsics.checkNotNullParameter((Object)cpuLimit, (String)"cpuLimit");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)totalResources, (String)"totalResources");
        this.accountName = accountName;
        this.headBlockNum = headBlockNum;
        this.headBlockTime = headBlockTime;
        this.privileged = privileged;
        this.lastCodeUpdate = lastCodeUpdate;
        this.created = created;
        this.coreLiquidBalance = coreLiquidBalance;
        this.ramQuota = ramQuota;
        this.netWeight = netWeight;
        this.cpuWeight = cpuWeight;
        this.ramUsage = ramUsage;
        this.netLimit = netLimit;
        this.cpuLimit = cpuLimit;
        this.permissions = permissions;
        this.totalResources = totalResources;
        this.selfDelegatedBandwidth = selfDelegatedBandwidth;
        this.voterInfo = voterInfo;
    }

    @NotNull
    public final String component1() {
        return this.accountName;
    }

    public final int component2() {
        return this.headBlockNum;
    }

    @NotNull
    public final String component3() {
        return this.headBlockTime;
    }

    public final boolean component4() {
        return this.privileged;
    }

    @NotNull
    public final String component5() {
        return this.lastCodeUpdate;
    }

    @NotNull
    public final String component6() {
        return this.created;
    }

    @Nullable
    public final String component7() {
        return this.coreLiquidBalance;
    }

    public final int component8() {
        return this.ramQuota;
    }

    public final long component9() {
        return this.netWeight;
    }

    public final long component10() {
        return this.cpuWeight;
    }

    public final long component11() {
        return this.ramUsage;
    }

    @NotNull
    public final AccountNetLimit component12() {
        return this.netLimit;
    }

    @NotNull
    public final AccountCpuLimit component13() {
        return this.cpuLimit;
    }

    @NotNull
    public final List<AccountPermission> component14() {
        return this.permissions;
    }

    @NotNull
    public final AccountTotalResources component15() {
        return this.totalResources;
    }

    @Nullable
    public final AccountSelfDelegatedBandwidth component16() {
        return this.selfDelegatedBandwidth;
    }

    @Nullable
    public final AccountVoterInfo component17() {
        return this.voterInfo;
    }

    @NotNull
    public final Account copy(@NotNull String accountName, int headBlockNum, @NotNull String headBlockTime, boolean privileged, @NotNull String lastCodeUpdate, @NotNull String created, @Nullable String coreLiquidBalance, int ramQuota, long netWeight, long cpuWeight, long ramUsage, @NotNull AccountNetLimit netLimit, @NotNull AccountCpuLimit cpuLimit, @NotNull List<AccountPermission> permissions, @NotNull AccountTotalResources totalResources, @Nullable AccountSelfDelegatedBandwidth selfDelegatedBandwidth, @Nullable AccountVoterInfo voterInfo) {
        Intrinsics.checkNotNullParameter((Object)accountName, (String)"accountName");
        Intrinsics.checkNotNullParameter((Object)headBlockTime, (String)"headBlockTime");
        Intrinsics.checkNotNullParameter((Object)lastCodeUpdate, (String)"lastCodeUpdate");
        Intrinsics.checkNotNullParameter((Object)created, (String)"created");
        Intrinsics.checkNotNullParameter((Object)netLimit, (String)"netLimit");
        Intrinsics.checkNotNullParameter((Object)cpuLimit, (String)"cpuLimit");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)totalResources, (String)"totalResources");
        return new Account(accountName, headBlockNum, headBlockTime, privileged, lastCodeUpdate, created, coreLiquidBalance, ramQuota, netWeight, cpuWeight, ramUsage, netLimit, cpuLimit, permissions, totalResources, selfDelegatedBandwidth, voterInfo);
    }

    public static /* synthetic */ Account copy$default(Account account, String string, int n, String string2, boolean bl, String string3, String string4, String string5, int n2, long l, long l2, long l3, AccountNetLimit accountNetLimit, AccountCpuLimit accountCpuLimit, List list, AccountTotalResources accountTotalResources, AccountSelfDelegatedBandwidth accountSelfDelegatedBandwidth, AccountVoterInfo accountVoterInfo, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = account.accountName;
        }
        if ((n3 & 2) != 0) {
            n = account.headBlockNum;
        }
        if ((n3 & 4) != 0) {
            string2 = account.headBlockTime;
        }
        if ((n3 & 8) != 0) {
            bl = account.privileged;
        }
        if ((n3 & 0x10) != 0) {
            string3 = account.lastCodeUpdate;
        }
        if ((n3 & 0x20) != 0) {
            string4 = account.created;
        }
        if ((n3 & 0x40) != 0) {
            string5 = account.coreLiquidBalance;
        }
        if ((n3 & 0x80) != 0) {
            n2 = account.ramQuota;
        }
        if ((n3 & 0x100) != 0) {
            l = account.netWeight;
        }
        if ((n3 & 0x200) != 0) {
            l2 = account.cpuWeight;
        }
        if ((n3 & 0x400) != 0) {
            l3 = account.ramUsage;
        }
        if ((n3 & 0x800) != 0) {
            accountNetLimit = account.netLimit;
        }
        if ((n3 & 0x1000) != 0) {
            accountCpuLimit = account.cpuLimit;
        }
        if ((n3 & 0x2000) != 0) {
            list = account.permissions;
        }
        if ((n3 & 0x4000) != 0) {
            accountTotalResources = account.totalResources;
        }
        if ((n3 & 0x8000) != 0) {
            accountSelfDelegatedBandwidth = account.selfDelegatedBandwidth;
        }
        if ((n3 & 0x10000) != 0) {
            accountVoterInfo = account.voterInfo;
        }
        return account.copy(string, n, string2, bl, string3, string4, string5, n2, l, l2, l3, accountNetLimit, accountCpuLimit, list, accountTotalResources, accountSelfDelegatedBandwidth, accountVoterInfo);
    }

    @NotNull
    public String toString() {
        return "Account(accountName=" + this.accountName + ", headBlockNum=" + this.headBlockNum + ", headBlockTime=" + this.headBlockTime + ", privileged=" + this.privileged + ", lastCodeUpdate=" + this.lastCodeUpdate + ", created=" + this.created + ", coreLiquidBalance=" + this.coreLiquidBalance + ", ramQuota=" + this.ramQuota + ", netWeight=" + this.netWeight + ", cpuWeight=" + this.cpuWeight + ", ramUsage=" + this.ramUsage + ", netLimit=" + this.netLimit + ", cpuLimit=" + this.cpuLimit + ", permissions=" + this.permissions + ", totalResources=" + this.totalResources + ", selfDelegatedBandwidth=" + this.selfDelegatedBandwidth + ", voterInfo=" + this.voterInfo + ")";
    }

    public int hashCode() {
        String string = this.accountName;
        String string2 = this.headBlockTime;
        int n = (((string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.headBlockNum)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31;
        int n2 = this.privileged ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        String string3 = this.lastCodeUpdate;
        String string4 = this.created;
        String string5 = this.coreLiquidBalance;
        AccountNetLimit accountNetLimit = this.netLimit;
        AccountCpuLimit accountCpuLimit = this.cpuLimit;
        List<AccountPermission> list = this.permissions;
        AccountTotalResources accountTotalResources = this.totalResources;
        AccountSelfDelegatedBandwidth accountSelfDelegatedBandwidth = this.selfDelegatedBandwidth;
        AccountVoterInfo accountVoterInfo = this.voterInfo;
        return (((((((((((((n + n2) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + Integer.hashCode(this.ramQuota)) * 31 + Long.hashCode(this.netWeight)) * 31 + Long.hashCode(this.cpuWeight)) * 31 + Long.hashCode(this.ramUsage)) * 31 + (accountNetLimit != null ? ((Object)accountNetLimit).hashCode() : 0)) * 31 + (accountCpuLimit != null ? ((Object)accountCpuLimit).hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (accountTotalResources != null ? ((Object)accountTotalResources).hashCode() : 0)) * 31 + (accountSelfDelegatedBandwidth != null ? ((Object)accountSelfDelegatedBandwidth).hashCode() : 0)) * 31 + (accountVoterInfo != null ? ((Object)accountVoterInfo).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Account)) break block3;
                Account account = (Account)object;
                if (!Intrinsics.areEqual((Object)this.accountName, (Object)account.accountName) || this.headBlockNum != account.headBlockNum || !Intrinsics.areEqual((Object)this.headBlockTime, (Object)account.headBlockTime) || this.privileged != account.privileged || !Intrinsics.areEqual((Object)this.lastCodeUpdate, (Object)account.lastCodeUpdate) || !Intrinsics.areEqual((Object)this.created, (Object)account.created) || !Intrinsics.areEqual((Object)this.coreLiquidBalance, (Object)account.coreLiquidBalance) || this.ramQuota != account.ramQuota || this.netWeight != account.netWeight || this.cpuWeight != account.cpuWeight || this.ramUsage != account.ramUsage || !Intrinsics.areEqual((Object)this.netLimit, (Object)account.netLimit) || !Intrinsics.areEqual((Object)this.cpuLimit, (Object)account.cpuLimit) || !Intrinsics.areEqual(this.permissions, account.permissions) || !Intrinsics.areEqual((Object)this.totalResources, (Object)account.totalResources) || !Intrinsics.areEqual((Object)this.selfDelegatedBandwidth, (Object)account.selfDelegatedBandwidth) || !Intrinsics.areEqual((Object)this.voterInfo, (Object)account.voterInfo)) break block3;
            }
            return true;
        }
        return false;
    }
}

