/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.db;

import android.database.Cursor;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.metallicus.protonsdk.db.AccountDao;
import com.metallicus.protonsdk.db.EOSTypeConverters;
import com.metallicus.protonsdk.db.ProtonTypeConverters;
import com.metallicus.protonsdk.model.Account;
import com.metallicus.protonsdk.model.AccountCpuLimit;
import com.metallicus.protonsdk.model.AccountNetLimit;
import com.metallicus.protonsdk.model.AccountPermission;
import com.metallicus.protonsdk.model.AccountSelfDelegatedBandwidth;
import com.metallicus.protonsdk.model.AccountTotalResources;
import com.metallicus.protonsdk.model.AccountVoterInfo;
import com.metallicus.protonsdk.model.ChainAccount;
import com.metallicus.protonsdk.model.ChainProvider;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class AccountDao_Impl
implements AccountDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Account> __insertionAdapterOfAccount;
    private final EntityDeletionOrUpdateAdapter<Account> __updateAdapterOfAccount;
    private final SharedSQLiteStatement __preparedStmtOfRemoveAll;

    public AccountDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfAccount = new EntityInsertionAdapter<Account>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Account` (`accountChainId`,`accountContact`,`accountName`,`headBlockNum`,`headBlockTime`,`privileged`,`lastCodeUpdate`,`created`,`coreLiquidBalance`,`ramQuota`,`netWeight`,`cpuWeight`,`ramUsage`,`permissions`,`net_limit_used`,`net_limit_available`,`net_limit_max`,`cpu_limit_used`,`cpu_limit_available`,`cpu_limit_max`,`total_resources_owner`,`total_resources_netWeight`,`total_resources_cpuWeight`,`total_resources_ramBytes`,`self_delegated_bandwidth_from`,`self_delegated_bandwidth_to`,`self_delegated_bandwidth_netWeight`,`self_delegated_bandwidth_cpuWeight`,`voter_info_owner`,`voter_info_proxy`,`voter_info_staked`,`voter_info_lastVoteWeight`,`voter_info_proxiedVoteWeight`,`voter_info_isProxy`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Account value) {
                if (value.accountChainId == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.accountChainId);
                }
                String _tmp = ProtonTypeConverters.accountContactToString(value.accountContact);
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                if (value.getAccountName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getAccountName());
                }
                stmt.bindLong(4, (long)value.getHeadBlockNum());
                if (value.getHeadBlockTime() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getHeadBlockTime());
                }
                int _tmp_1 = value.getPrivileged() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_1);
                if (value.getLastCodeUpdate() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getLastCodeUpdate());
                }
                if (value.getCreated() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getCreated());
                }
                if (value.getCoreLiquidBalance() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getCoreLiquidBalance());
                }
                stmt.bindLong(10, (long)value.getRamQuota());
                stmt.bindLong(11, value.getNetWeight());
                stmt.bindLong(12, value.getCpuWeight());
                stmt.bindLong(13, value.getRamUsage());
                String _tmp_2 = EOSTypeConverters.accountPermissionListToString(value.getPermissions());
                if (_tmp_2 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_2);
                }
                AccountNetLimit _tmpNetLimit = value.getNetLimit();
                if (_tmpNetLimit != null) {
                    stmt.bindLong(15, _tmpNetLimit.getUsed());
                    stmt.bindLong(16, _tmpNetLimit.getAvailable());
                    stmt.bindLong(17, _tmpNetLimit.getMax());
                } else {
                    stmt.bindNull(15);
                    stmt.bindNull(16);
                    stmt.bindNull(17);
                }
                AccountCpuLimit _tmpCpuLimit = value.getCpuLimit();
                if (_tmpCpuLimit != null) {
                    stmt.bindLong(18, _tmpCpuLimit.getUsed());
                    stmt.bindLong(19, _tmpCpuLimit.getAvailable());
                    stmt.bindLong(20, _tmpCpuLimit.getMax());
                } else {
                    stmt.bindNull(18);
                    stmt.bindNull(19);
                    stmt.bindNull(20);
                }
                AccountTotalResources _tmpTotalResources = value.getTotalResources();
                if (_tmpTotalResources != null) {
                    if (_tmpTotalResources.getOwner() == null) {
                        stmt.bindNull(21);
                    } else {
                        stmt.bindString(21, _tmpTotalResources.getOwner());
                    }
                    if (_tmpTotalResources.getNetWeight() == null) {
                        stmt.bindNull(22);
                    } else {
                        stmt.bindString(22, _tmpTotalResources.getNetWeight());
                    }
                    if (_tmpTotalResources.getCpuWeight() == null) {
                        stmt.bindNull(23);
                    } else {
                        stmt.bindString(23, _tmpTotalResources.getCpuWeight());
                    }
                    stmt.bindLong(24, (long)_tmpTotalResources.getRamBytes());
                } else {
                    stmt.bindNull(21);
                    stmt.bindNull(22);
                    stmt.bindNull(23);
                    stmt.bindNull(24);
                }
                AccountSelfDelegatedBandwidth _tmpSelfDelegatedBandwidth = value.getSelfDelegatedBandwidth();
                if (_tmpSelfDelegatedBandwidth != null) {
                    if (_tmpSelfDelegatedBandwidth.getFrom() == null) {
                        stmt.bindNull(25);
                    } else {
                        stmt.bindString(25, _tmpSelfDelegatedBandwidth.getFrom());
                    }
                    if (_tmpSelfDelegatedBandwidth.getTo() == null) {
                        stmt.bindNull(26);
                    } else {
                        stmt.bindString(26, _tmpSelfDelegatedBandwidth.getTo());
                    }
                    if (_tmpSelfDelegatedBandwidth.getNetWeight() == null) {
                        stmt.bindNull(27);
                    } else {
                        stmt.bindString(27, _tmpSelfDelegatedBandwidth.getNetWeight());
                    }
                    if (_tmpSelfDelegatedBandwidth.getCpuWeight() == null) {
                        stmt.bindNull(28);
                    } else {
                        stmt.bindString(28, _tmpSelfDelegatedBandwidth.getCpuWeight());
                    }
                } else {
                    stmt.bindNull(25);
                    stmt.bindNull(26);
                    stmt.bindNull(27);
                    stmt.bindNull(28);
                }
                AccountVoterInfo _tmpVoterInfo = value.getVoterInfo();
                if (_tmpVoterInfo != null) {
                    if (_tmpVoterInfo.getOwner() == null) {
                        stmt.bindNull(29);
                    } else {
                        stmt.bindString(29, _tmpVoterInfo.getOwner());
                    }
                    if (_tmpVoterInfo.getProxy() == null) {
                        stmt.bindNull(30);
                    } else {
                        stmt.bindString(30, _tmpVoterInfo.getProxy());
                    }
                    stmt.bindLong(31, _tmpVoterInfo.getStaked());
                    if (_tmpVoterInfo.getLastVoteWeight() == null) {
                        stmt.bindNull(32);
                    } else {
                        stmt.bindString(32, _tmpVoterInfo.getLastVoteWeight());
                    }
                    if (_tmpVoterInfo.getProxiedVoteWeight() == null) {
                        stmt.bindNull(33);
                    } else {
                        stmt.bindString(33, _tmpVoterInfo.getProxiedVoteWeight());
                    }
                    stmt.bindLong(34, (long)_tmpVoterInfo.isProxy());
                } else {
                    stmt.bindNull(29);
                    stmt.bindNull(30);
                    stmt.bindNull(31);
                    stmt.bindNull(32);
                    stmt.bindNull(33);
                    stmt.bindNull(34);
                }
            }
        };
        this.__updateAdapterOfAccount = new EntityDeletionOrUpdateAdapter<Account>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `Account` SET `accountChainId` = ?,`accountContact` = ?,`accountName` = ?,`headBlockNum` = ?,`headBlockTime` = ?,`privileged` = ?,`lastCodeUpdate` = ?,`created` = ?,`coreLiquidBalance` = ?,`ramQuota` = ?,`netWeight` = ?,`cpuWeight` = ?,`ramUsage` = ?,`permissions` = ?,`net_limit_used` = ?,`net_limit_available` = ?,`net_limit_max` = ?,`cpu_limit_used` = ?,`cpu_limit_available` = ?,`cpu_limit_max` = ?,`total_resources_owner` = ?,`total_resources_netWeight` = ?,`total_resources_cpuWeight` = ?,`total_resources_ramBytes` = ?,`self_delegated_bandwidth_from` = ?,`self_delegated_bandwidth_to` = ?,`self_delegated_bandwidth_netWeight` = ?,`self_delegated_bandwidth_cpuWeight` = ?,`voter_info_owner` = ?,`voter_info_proxy` = ?,`voter_info_staked` = ?,`voter_info_lastVoteWeight` = ?,`voter_info_proxiedVoteWeight` = ?,`voter_info_isProxy` = ? WHERE `accountName` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Account value) {
                if (value.accountChainId == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.accountChainId);
                }
                String _tmp = ProtonTypeConverters.accountContactToString(value.accountContact);
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                if (value.getAccountName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getAccountName());
                }
                stmt.bindLong(4, (long)value.getHeadBlockNum());
                if (value.getHeadBlockTime() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getHeadBlockTime());
                }
                int _tmp_1 = value.getPrivileged() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_1);
                if (value.getLastCodeUpdate() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getLastCodeUpdate());
                }
                if (value.getCreated() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getCreated());
                }
                if (value.getCoreLiquidBalance() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getCoreLiquidBalance());
                }
                stmt.bindLong(10, (long)value.getRamQuota());
                stmt.bindLong(11, value.getNetWeight());
                stmt.bindLong(12, value.getCpuWeight());
                stmt.bindLong(13, value.getRamUsage());
                String _tmp_2 = EOSTypeConverters.accountPermissionListToString(value.getPermissions());
                if (_tmp_2 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_2);
                }
                AccountNetLimit _tmpNetLimit = value.getNetLimit();
                if (_tmpNetLimit != null) {
                    stmt.bindLong(15, _tmpNetLimit.getUsed());
                    stmt.bindLong(16, _tmpNetLimit.getAvailable());
                    stmt.bindLong(17, _tmpNetLimit.getMax());
                } else {
                    stmt.bindNull(15);
                    stmt.bindNull(16);
                    stmt.bindNull(17);
                }
                AccountCpuLimit _tmpCpuLimit = value.getCpuLimit();
                if (_tmpCpuLimit != null) {
                    stmt.bindLong(18, _tmpCpuLimit.getUsed());
                    stmt.bindLong(19, _tmpCpuLimit.getAvailable());
                    stmt.bindLong(20, _tmpCpuLimit.getMax());
                } else {
                    stmt.bindNull(18);
                    stmt.bindNull(19);
                    stmt.bindNull(20);
                }
                AccountTotalResources _tmpTotalResources = value.getTotalResources();
                if (_tmpTotalResources != null) {
                    if (_tmpTotalResources.getOwner() == null) {
                        stmt.bindNull(21);
                    } else {
                        stmt.bindString(21, _tmpTotalResources.getOwner());
                    }
                    if (_tmpTotalResources.getNetWeight() == null) {
                        stmt.bindNull(22);
                    } else {
                        stmt.bindString(22, _tmpTotalResources.getNetWeight());
                    }
                    if (_tmpTotalResources.getCpuWeight() == null) {
                        stmt.bindNull(23);
                    } else {
                        stmt.bindString(23, _tmpTotalResources.getCpuWeight());
                    }
                    stmt.bindLong(24, (long)_tmpTotalResources.getRamBytes());
                } else {
                    stmt.bindNull(21);
                    stmt.bindNull(22);
                    stmt.bindNull(23);
                    stmt.bindNull(24);
                }
                AccountSelfDelegatedBandwidth _tmpSelfDelegatedBandwidth = value.getSelfDelegatedBandwidth();
                if (_tmpSelfDelegatedBandwidth != null) {
                    if (_tmpSelfDelegatedBandwidth.getFrom() == null) {
                        stmt.bindNull(25);
                    } else {
                        stmt.bindString(25, _tmpSelfDelegatedBandwidth.getFrom());
                    }
                    if (_tmpSelfDelegatedBandwidth.getTo() == null) {
                        stmt.bindNull(26);
                    } else {
                        stmt.bindString(26, _tmpSelfDelegatedBandwidth.getTo());
                    }
                    if (_tmpSelfDelegatedBandwidth.getNetWeight() == null) {
                        stmt.bindNull(27);
                    } else {
                        stmt.bindString(27, _tmpSelfDelegatedBandwidth.getNetWeight());
                    }
                    if (_tmpSelfDelegatedBandwidth.getCpuWeight() == null) {
                        stmt.bindNull(28);
                    } else {
                        stmt.bindString(28, _tmpSelfDelegatedBandwidth.getCpuWeight());
                    }
                } else {
                    stmt.bindNull(25);
                    stmt.bindNull(26);
                    stmt.bindNull(27);
                    stmt.bindNull(28);
                }
                AccountVoterInfo _tmpVoterInfo = value.getVoterInfo();
                if (_tmpVoterInfo != null) {
                    if (_tmpVoterInfo.getOwner() == null) {
                        stmt.bindNull(29);
                    } else {
                        stmt.bindString(29, _tmpVoterInfo.getOwner());
                    }
                    if (_tmpVoterInfo.getProxy() == null) {
                        stmt.bindNull(30);
                    } else {
                        stmt.bindString(30, _tmpVoterInfo.getProxy());
                    }
                    stmt.bindLong(31, _tmpVoterInfo.getStaked());
                    if (_tmpVoterInfo.getLastVoteWeight() == null) {
                        stmt.bindNull(32);
                    } else {
                        stmt.bindString(32, _tmpVoterInfo.getLastVoteWeight());
                    }
                    if (_tmpVoterInfo.getProxiedVoteWeight() == null) {
                        stmt.bindNull(33);
                    } else {
                        stmt.bindString(33, _tmpVoterInfo.getProxiedVoteWeight());
                    }
                    stmt.bindLong(34, (long)_tmpVoterInfo.isProxy());
                } else {
                    stmt.bindNull(29);
                    stmt.bindNull(30);
                    stmt.bindNull(31);
                    stmt.bindNull(32);
                    stmt.bindNull(33);
                    stmt.bindNull(34);
                }
                if (value.getAccountName() == null) {
                    stmt.bindNull(35);
                } else {
                    stmt.bindString(35, value.getAccountName());
                }
            }
        };
        this.__preparedStmtOfRemoveAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM account";
                return "DELETE FROM account";
            }
        };
    }

    @Override
    public Object insert(final Account account, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AccountDao_Impl.this.__db.beginTransaction();
                try {
                    AccountDao_Impl.this.__insertionAdapterOfAccount.insert((Object)account);
                    AccountDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object update(final Account account, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AccountDao_Impl.this.__db.beginTransaction();
                try {
                    AccountDao_Impl.this.__updateAdapterOfAccount.handle((Object)account);
                    AccountDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object removeAll(Continuation<? super Unit> p0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = AccountDao_Impl.this.__preparedStmtOfRemoveAll.acquire();
                AccountDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    AccountDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountDao_Impl.this.__db.endTransaction();
                    AccountDao_Impl.this.__preparedStmtOfRemoveAll.release(_stmt);
                }
            }
        }, p0);
    }

    @Override
    public Object findByAccountName(String accountName, Continuation<? super ChainAccount> p1) {
        String _sql = "SELECT * FROM account WHERE accountName = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM account WHERE accountName = ?", (int)1);
        int _argIndex = 1;
        if (accountName == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountName);
        }
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<ChainAccount>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ChainAccount call() throws Exception {
                AccountDao_Impl.this.__db.beginTransaction();
                try {
                    ChainAccount chainAccount;
                    Cursor _cursor = DBUtil.query((RoomDatabase)AccountDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        ChainAccount _result;
                        int _cursorIndexOfAccountChainId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accountChainId");
                        int _cursorIndexOfAccountContact = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accountContact");
                        int _cursorIndexOfAccountName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accountName");
                        int _cursorIndexOfHeadBlockNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"headBlockNum");
                        int _cursorIndexOfHeadBlockTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"headBlockTime");
                        int _cursorIndexOfPrivileged = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"privileged");
                        int _cursorIndexOfLastCodeUpdate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastCodeUpdate");
                        int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created");
                        int _cursorIndexOfCoreLiquidBalance = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coreLiquidBalance");
                        int _cursorIndexOfRamQuota = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ramQuota");
                        int _cursorIndexOfNetWeight = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"netWeight");
                        int _cursorIndexOfCpuWeight = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpuWeight");
                        int _cursorIndexOfRamUsage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ramUsage");
                        int _cursorIndexOfPermissions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"permissions");
                        int _cursorIndexOfUsed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"net_limit_used");
                        int _cursorIndexOfAvailable = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"net_limit_available");
                        int _cursorIndexOfMax = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"net_limit_max");
                        int _cursorIndexOfUsed_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpu_limit_used");
                        int _cursorIndexOfAvailable_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpu_limit_available");
                        int _cursorIndexOfMax_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpu_limit_max");
                        int _cursorIndexOfOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"total_resources_owner");
                        int _cursorIndexOfNetWeight_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"total_resources_netWeight");
                        int _cursorIndexOfCpuWeight_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"total_resources_cpuWeight");
                        int _cursorIndexOfRamBytes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"total_resources_ramBytes");
                        int _cursorIndexOfFrom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"self_delegated_bandwidth_from");
                        int _cursorIndexOfTo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"self_delegated_bandwidth_to");
                        int _cursorIndexOfNetWeight_2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"self_delegated_bandwidth_netWeight");
                        int _cursorIndexOfCpuWeight_2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"self_delegated_bandwidth_cpuWeight");
                        int _cursorIndexOfOwner_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"voter_info_owner");
                        int _cursorIndexOfProxy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"voter_info_proxy");
                        int _cursorIndexOfStaked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"voter_info_staked");
                        int _cursorIndexOfLastVoteWeight = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"voter_info_lastVoteWeight");
                        int _cursorIndexOfProxiedVoteWeight = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"voter_info_proxiedVoteWeight");
                        int _cursorIndexOfIsProxy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"voter_info_isProxy");
                        ArrayMap _collectionChainProvider = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey = _cursor.getString(_cursorIndexOfAccountChainId);
                            _collectionChainProvider.put((Object)_tmpKey, null);
                        }
                        _cursor.moveToPosition(-1);
                        AccountDao_Impl.this.__fetchRelationshipChainProviderAscomMetallicusProtonsdkModelChainProvider((ArrayMap<String, ChainProvider>)_collectionChainProvider);
                        if (_cursor.moveToFirst()) {
                            Account _tmpAccount;
                            if (!(_cursor.isNull(_cursorIndexOfAccountChainId) && _cursor.isNull(_cursorIndexOfAccountContact) && _cursor.isNull(_cursorIndexOfAccountName) && _cursor.isNull(_cursorIndexOfHeadBlockNum) && _cursor.isNull(_cursorIndexOfHeadBlockTime) && _cursor.isNull(_cursorIndexOfPrivileged) && _cursor.isNull(_cursorIndexOfLastCodeUpdate) && _cursor.isNull(_cursorIndexOfCreated) && _cursor.isNull(_cursorIndexOfCoreLiquidBalance) && _cursor.isNull(_cursorIndexOfRamQuota) && _cursor.isNull(_cursorIndexOfNetWeight) && _cursor.isNull(_cursorIndexOfCpuWeight) && _cursor.isNull(_cursorIndexOfRamUsage) && _cursor.isNull(_cursorIndexOfPermissions) && _cursor.isNull(_cursorIndexOfUsed) && _cursor.isNull(_cursorIndexOfAvailable) && _cursor.isNull(_cursorIndexOfMax) && _cursor.isNull(_cursorIndexOfUsed_1) && _cursor.isNull(_cursorIndexOfAvailable_1) && _cursor.isNull(_cursorIndexOfMax_1) && _cursor.isNull(_cursorIndexOfOwner) && _cursor.isNull(_cursorIndexOfNetWeight_1) && _cursor.isNull(_cursorIndexOfCpuWeight_1) && _cursor.isNull(_cursorIndexOfRamBytes) && _cursor.isNull(_cursorIndexOfFrom) && _cursor.isNull(_cursorIndexOfTo) && _cursor.isNull(_cursorIndexOfNetWeight_2) && _cursor.isNull(_cursorIndexOfCpuWeight_2) && _cursor.isNull(_cursorIndexOfOwner_1) && _cursor.isNull(_cursorIndexOfProxy) && _cursor.isNull(_cursorIndexOfStaked) && _cursor.isNull(_cursorIndexOfLastVoteWeight) && _cursor.isNull(_cursorIndexOfProxiedVoteWeight) && _cursor.isNull(_cursorIndexOfIsProxy))) {
                                AccountVoterInfo _tmpVoterInfo;
                                AccountSelfDelegatedBandwidth _tmpSelfDelegatedBandwidth;
                                AccountTotalResources _tmpTotalResources;
                                AccountCpuLimit _tmpCpuLimit;
                                AccountNetLimit _tmpNetLimit;
                                String _tmpAccountName = _cursor.getString(_cursorIndexOfAccountName);
                                int _tmpHeadBlockNum = _cursor.getInt(_cursorIndexOfHeadBlockNum);
                                String _tmpHeadBlockTime = _cursor.getString(_cursorIndexOfHeadBlockTime);
                                int _tmp = _cursor.getInt(_cursorIndexOfPrivileged);
                                boolean _tmpPrivileged = _tmp != 0;
                                String _tmpLastCodeUpdate = _cursor.getString(_cursorIndexOfLastCodeUpdate);
                                String _tmpCreated = _cursor.getString(_cursorIndexOfCreated);
                                String _tmpCoreLiquidBalance = _cursor.getString(_cursorIndexOfCoreLiquidBalance);
                                int _tmpRamQuota = _cursor.getInt(_cursorIndexOfRamQuota);
                                long _tmpNetWeight = _cursor.getLong(_cursorIndexOfNetWeight);
                                long _tmpCpuWeight = _cursor.getLong(_cursorIndexOfCpuWeight);
                                long _tmpRamUsage = _cursor.getLong(_cursorIndexOfRamUsage);
                                String _tmp_1 = _cursor.getString(_cursorIndexOfPermissions);
                                List<AccountPermission> _tmpPermissions = EOSTypeConverters.stringToAccountPermissionList(_tmp_1);
                                if (!(_cursor.isNull(_cursorIndexOfUsed) && _cursor.isNull(_cursorIndexOfAvailable) && _cursor.isNull(_cursorIndexOfMax))) {
                                    long _tmpUsed = _cursor.getLong(_cursorIndexOfUsed);
                                    long _tmpAvailable = _cursor.getLong(_cursorIndexOfAvailable);
                                    long _tmpMax = _cursor.getLong(_cursorIndexOfMax);
                                    _tmpNetLimit = new AccountNetLimit(_tmpUsed, _tmpAvailable, _tmpMax);
                                } else {
                                    _tmpNetLimit = null;
                                }
                                if (!(_cursor.isNull(_cursorIndexOfUsed_1) && _cursor.isNull(_cursorIndexOfAvailable_1) && _cursor.isNull(_cursorIndexOfMax_1))) {
                                    long _tmpUsed_1 = _cursor.getLong(_cursorIndexOfUsed_1);
                                    long _tmpAvailable_1 = _cursor.getLong(_cursorIndexOfAvailable_1);
                                    long _tmpMax_1 = _cursor.getLong(_cursorIndexOfMax_1);
                                    _tmpCpuLimit = new AccountCpuLimit(_tmpUsed_1, _tmpAvailable_1, _tmpMax_1);
                                } else {
                                    _tmpCpuLimit = null;
                                }
                                if (!(_cursor.isNull(_cursorIndexOfOwner) && _cursor.isNull(_cursorIndexOfNetWeight_1) && _cursor.isNull(_cursorIndexOfCpuWeight_1) && _cursor.isNull(_cursorIndexOfRamBytes))) {
                                    String _tmpOwner = _cursor.getString(_cursorIndexOfOwner);
                                    String _tmpNetWeight_1 = _cursor.getString(_cursorIndexOfNetWeight_1);
                                    String _tmpCpuWeight_1 = _cursor.getString(_cursorIndexOfCpuWeight_1);
                                    int _tmpRamBytes = _cursor.getInt(_cursorIndexOfRamBytes);
                                    _tmpTotalResources = new AccountTotalResources(_tmpOwner, _tmpNetWeight_1, _tmpCpuWeight_1, _tmpRamBytes);
                                } else {
                                    _tmpTotalResources = null;
                                }
                                if (!(_cursor.isNull(_cursorIndexOfFrom) && _cursor.isNull(_cursorIndexOfTo) && _cursor.isNull(_cursorIndexOfNetWeight_2) && _cursor.isNull(_cursorIndexOfCpuWeight_2))) {
                                    String _tmpFrom = _cursor.getString(_cursorIndexOfFrom);
                                    String _tmpTo = _cursor.getString(_cursorIndexOfTo);
                                    String _tmpNetWeight_2 = _cursor.getString(_cursorIndexOfNetWeight_2);
                                    String _tmpCpuWeight_2 = _cursor.getString(_cursorIndexOfCpuWeight_2);
                                    _tmpSelfDelegatedBandwidth = new AccountSelfDelegatedBandwidth(_tmpFrom, _tmpTo, _tmpNetWeight_2, _tmpCpuWeight_2);
                                } else {
                                    _tmpSelfDelegatedBandwidth = null;
                                }
                                if (!(_cursor.isNull(_cursorIndexOfOwner_1) && _cursor.isNull(_cursorIndexOfProxy) && _cursor.isNull(_cursorIndexOfStaked) && _cursor.isNull(_cursorIndexOfLastVoteWeight) && _cursor.isNull(_cursorIndexOfProxiedVoteWeight) && _cursor.isNull(_cursorIndexOfIsProxy))) {
                                    String _tmpOwner_1 = _cursor.getString(_cursorIndexOfOwner_1);
                                    String _tmpProxy = _cursor.getString(_cursorIndexOfProxy);
                                    long _tmpStaked = _cursor.getLong(_cursorIndexOfStaked);
                                    String _tmpLastVoteWeight = _cursor.getString(_cursorIndexOfLastVoteWeight);
                                    String _tmpProxiedVoteWeight = _cursor.getString(_cursorIndexOfProxiedVoteWeight);
                                    int _tmpIsProxy = _cursor.getInt(_cursorIndexOfIsProxy);
                                    _tmpVoterInfo = new AccountVoterInfo(_tmpOwner_1, _tmpProxy, _tmpStaked, _tmpLastVoteWeight, _tmpProxiedVoteWeight, _tmpIsProxy);
                                } else {
                                    _tmpVoterInfo = null;
                                }
                                _tmpAccount = new Account(_tmpAccountName, _tmpHeadBlockNum, _tmpHeadBlockTime, _tmpPrivileged, _tmpLastCodeUpdate, _tmpCreated, _tmpCoreLiquidBalance, _tmpRamQuota, _tmpNetWeight, _tmpCpuWeight, _tmpRamUsage, _tmpNetLimit, _tmpCpuLimit, _tmpPermissions, _tmpTotalResources, _tmpSelfDelegatedBandwidth, _tmpVoterInfo);
                                _tmpAccount.accountChainId = _cursor.getString(_cursorIndexOfAccountChainId);
                                String _tmp_2 = _cursor.getString(_cursorIndexOfAccountContact);
                                _tmpAccount.accountContact = ProtonTypeConverters.stringToAccountContact(_tmp_2);
                            } else {
                                _tmpAccount = null;
                            }
                            ChainProvider _tmpChainProvider = null;
                            String _tmpKey_1 = _cursor.getString(_cursorIndexOfAccountChainId);
                            _tmpChainProvider = (ChainProvider)_collectionChainProvider.get((Object)_tmpKey_1);
                            _result = new ChainAccount(_tmpAccount, _tmpChainProvider);
                        } else {
                            _result = null;
                        }
                        AccountDao_Impl.this.__db.setTransactionSuccessful();
                        chainAccount = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return chainAccount;
                }
                finally {
                    AccountDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __fetchRelationshipChainProviderAscomMetallicusProtonsdkModelChainProvider(ArrayMap<String, ChainProvider> _map) {
        Set __mapKeySet = _map.keySet();
        if (__mapKeySet.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            ArrayMap _tmpInnerMap = new ArrayMap(999);
            int _tmpIndex = 0;
            int _limit = _map.size();
            for (int _mapIndex = 0; _mapIndex < _limit; ++_mapIndex) {
                _tmpInnerMap.put(_map.keyAt(_mapIndex), null);
                if (++_tmpIndex != 999) continue;
                this.__fetchRelationshipChainProviderAscomMetallicusProtonsdkModelChainProvider((ArrayMap<String, ChainProvider>)_tmpInnerMap);
                _map.putAll((Map)_tmpInnerMap);
                _tmpInnerMap = new ArrayMap(999);
                _tmpIndex = 0;
            }
            if (_tmpIndex > 0) {
                this.__fetchRelationshipChainProviderAscomMetallicusProtonsdkModelChainProvider((ArrayMap<String, ChainProvider>)_tmpInnerMap);
                _map.putAll((Map)_tmpInnerMap);
            }
            return;
        }
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT `chainApiUrl`,`chainId`,`name`,`description`,`iconUrl`,`isTestnet`,`chainUrl`,`hyperionHistoryUrl`,`explorerName`,`explorerUrl`,`resourceTokenSymbol`,`resourceTokenContract`,`systemTokenSymbol`,`systemTokenContract`,`createAccountPath`,`updateAccountAvatarPath`,`updateAccountNamePath`,`exchangeRatePath` FROM `ChainProvider` WHERE `chainId` IN (");
        int _inputSize = __mapKeySet.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : __mapKeySet) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_stmt, (boolean)false, null);){
            int _itemKeyIndex = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"chainId");
            if (_itemKeyIndex == -1) {
                return;
            }
            int _cursorIndexOfChainApiUrl = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"chainApiUrl");
            int _cursorIndexOfChainId = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"chainId");
            int _cursorIndexOfName = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"name");
            int _cursorIndexOfDescription = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"description");
            int _cursorIndexOfIconUrl = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"iconUrl");
            int _cursorIndexOfIsTestnet = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"isTestnet");
            int _cursorIndexOfChainUrl = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"chainUrl");
            int _cursorIndexOfHyperionHistoryUrl = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"hyperionHistoryUrl");
            int _cursorIndexOfExplorerName = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"explorerName");
            int _cursorIndexOfExplorerUrl = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"explorerUrl");
            int _cursorIndexOfResourceTokenSymbol = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"resourceTokenSymbol");
            int _cursorIndexOfResourceTokenContract = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"resourceTokenContract");
            int _cursorIndexOfSystemTokenSymbol = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"systemTokenSymbol");
            int _cursorIndexOfSystemTokenContract = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"systemTokenContract");
            int _cursorIndexOfCreateAccountPath = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"createAccountPath");
            int _cursorIndexOfUpdateAccountAvatarPath = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"updateAccountAvatarPath");
            int _cursorIndexOfUpdateAccountNamePath = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"updateAccountNamePath");
            int _cursorIndexOfExchangeRatePath = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"exchangeRatePath");
            while (_cursor.moveToNext()) {
                int _tmp;
                String _tmpKey = _cursor.getString(_itemKeyIndex);
                if (!_map.containsKey((Object)_tmpKey)) continue;
                String _tmpChainId = _cursorIndexOfChainId == -1 ? null : _cursor.getString(_cursorIndexOfChainId);
                String _tmpName = _cursorIndexOfName == -1 ? null : _cursor.getString(_cursorIndexOfName);
                String _tmpDescription = _cursorIndexOfDescription == -1 ? null : _cursor.getString(_cursorIndexOfDescription);
                String _tmpIconUrl = _cursorIndexOfIconUrl == -1 ? null : _cursor.getString(_cursorIndexOfIconUrl);
                boolean _tmpIsTestnet = _cursorIndexOfIsTestnet == -1 ? false : (_tmp = _cursor.getInt(_cursorIndexOfIsTestnet)) != 0;
                String _tmpChainUrl = _cursorIndexOfChainUrl == -1 ? null : _cursor.getString(_cursorIndexOfChainUrl);
                String _tmpHyperionHistoryUrl = _cursorIndexOfHyperionHistoryUrl == -1 ? null : _cursor.getString(_cursorIndexOfHyperionHistoryUrl);
                String _tmpExplorerName = _cursorIndexOfExplorerName == -1 ? null : _cursor.getString(_cursorIndexOfExplorerName);
                String _tmpExplorerUrl = _cursorIndexOfExplorerUrl == -1 ? null : _cursor.getString(_cursorIndexOfExplorerUrl);
                String _tmpResourceTokenSymbol = _cursorIndexOfResourceTokenSymbol == -1 ? null : _cursor.getString(_cursorIndexOfResourceTokenSymbol);
                String _tmpResourceTokenContract = _cursorIndexOfResourceTokenContract == -1 ? null : _cursor.getString(_cursorIndexOfResourceTokenContract);
                String _tmpSystemTokenSymbol = _cursorIndexOfSystemTokenSymbol == -1 ? null : _cursor.getString(_cursorIndexOfSystemTokenSymbol);
                String _tmpSystemTokenContract = _cursorIndexOfSystemTokenContract == -1 ? null : _cursor.getString(_cursorIndexOfSystemTokenContract);
                String _tmpCreateAccountPath = _cursorIndexOfCreateAccountPath == -1 ? null : _cursor.getString(_cursorIndexOfCreateAccountPath);
                String _tmpUpdateAccountAvatarPath = _cursorIndexOfUpdateAccountAvatarPath == -1 ? null : _cursor.getString(_cursorIndexOfUpdateAccountAvatarPath);
                String _tmpUpdateAccountNamePath = _cursorIndexOfUpdateAccountNamePath == -1 ? null : _cursor.getString(_cursorIndexOfUpdateAccountNamePath);
                String _tmpExchangeRatePath = _cursorIndexOfExchangeRatePath == -1 ? null : _cursor.getString(_cursorIndexOfExchangeRatePath);
                ChainProvider _item_1 = new ChainProvider(_tmpChainId, _tmpName, _tmpDescription, _tmpIconUrl, _tmpIsTestnet, _tmpChainUrl, _tmpHyperionHistoryUrl, _tmpExplorerName, _tmpExplorerUrl, _tmpResourceTokenSymbol, _tmpResourceTokenContract, _tmpSystemTokenSymbol, _tmpSystemTokenContract, _tmpCreateAccountPath, _tmpUpdateAccountAvatarPath, _tmpUpdateAccountNamePath, _tmpExchangeRatePath);
                if (_cursorIndexOfChainApiUrl != -1) {
                    _item_1.chainApiUrl = _cursor.getString(_cursorIndexOfChainApiUrl);
                }
                _map.put((Object)_tmpKey, (Object)_item_1);
            }
        }
    }
}

