/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk;

import android.content.Context;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import androidx.work.Configuration;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.ExistingWorkPolicy;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkInfo;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import androidx.work.WorkerFactory;
import com.metallicus.protonsdk.common.Prefs;
import com.metallicus.protonsdk.di.DaggerInjector;
import com.metallicus.protonsdk.workers.InitActiveAccountWorker;
import com.metallicus.protonsdk.workers.InitChainProviderWorker;
import com.metallicus.protonsdk.workers.InitTokenContractsWorker;
import com.metallicus.protonsdk.workers.ProtonWorkerFactory;
import com.metallicus.protonsdk.workers.UpdateTokenContractRatesWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\"\u0010\u001b\u001a\u00020\u00182\u001a\u0010\u001c\u001a\u0016\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0004\u0012\u00020\u00180\u001dJ\"\u0010 \u001a\u00020\u00182\u001a\u0010\u001c\u001a\u0016\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0004\u0012\u00020\u00180\u001dJ\"\u0010!\u001a\u00020\u00182\u001a\u0010\u001c\u001a\u0016\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0004\u0012\u00020\u00180\u001dR\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00128\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lcom/metallicus/protonsdk/WorkersModule;", "", "()V", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "setContext", "(Landroid/content/Context;)V", "prefs", "Lcom/metallicus/protonsdk/common/Prefs;", "getPrefs", "()Lcom/metallicus/protonsdk/common/Prefs;", "setPrefs", "(Lcom/metallicus/protonsdk/common/Prefs;)V", "workManager", "Landroidx/work/WorkManager;", "workerFactory", "Lcom/metallicus/protonsdk/workers/ProtonWorkerFactory;", "getWorkerFactory", "()Lcom/metallicus/protonsdk/workers/ProtonWorkerFactory;", "setWorkerFactory", "(Lcom/metallicus/protonsdk/workers/ProtonWorkerFactory;)V", "init", "", "protonChainUrl", "", "onInitActiveAccount", "callback", "Lkotlin/Function2;", "", "Landroidx/work/Data;", "onInitChainProvider", "onInitTokenContracts", "Companion", "protonsdk_release"})
public final class WorkersModule {
    @Inject
    @NotNull
    public Context context;
    @Inject
    @NotNull
    public ProtonWorkerFactory workerFactory;
    @Inject
    @NotNull
    public Prefs prefs;
    private WorkManager workManager;
    @NotNull
    public static final String INIT = "WORKER_INIT";
    @NotNull
    public static final String UPDATE_RATES = "WORKER_UPDATE_RATES";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Context getContext() {
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        return context;
    }

    public final void setContext(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"<set-?>");
        this.context = context;
    }

    @NotNull
    public final ProtonWorkerFactory getWorkerFactory() {
        ProtonWorkerFactory protonWorkerFactory = this.workerFactory;
        if (protonWorkerFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"workerFactory");
        }
        return protonWorkerFactory;
    }

    public final void setWorkerFactory(@NotNull ProtonWorkerFactory protonWorkerFactory) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)protonWorkerFactory), (String)"<set-?>");
        this.workerFactory = protonWorkerFactory;
    }

    @NotNull
    public final Prefs getPrefs() {
        Prefs prefs = this.prefs;
        if (prefs == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prefs");
        }
        return prefs;
    }

    public final void setPrefs(@NotNull Prefs prefs) {
        Intrinsics.checkParameterIsNotNull((Object)prefs, (String)"<set-?>");
        this.prefs = prefs;
    }

    public final void init(@NotNull String protonChainUrl) {
        Intrinsics.checkParameterIsNotNull((Object)protonChainUrl, (String)"protonChainUrl");
        this.workManager.pruneWork();
        Prefs prefs = this.prefs;
        if (prefs == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prefs");
        }
        prefs.clearInit();
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)constraints, (String)"Constraints.Builder()\n\t\t\u2026pe.CONNECTED)\n\t\t\t.build()");
        Constraints constraints2 = constraints;
        Data data = new Data.Builder().putString("protonChainUrl", protonChainUrl).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"Data.Builder()\n\t\t\t.putSt\u2026otonChainUrl)\n\t\t\t.build()");
        Data chainProviderInputData = data;
        WorkRequest workRequest = ((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(InitChainProviderWorker.class).setConstraints(constraints2)).setInputData(chainProviderInputData)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)workRequest, (String)"OneTimeWorkRequest.Build\u2026roviderInputData).build()");
        OneTimeWorkRequest initChainProvider = (OneTimeWorkRequest)workRequest;
        WorkRequest workRequest2 = ((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(InitTokenContractsWorker.class).setConstraints(constraints2)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)workRequest2, (String)"OneTimeWorkRequest.Build\u2026ints(constraints).build()");
        OneTimeWorkRequest initTokenContracts = (OneTimeWorkRequest)workRequest2;
        WorkRequest workRequest3 = ((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(InitActiveAccountWorker.class).setConstraints(constraints2)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)workRequest3, (String)"OneTimeWorkRequest.Build\u2026ints(constraints).build()");
        OneTimeWorkRequest initActiveAccount = (OneTimeWorkRequest)workRequest3;
        Prefs prefs2 = this.prefs;
        if (prefs2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prefs");
        }
        CharSequence charSequence = prefs2.getActiveAccountName();
        boolean bl = false;
        if (charSequence.length() > 0) {
            this.workManager.beginUniqueWork(INIT, ExistingWorkPolicy.REPLACE, initChainProvider).then(initTokenContracts).then(initActiveAccount).enqueue();
        } else {
            this.workManager.beginUniqueWork(INIT, ExistingWorkPolicy.REPLACE, initChainProvider).then(initTokenContracts).enqueue();
        }
        WorkRequest workRequest4 = ((PeriodicWorkRequest.Builder)((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(UpdateTokenContractRatesWorker.class, 15L, TimeUnit.MINUTES).setConstraints(constraints2)).setInitialDelay(1L, TimeUnit.MINUTES)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)workRequest4, (String)"PeriodicWorkRequest.Buil\u2026Unit.MINUTES)\n\t\t\t.build()");
        PeriodicWorkRequest updateTokenContractRates = (PeriodicWorkRequest)workRequest4;
        this.workManager.enqueueUniquePeriodicWork(UPDATE_RATES, ExistingPeriodicWorkPolicy.REPLACE, updateTokenContractRates);
    }

    public final void onInitChainProvider(@NotNull Function2<? super Boolean, ? super Data, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Prefs prefs = this.prefs;
        if (prefs == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prefs");
        }
        if (prefs.getHasChainProvider()) {
            callback.invoke((Object)true, null);
        } else {
            LiveData liveData = this.workManager.getWorkInfosForUniqueWorkLiveData(INIT);
            Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"workManager.getWorkInfos\u2026rUniqueWorkLiveData(INIT)");
            LiveData workInfoLiveData = liveData;
            Observer<List<? extends WorkInfo>> workInfoObserver2 = new Observer<List<? extends WorkInfo>>(this, callback, workInfoLiveData){
                final /* synthetic */ WorkersModule this$0;
                final /* synthetic */ Function2 $callback;
                final /* synthetic */ LiveData $workInfoLiveData;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void onChanged(@NotNull List<WorkInfo> workInfos) {
                    boolean bl;
                    List chainProviderWorkInfos;
                    block13: {
                        Object v1;
                        block11: {
                            WorkInfo it;
                            block12: {
                                boolean bl2;
                                block10: {
                                    void $this$filterTo$iv$iv;
                                    Intrinsics.checkParameterIsNotNull(workInfos, (String)"workInfos");
                                    Iterable $this$filter$iv = workInfos;
                                    boolean $i$f$filter = false;
                                    Iterator<T> iterator = $this$filter$iv;
                                    Collection collection = new ArrayList<E>();
                                    boolean $i$f$filterTo = false;
                                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                                        it = (WorkInfo)element$iv$iv;
                                        boolean bl3 = false;
                                        if (!it.getTags().contains(InitChainProviderWorker.class.getName())) continue;
                                        collection.add(element$iv$iv);
                                    }
                                    chainProviderWorkInfos = (List)collection;
                                    if (chainProviderWorkInfos.isEmpty()) break block12;
                                    Iterable $this$any$iv = workInfos;
                                    boolean $i$f$any = false;
                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                        bl2 = false;
                                    } else {
                                        for (E e : $this$any$iv) {
                                            WorkInfo it2 = (WorkInfo)e;
                                            boolean bl4 = false;
                                            if (!(it2.getState() == WorkInfo.State.FAILED || it2.getState() == WorkInfo.State.CANCELLED)) continue;
                                            bl2 = true;
                                            break block10;
                                        }
                                        bl2 = false;
                                    }
                                }
                                if (!bl2) break block13;
                            }
                            Iterable $i$f$any = workInfos;
                            boolean bl5 = false;
                            Iterable iterable = $i$f$any;
                            boolean it2 = false;
                            for (T t : iterable) {
                                it = (WorkInfo)t;
                                boolean bl6 = false;
                                if (!(it.getState() == WorkInfo.State.FAILED)) continue;
                                v1 = t;
                                break block11;
                            }
                            v1 = null;
                        }
                        WorkInfo workInfo = v1;
                        Data data = workInfo != null ? workInfo.getOutputData() : null;
                        this.$callback.invoke((Object)false, (Object)data);
                        this.$workInfoLiveData.removeObserver((Observer)this);
                        return;
                    }
                    Iterable $this$all$iv = chainProviderWorkInfos;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T t : $this$all$iv) {
                            WorkInfo it = (WorkInfo)t;
                            boolean bl7 = false;
                            if (it.getState() != WorkInfo.State.SUCCEEDED) return;
                            boolean bl8 = true;
                            if (bl8) continue;
                            return;
                        }
                        bl = true;
                    }
                    if (!bl) return;
                    this.this$0.getPrefs().setHasChainProvider(true);
                    this.$callback.invoke((Object)true, null);
                    this.$workInfoLiveData.removeObserver((Observer)this);
                }
                {
                    this.this$0 = $outer;
                    this.$callback = $captured_local_variable$1;
                    this.$workInfoLiveData = $captured_local_variable$2;
                }
            };
            workInfoLiveData.observeForever((Observer)workInfoObserver2);
        }
    }

    public final void onInitTokenContracts(@NotNull Function2<? super Boolean, ? super Data, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Prefs prefs = this.prefs;
        if (prefs == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prefs");
        }
        if (prefs.getHasTokenContracts()) {
            callback.invoke((Object)true, null);
        } else {
            LiveData liveData = this.workManager.getWorkInfosForUniqueWorkLiveData(INIT);
            Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"workManager.getWorkInfos\u2026rUniqueWorkLiveData(INIT)");
            LiveData workInfoLiveData = liveData;
            Observer<List<? extends WorkInfo>> workInfoObserver2 = new Observer<List<? extends WorkInfo>>(this, callback, workInfoLiveData){
                final /* synthetic */ WorkersModule this$0;
                final /* synthetic */ Function2 $callback;
                final /* synthetic */ LiveData $workInfoLiveData;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void onChanged(@NotNull List<WorkInfo> workInfos) {
                    boolean bl;
                    List tokenContractWorkInfos;
                    block13: {
                        Object v1;
                        block11: {
                            WorkInfo it;
                            block12: {
                                boolean bl2;
                                block10: {
                                    void $this$filterTo$iv$iv;
                                    Intrinsics.checkParameterIsNotNull(workInfos, (String)"workInfos");
                                    Iterable $this$filter$iv = workInfos;
                                    boolean $i$f$filter = false;
                                    Iterator<T> iterator = $this$filter$iv;
                                    Collection collection = new ArrayList<E>();
                                    boolean $i$f$filterTo = false;
                                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                                        it = (WorkInfo)element$iv$iv;
                                        boolean bl3 = false;
                                        if (!it.getTags().contains(InitTokenContractsWorker.class.getName())) continue;
                                        collection.add(element$iv$iv);
                                    }
                                    tokenContractWorkInfos = (List)collection;
                                    if (tokenContractWorkInfos.isEmpty()) break block12;
                                    Iterable $this$any$iv = workInfos;
                                    boolean $i$f$any = false;
                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                        bl2 = false;
                                    } else {
                                        for (E e : $this$any$iv) {
                                            WorkInfo it2 = (WorkInfo)e;
                                            boolean bl4 = false;
                                            if (!(it2.getState() == WorkInfo.State.FAILED || it2.getState() == WorkInfo.State.CANCELLED)) continue;
                                            bl2 = true;
                                            break block10;
                                        }
                                        bl2 = false;
                                    }
                                }
                                if (!bl2) break block13;
                            }
                            Iterable $i$f$any = workInfos;
                            boolean bl5 = false;
                            Iterable iterable = $i$f$any;
                            boolean it2 = false;
                            for (T t : iterable) {
                                it = (WorkInfo)t;
                                boolean bl6 = false;
                                if (!(it.getState() == WorkInfo.State.FAILED)) continue;
                                v1 = t;
                                break block11;
                            }
                            v1 = null;
                        }
                        WorkInfo workInfo = v1;
                        Data data = workInfo != null ? workInfo.getOutputData() : null;
                        this.$callback.invoke((Object)false, (Object)data);
                        this.$workInfoLiveData.removeObserver((Observer)this);
                        return;
                    }
                    Iterable $this$all$iv = tokenContractWorkInfos;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T t : $this$all$iv) {
                            WorkInfo it = (WorkInfo)t;
                            boolean bl7 = false;
                            if (it.getState() != WorkInfo.State.SUCCEEDED) return;
                            boolean bl8 = true;
                            if (bl8) continue;
                            return;
                        }
                        bl = true;
                    }
                    if (!bl) return;
                    this.this$0.getPrefs().setHasTokenContracts(true);
                    this.$callback.invoke((Object)true, null);
                    this.$workInfoLiveData.removeObserver((Observer)this);
                }
                {
                    this.this$0 = $outer;
                    this.$callback = $captured_local_variable$1;
                    this.$workInfoLiveData = $captured_local_variable$2;
                }
            };
            workInfoLiveData.observeForever((Observer)workInfoObserver2);
        }
    }

    public final void onInitActiveAccount(@NotNull Function2<? super Boolean, ? super Data, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Prefs prefs = this.prefs;
        if (prefs == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prefs");
        }
        if (prefs.getHasActiveAccount()) {
            callback.invoke((Object)true, null);
        } else {
            LiveData liveData = this.workManager.getWorkInfosForUniqueWorkLiveData(INIT);
            Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"workManager.getWorkInfos\u2026rUniqueWorkLiveData(INIT)");
            LiveData workInfoLiveData = liveData;
            Observer<List<? extends WorkInfo>> workInfoObserver2 = new Observer<List<? extends WorkInfo>>(this, callback, workInfoLiveData){
                final /* synthetic */ WorkersModule this$0;
                final /* synthetic */ Function2 $callback;
                final /* synthetic */ LiveData $workInfoLiveData;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void onChanged(@NotNull List<WorkInfo> workInfos) {
                    boolean bl;
                    List activeAccountWorkInfos;
                    block13: {
                        Object v1;
                        block11: {
                            WorkInfo it;
                            block12: {
                                boolean bl2;
                                block10: {
                                    void $this$filterTo$iv$iv;
                                    Intrinsics.checkParameterIsNotNull(workInfos, (String)"workInfos");
                                    Iterable $this$filter$iv = workInfos;
                                    boolean $i$f$filter = false;
                                    Iterator<T> iterator = $this$filter$iv;
                                    Collection collection = new ArrayList<E>();
                                    boolean $i$f$filterTo = false;
                                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                                        it = (WorkInfo)element$iv$iv;
                                        boolean bl3 = false;
                                        if (!it.getTags().contains(InitActiveAccountWorker.class.getName())) continue;
                                        collection.add(element$iv$iv);
                                    }
                                    activeAccountWorkInfos = (List)collection;
                                    if (activeAccountWorkInfos.isEmpty()) break block12;
                                    Iterable $this$any$iv = workInfos;
                                    boolean $i$f$any = false;
                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                        bl2 = false;
                                    } else {
                                        for (E e : $this$any$iv) {
                                            WorkInfo it2 = (WorkInfo)e;
                                            boolean bl4 = false;
                                            if (!(it2.getState() == WorkInfo.State.FAILED || it2.getState() == WorkInfo.State.CANCELLED)) continue;
                                            bl2 = true;
                                            break block10;
                                        }
                                        bl2 = false;
                                    }
                                }
                                if (!bl2) break block13;
                            }
                            Iterable $i$f$any = workInfos;
                            boolean bl5 = false;
                            Iterable iterable = $i$f$any;
                            boolean it2 = false;
                            for (T t : iterable) {
                                it = (WorkInfo)t;
                                boolean bl6 = false;
                                if (!(it.getState() == WorkInfo.State.FAILED)) continue;
                                v1 = t;
                                break block11;
                            }
                            v1 = null;
                        }
                        WorkInfo workInfo = v1;
                        Data data = workInfo != null ? workInfo.getOutputData() : null;
                        this.$callback.invoke((Object)false, (Object)data);
                        this.$workInfoLiveData.removeObserver((Observer)this);
                        return;
                    }
                    Iterable $this$all$iv = activeAccountWorkInfos;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T t : $this$all$iv) {
                            WorkInfo it = (WorkInfo)t;
                            boolean bl7 = false;
                            if (it.getState() != WorkInfo.State.SUCCEEDED) return;
                            boolean bl8 = true;
                            if (bl8) continue;
                            return;
                        }
                        bl = true;
                    }
                    if (!bl) return;
                    this.this$0.getPrefs().setHasActiveAccount(true);
                    this.$callback.invoke((Object)true, null);
                    this.$workInfoLiveData.removeObserver((Observer)this);
                }
                {
                    this.this$0 = $outer;
                    this.$callback = $captured_local_variable$1;
                    this.$workInfoLiveData = $captured_local_variable$2;
                }
            };
            workInfoLiveData.observeForever((Observer)workInfoObserver2);
        }
    }

    public WorkersModule() {
        DaggerInjector.Companion.getComponent().inject(this);
        Configuration.Builder builder = new Configuration.Builder();
        ProtonWorkerFactory protonWorkerFactory = this.workerFactory;
        if (protonWorkerFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"workerFactory");
        }
        Configuration configuration = builder.setWorkerFactory((WorkerFactory)protonWorkerFactory).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"Configuration.Builder()\n\u2026orkerFactory)\n\t\t\t.build()");
        Configuration workManagerConfig = configuration;
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        WorkManager.initialize((Context)context, (Configuration)workManagerConfig);
        Context context2 = this.context;
        if (context2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        WorkManager workManager = WorkManager.getInstance((Context)context2);
        Intrinsics.checkExpressionValueIsNotNull((Object)workManager, (String)"WorkManager.getInstance(context)");
        this.workManager = workManager;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/metallicus/protonsdk/WorkersModule$Companion;", "", "()V", "INIT", "", "UPDATE_RATES", "protonsdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

