/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.model.chain;

import com.google.gson.annotations.Expose;
import com.metallicus.protonsdk.eosio.commander.model.chain.Action;
import com.metallicus.protonsdk.eosio.commander.model.chain.TransactionHeader;
import com.metallicus.protonsdk.eosio.commander.model.types.EosType;
import java.util.ArrayList;
import java.util.List;

public class Transaction
extends TransactionHeader {
    @Expose
    private List<Action> context_free_actions = new ArrayList<Action>();
    @Expose
    private List<Action> actions = null;
    @Expose
    private List<String> transaction_extensions = new ArrayList<String>();

    public Transaction() {
    }

    public Transaction(Transaction other) {
        super(other);
        this.context_free_actions = this.deepCopyOnlyContainer(other.context_free_actions);
        this.actions = this.deepCopyActions(other.actions);
        this.transaction_extensions = other.transaction_extensions;
    }

    public void addAction(Action msg) {
        if (null == this.actions) {
            this.actions = new ArrayList<Action>(1);
        }
        this.actions.add(msg);
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public int getContextFreeActionCount() {
        return this.actions == null ? 0 : this.actions.size();
    }

    <T> List<T> deepCopyOnlyContainer(List<T> srcList) {
        if (null == srcList) {
            return null;
        }
        ArrayList<T> newList = new ArrayList<T>(srcList.size());
        newList.addAll(srcList);
        return newList;
    }

    private List<Action> deepCopyActions(List<Action> actions) {
        if (null == actions) {
            return null;
        }
        ArrayList<Action> newList = new ArrayList<Action>(actions.size());
        for (Action action : actions) {
            Action actionDeepCopy = new Action(action);
            newList.add(actionDeepCopy);
        }
        return newList;
    }

    @Override
    public void pack(EosType.Writer writer) {
        super.pack(writer);
        writer.putCollection(this.context_free_actions);
        writer.putCollection(this.actions);
        writer.putVariableUInt(this.transaction_extensions.size());
        if (this.transaction_extensions.size() > 0) {
            // empty if block
        }
    }
}

