/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.model;

import androidx.room.Embedded;
import androidx.room.Entity;
import androidx.room.Index;
import androidx.room.TypeConverters;
import com.google.gson.annotations.SerializedName;
import com.metallicus.protonsdk.db.DefaultTypeConverters;
import com.metallicus.protonsdk.db.EOSTypeConverters;
import com.metallicus.protonsdk.db.ProtonTypeConverters;
import com.metallicus.protonsdk.model.AccountContact;
import com.metallicus.protonsdk.model.ActionTrace;
import com.metallicus.protonsdk.model.ActionTraceActData;
import java.text.NumberFormat;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0087\b\u0018\u00002\u00020\u0001:\u00011B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J1\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\b\u0010#\u001a\u00020$H\u0002J\u000e\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020$J\u000e\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020\u0006J\u0006\u0010+\u001a\u00020,J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010.\u001a\u00020!J\u0006\u0010/\u001a\u00020!J\t\u00100\u001a\u00020\u0006H\u00d6\u0001R\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018\u00a8\u00062"}, d2={"Lcom/metallicus/protonsdk/model/Action;", "", "globalActionSeq", "", "blockNum", "blockTime", "", "actionTrace", "Lcom/metallicus/protonsdk/model/ActionTrace;", "(IILjava/lang/String;Lcom/metallicus/protonsdk/model/ActionTrace;)V", "accountContact", "Lcom/metallicus/protonsdk/model/AccountContact;", "getAccountContact", "()Lcom/metallicus/protonsdk/model/AccountContact;", "setAccountContact", "(Lcom/metallicus/protonsdk/model/AccountContact;)V", "accountName", "getAccountName", "()Ljava/lang/String;", "setAccountName", "(Ljava/lang/String;)V", "getActionTrace", "()Lcom/metallicus/protonsdk/model/ActionTrace;", "getBlockNum", "()I", "getBlockTime", "getGlobalActionSeq", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "getAmount", "", "getAmountCurrency", "rate", "getAmountStr", "precision", "", "getDisplayName", "getIconType", "Lcom/metallicus/protonsdk/model/Action$IconType;", "hashCode", "isSender", "isTransfer", "toString", "IconType", "protonsdk_release"})
@Entity(indices={@Index(value={"accountName", "action_trace_act_account", "action_trace_act_data_quantity"})}, primaryKeys={"accountName", "action_trace_trxId", "action_trace_act_name", "action_trace_act_authorization"})
@TypeConverters(value={DefaultTypeConverters.class, EOSTypeConverters.class, ProtonTypeConverters.class})
public final class Action {
    @NotNull
    public String accountName;
    @NotNull
    public AccountContact accountContact;
    @SerializedName(value="global_action_seq")
    private final int globalActionSeq;
    @SerializedName(value="block_num")
    private final int blockNum;
    @SerializedName(value="block_time")
    @NotNull
    private final String blockTime;
    @SerializedName(value="action_trace")
    @Embedded(prefix="action_trace_")
    @NotNull
    private final ActionTrace actionTrace;

    @NotNull
    public final String getAccountName() {
        String string2 = this.accountName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"accountName");
        }
        return string2;
    }

    public final void setAccountName(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.accountName = string2;
    }

    @NotNull
    public final AccountContact getAccountContact() {
        AccountContact accountContact = this.accountContact;
        if (accountContact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"accountContact");
        }
        return accountContact;
    }

    public final void setAccountContact(@NotNull AccountContact accountContact) {
        Intrinsics.checkParameterIsNotNull((Object)accountContact, (String)"<set-?>");
        this.accountContact = accountContact;
    }

    public final boolean isTransfer() {
        return Intrinsics.areEqual((Object)this.actionTrace.getAct().getName(), (Object)"transfer");
    }

    public final boolean isSender() {
        String string2 = this.accountName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"accountName");
        }
        ActionTraceActData actionTraceActData = this.actionTrace.getAct().getData();
        return Intrinsics.areEqual((Object)string2, (Object)(actionTraceActData != null ? actionTraceActData.getFrom() : null)) && Intrinsics.areEqual((Object)this.actionTrace.getAct().getData().getFrom(), (Object)this.actionTrace.getAct().getData().getTo()) ^ true;
    }

    @NotNull
    public final IconType getIconType() {
        return IconType.AVATAR;
    }

    @NotNull
    public final String getDisplayName() {
        String string2;
        ActionTraceActData actionTraceActData = this.actionTrace.getAct().getData();
        if (Intrinsics.areEqual((Object)(actionTraceActData != null ? actionTraceActData.getTo() : null), (Object)"eosio.ramfee")) {
            string2 = "Buy RAM Fee";
        } else {
            ActionTraceActData actionTraceActData2 = this.actionTrace.getAct().getData();
            if (Intrinsics.areEqual((Object)(actionTraceActData2 != null ? actionTraceActData2.getTo() : null), (Object)"eosio.ram")) {
                string2 = "Buy RAM";
            } else {
                ActionTraceActData actionTraceActData3 = this.actionTrace.getAct().getData();
                if (Intrinsics.areEqual((Object)(actionTraceActData3 != null ? actionTraceActData3.getTo() : null), (Object)"eosio.stake")) {
                    string2 = "Staked Resources";
                } else {
                    ActionTraceActData actionTraceActData4 = this.actionTrace.getAct().getData();
                    if (Intrinsics.areEqual((Object)(actionTraceActData4 != null ? actionTraceActData4.getFrom() : null), (Object)"eosio.stake")) {
                        string2 = "Unstaked Resources";
                    } else {
                        AccountContact accountContact = this.accountContact;
                        if (accountContact == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"accountContact");
                        }
                        string2 = accountContact.getDisplayName();
                    }
                }
            }
        }
        return string2;
    }

    private final double getAmount() {
        double amount;
        block1: {
            amount = 0.0;
            ActionTraceActData actionTraceActData = this.actionTrace.getAct().getData();
            if (actionTraceActData == null) break block1;
            ActionTraceActData actionTraceActData2 = actionTraceActData;
            boolean bl = false;
            boolean bl2 = false;
            ActionTraceActData data = actionTraceActData2;
            boolean bl3 = false;
            amount = data.quantityToDouble();
            if (this.isSender()) {
                amount = -amount;
            }
        }
        return amount;
    }

    @NotNull
    public final String getAmountStr(long precision) {
        NumberFormat nf;
        double amount = this.getAmount();
        NumberFormat numberFormat = nf = NumberFormat.getNumberInstance(Locale.US);
        Intrinsics.checkExpressionValueIsNotNull((Object)numberFormat, (String)"nf");
        numberFormat.setMinimumFractionDigits((int)precision);
        nf.setMaximumFractionDigits((int)precision);
        String amountStr = nf.format(amount);
        double d = amount;
        boolean bl = false;
        if (Math.signum(d) != -1.0) {
            amountStr = '+' + amountStr;
        }
        String string2 = amountStr;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"amountStr");
        return string2;
    }

    @NotNull
    public final String getAmountCurrency(double rate) {
        double amount = this.getAmount();
        NumberFormat nf = NumberFormat.getCurrencyInstance(Locale.US);
        double amountCurrency = amount * rate;
        String amountCurrencyStr = nf.format(amountCurrency);
        double d = amount;
        boolean bl = false;
        if (Math.signum(d) != -1.0) {
            amountCurrencyStr = '+' + amountCurrencyStr;
        }
        String string2 = amountCurrencyStr;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"amountCurrencyStr");
        return string2;
    }

    public final int getGlobalActionSeq() {
        return this.globalActionSeq;
    }

    public final int getBlockNum() {
        return this.blockNum;
    }

    @NotNull
    public final String getBlockTime() {
        return this.blockTime;
    }

    @NotNull
    public final ActionTrace getActionTrace() {
        return this.actionTrace;
    }

    public Action(int globalActionSeq, int blockNum, @NotNull String blockTime, @NotNull ActionTrace actionTrace) {
        Intrinsics.checkParameterIsNotNull((Object)blockTime, (String)"blockTime");
        Intrinsics.checkParameterIsNotNull((Object)actionTrace, (String)"actionTrace");
        this.globalActionSeq = globalActionSeq;
        this.blockNum = blockNum;
        this.blockTime = blockTime;
        this.actionTrace = actionTrace;
    }

    public final int component1() {
        return this.globalActionSeq;
    }

    public final int component2() {
        return this.blockNum;
    }

    @NotNull
    public final String component3() {
        return this.blockTime;
    }

    @NotNull
    public final ActionTrace component4() {
        return this.actionTrace;
    }

    @NotNull
    public final Action copy(int globalActionSeq, int blockNum, @NotNull String blockTime, @NotNull ActionTrace actionTrace) {
        Intrinsics.checkParameterIsNotNull((Object)blockTime, (String)"blockTime");
        Intrinsics.checkParameterIsNotNull((Object)actionTrace, (String)"actionTrace");
        return new Action(globalActionSeq, blockNum, blockTime, actionTrace);
    }

    public static /* synthetic */ Action copy$default(Action action, int n, int n2, String string2, ActionTrace actionTrace, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = action.globalActionSeq;
        }
        if ((n3 & 2) != 0) {
            n2 = action.blockNum;
        }
        if ((n3 & 4) != 0) {
            string2 = action.blockTime;
        }
        if ((n3 & 8) != 0) {
            actionTrace = action.actionTrace;
        }
        return action.copy(n, n2, string2, actionTrace);
    }

    @NotNull
    public String toString() {
        return "Action(globalActionSeq=" + this.globalActionSeq + ", blockNum=" + this.blockNum + ", blockTime=" + this.blockTime + ", actionTrace=" + this.actionTrace + ")";
    }

    public int hashCode() {
        String string2 = this.blockTime;
        ActionTrace actionTrace = this.actionTrace;
        return ((Integer.hashCode(this.globalActionSeq) * 31 + Integer.hashCode(this.blockNum)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (actionTrace != null ? ((Object)actionTrace).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Action)) break block3;
                Action action = (Action)object;
                if (this.globalActionSeq != action.globalActionSeq || this.blockNum != action.blockNum || !Intrinsics.areEqual((Object)this.blockTime, (Object)action.blockTime) || !Intrinsics.areEqual((Object)this.actionTrace, (Object)action.actionTrace)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/metallicus/protonsdk/model/Action$IconType;", "", "(Ljava/lang/String;I)V", "AVATAR", "SEND", "RECEIVE", "STAKE", "UNSTAKE", "BUY_RAM", "protonsdk_release"})
    public static final class IconType
    extends Enum<IconType> {
        public static final /* enum */ IconType AVATAR;
        public static final /* enum */ IconType SEND;
        public static final /* enum */ IconType RECEIVE;
        public static final /* enum */ IconType STAKE;
        public static final /* enum */ IconType UNSTAKE;
        public static final /* enum */ IconType BUY_RAM;
        private static final /* synthetic */ IconType[] $VALUES;

        static {
            IconType[] iconTypeArray = new IconType[6];
            IconType[] iconTypeArray2 = iconTypeArray;
            iconTypeArray[0] = AVATAR = new IconType();
            iconTypeArray[1] = SEND = new IconType();
            iconTypeArray[2] = RECEIVE = new IconType();
            iconTypeArray[3] = STAKE = new IconType();
            iconTypeArray[4] = UNSTAKE = new IconType();
            iconTypeArray[5] = BUY_RAM = new IconType();
            $VALUES = iconTypeArray;
        }

        public static IconType[] values() {
            return (IconType[])$VALUES.clone();
        }

        public static IconType valueOf(String string2) {
            return Enum.valueOf(IconType.class, string2);
        }
    }
}

