/*
 * Decompiled with CFR 0.152.
 */
package com.messagebird.objects;

import com.messagebird.objects.IfMachineType;
import com.messagebird.objects.Message;
import com.messagebird.objects.MessageBase;
import com.messagebird.objects.VoiceType;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;

public class VoiceMessage
implements MessageBase,
Serializable {
    private static final long serialVersionUID = 1553564355131214875L;
    private String originator;
    private String body;
    private String recipients;
    private String reference;
    private String language;
    private VoiceType voice;
    private Integer repeat;
    private IfMachineType ifMachine;
    private Date scheduledDatetime;

    public VoiceMessage(String body, List<BigInteger> recipients) {
        this(body, Message.receipientsAsCommaSeperated(recipients));
    }

    public VoiceMessage(String body, String recipients) {
        if (recipients == null || recipients.trim().length() == 0) {
            throw new IllegalArgumentException("Recipients must be specified");
        }
        if (body == null || body.trim().length() == 0) {
            throw new IllegalArgumentException("Body must be specified");
        }
        this.recipients = recipients.trim();
        this.body = body.trim();
    }

    @Override
    public String getBody() {
        return this.body;
    }

    public String getOriginator() {
        return this.originator;
    }

    public void setOriginator(String originator) {
        this.originator = originator;
    }

    @Override
    public String getRecipients() {
        return this.recipients;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public VoiceType getVoice() {
        return this.voice;
    }

    public void setVoice(VoiceType voice) {
        this.voice = voice;
    }

    public Integer getRepeat() {
        return this.repeat;
    }

    public void setRepeat(Integer repeat) {
        if (repeat < 1) {
            throw new IllegalArgumentException("Repeat cannot be < 1.");
        }
        this.repeat = repeat;
    }

    public IfMachineType getIfMachine() {
        return this.ifMachine;
    }

    public void setIfMachine(IfMachineType ifMachine) {
        this.ifMachine = ifMachine;
    }

    @Override
    public Date getScheduledDatetime() {
        return this.scheduledDatetime;
    }

    public void setScheduledDatetime(Date scheduledDatetime) {
        this.scheduledDatetime = scheduledDatetime;
    }
}

