/*
 * Decompiled with CFR 0.152.
 */
package com.messagebird;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.messagebird.APIResponse;
import com.messagebird.MessageBirdService;
import com.messagebird.exceptions.GeneralException;
import com.messagebird.exceptions.NotFoundException;
import com.messagebird.exceptions.UnauthorizedException;
import com.messagebird.objects.ErrorReport;
import com.messagebird.objects.PagedPaging;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class MessageBirdServiceImpl
implements MessageBirdService {
    private static final String NOT_AUTHORISED_MSG = "You are not authorised for the MessageBird service, please check your access key.";
    private static final String FAILED_DATA_RESPONSE_CODE = "Failed to retrieve data from MessageBird service with response code ";
    private static final String ACCESS_KEY_MUST_BE_SPECIFIED = "Access key must be specified";
    private static final String SERVICE_URL_MUST_BE_SPECIFIED = "Service URL must be specified";
    private static final String REQUEST_VALUE_MUST_BE_SPECIFIED = "Request value must be specified";
    private static final String REQUEST_METHOD_NOT_ALLOWED = "Request method %s is not allowed.";
    private static final String CAN_NOT_ALLOW_PATCH = "Can not set HttpURLConnection.methods field to allow PATCH.";
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_PATCH = "PATCH";
    private static final String METHOD_POST = "POST";
    private static final List<String> REQUEST_METHODS = Arrays.asList("DELETE", "GET", "PATCH", "POST");
    private static final List<String> REQUEST_METHODS_WITH_PAYLOAD = Arrays.asList("PATCH", "POST");
    private static final String[] PROTOCOL_LISTS = new String[]{"http://", "https://"};
    private static final List<String> PROTOCOLS = Arrays.asList(PROTOCOL_LISTS);
    private static final double DEFAULT_JAVA_VERSION = 0.0;
    private static boolean isPatchRequestAllowed = false;
    private final String accessKey;
    private final String serviceUrl;
    private final String clientVersion = "2.1.1";
    private final String userAgentString;
    private Proxy proxy = null;

    public MessageBirdServiceImpl(String accessKey, String serviceUrl) {
        if (accessKey == null) {
            throw new IllegalArgumentException(ACCESS_KEY_MUST_BE_SPECIFIED);
        }
        if (serviceUrl == null || serviceUrl.length() == 0) {
            throw new IllegalArgumentException(SERVICE_URL_MUST_BE_SPECIFIED);
        }
        this.accessKey = accessKey;
        this.serviceUrl = serviceUrl;
        this.userAgentString = this.determineUserAgentString();
    }

    private String determineUserAgentString() {
        double javaVersion = 0.0;
        try {
            javaVersion = this.getVersion();
        }
        catch (GeneralException generalException) {
            // empty catch block
        }
        return String.format("MessageBird Java/%s ApiClient/%s", javaVersion, "2.1.1");
    }

    public MessageBirdServiceImpl(String accessKey) {
        this(accessKey, "https://rest.messagebird.com");
    }

    @Override
    public <R> R requestByID(String request, String id, Class<R> clazz) throws UnauthorizedException, GeneralException, NotFoundException {
        String path = "";
        if (id != null) {
            path = "/" + id;
        }
        return this.getJsonData(request + path, null, METHOD_GET, clazz);
    }

    @Override
    public <R> R requestByID(String request, String id, Map<String, Object> params, Class<R> clazz) throws UnauthorizedException, GeneralException, NotFoundException {
        String path = "";
        if (id != null) {
            path = "/" + id;
        }
        String queryParams = "";
        if (!params.isEmpty()) {
            queryParams = "?" + this.getPathVariables(params);
        }
        return this.getJsonData(request + path + queryParams, null, METHOD_GET, clazz);
    }

    @Override
    public void deleteByID(String request, String id) throws UnauthorizedException, GeneralException, NotFoundException {
        this.getJsonData(request + "/" + id, null, METHOD_DELETE, null);
    }

    @Override
    public <R> R requestList(String request, Integer offset, Integer limit, Class<R> clazz) throws UnauthorizedException, GeneralException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (offset != null) {
            map.put("offset", String.valueOf(offset));
        }
        if (limit != null) {
            map.put("limit", String.valueOf(limit));
        }
        try {
            return this.getJsonData(request + "?" + this.getPathVariables(map), null, METHOD_GET, clazz);
        }
        catch (NotFoundException e) {
            throw new GeneralException(e);
        }
    }

    @Override
    public <R> R requestList(String request, PagedPaging pagedPaging, Class<R> clazz) throws UnauthorizedException, GeneralException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (pagedPaging.getPage() != null) {
            map.put("page", String.valueOf(pagedPaging.getPage()));
        }
        if (pagedPaging.getPageSize() != null) {
            map.put("perPage", String.valueOf(pagedPaging.getPageSize()));
        }
        try {
            return this.getJsonData(request + "?" + this.getPathVariables(map), null, METHOD_GET, clazz);
        }
        catch (NotFoundException e) {
            throw new GeneralException(e);
        }
    }

    @Override
    public <R, P> R sendPayLoad(String request, P payload, Class<R> clazz) throws UnauthorizedException, GeneralException {
        return this.sendPayLoad(METHOD_POST, request, payload, clazz);
    }

    @Override
    public <R, P> R sendPayLoad(String method, String request, P payload, Class<R> clazz) throws UnauthorizedException, GeneralException {
        if (!REQUEST_METHODS_WITH_PAYLOAD.contains(method)) {
            throw new IllegalArgumentException(String.format(REQUEST_METHOD_NOT_ALLOWED, method));
        }
        try {
            return this.getJsonData(request, payload, method, clazz);
        }
        catch (NotFoundException e) {
            throw new GeneralException(e);
        }
    }

    public <T, P> T getJsonData(String request, P payload, String requestType, Class<T> clazz) throws UnauthorizedException, GeneralException, NotFoundException {
        if (request == null) {
            throw new IllegalArgumentException(REQUEST_VALUE_MUST_BE_SPECIFIED);
        }
        String url = request;
        if (!this.isURLAbsolute(url)) {
            url = this.serviceUrl + url;
        }
        APIResponse apiResponse = this.doRequest(requestType, url, payload);
        String body = apiResponse.getBody();
        int status = apiResponse.getStatus();
        if (status == 200 || status == 201) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            try {
                return (T)mapper.readValue(body, clazz);
            }
            catch (IOException ioe) {
                throw new GeneralException(ioe);
            }
        }
        if (status == 204) {
            return null;
        }
        if (status == 401) {
            List<ErrorReport> errorReport = this.getErrorReportOrNull(body);
            throw new UnauthorizedException(NOT_AUTHORISED_MSG, errorReport);
        }
        if (status >= 400 && status < 500) {
            List<ErrorReport> errorReport = this.getErrorReportOrNull(body);
            if (status == 404) {
                throw new NotFoundException(errorReport);
            }
            throw new GeneralException(FAILED_DATA_RESPONSE_CODE + status, status, errorReport);
        }
        throw new GeneralException(FAILED_DATA_RESPONSE_CODE + status, status);
    }

    <P> APIResponse doRequest(String method, String url, P payload) throws GeneralException {
        HttpURLConnection connection = null;
        InputStream inputStream = null;
        if (METHOD_PATCH.equalsIgnoreCase(method)) {
            MessageBirdServiceImpl.allowPatchRequestsIfNeeded();
        }
        try {
            connection = this.getConnection(url, payload, method);
            int status = connection.getResponseCode();
            inputStream = APIResponse.isSuccessStatus(status) ? connection.getInputStream() : connection.getErrorStream();
            APIResponse aPIResponse = new APIResponse(this.readToEnd(inputStream), status);
            this.saveClose(inputStream);
            if (connection != null) {
                connection.disconnect();
            }
            return aPIResponse;
        }
        catch (IOException ioe) {
            try {
                throw new GeneralException(ioe);
            }
            catch (Throwable throwable) {
                this.saveClose(inputStream);
                if (connection != null) {
                    connection.disconnect();
                }
                throw throwable;
            }
        }
    }

    private static synchronized void allowPatchRequestsIfNeeded() throws GeneralException {
        if (isPatchRequestAllowed) {
            return;
        }
        try {
            Field methodsField = HttpURLConnection.class.getDeclaredField("methods");
            methodsField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(methodsField, methodsField.getModifiers() & 0xFFFFFFEF);
            Object noInstanceBecauseStaticField = null;
            String[] existingMethods = (String[])methodsField.get(noInstanceBecauseStaticField);
            String[] allowedMethods = MessageBirdServiceImpl.getAllowedMethods(existingMethods);
            methodsField.set(noInstanceBecauseStaticField, allowedMethods);
            isPatchRequestAllowed = true;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new GeneralException(CAN_NOT_ALLOW_PATCH);
        }
    }

    private static String[] getAllowedMethods(String[] existingMethods) {
        int listCapacity = existingMethods.length + 1;
        ArrayList<String> allowedMethods = new ArrayList<String>(listCapacity);
        allowedMethods.addAll(Arrays.asList(existingMethods));
        allowedMethods.add(METHOD_PATCH);
        return allowedMethods.toArray(new String[0]);
    }

    private String readToEnd(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream).useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }

    private boolean isURLAbsolute(String url) {
        for (String protocol : PROTOCOLS) {
            if (!url.startsWith(protocol)) continue;
            return true;
        }
        return false;
    }

    public <P> HttpURLConnection getConnection(String serviceUrl, P postData, String requestType) throws IOException {
        if (requestType == null || !REQUEST_METHODS.contains(requestType)) {
            throw new IllegalArgumentException(String.format(REQUEST_METHOD_NOT_ALLOWED, requestType));
        }
        if (postData == null && METHOD_POST.equals(requestType)) {
            throw new IllegalArgumentException("POST detected without a payload, please supply a payload with a POST request");
        }
        URL restService = new URL(serviceUrl);
        HttpURLConnection connection = this.proxy != null ? (HttpURLConnection)restService.openConnection(this.proxy) : (HttpURLConnection)restService.openConnection();
        connection.setDoInput(true);
        connection.setRequestProperty("Accept", "application/json");
        connection.setUseCaches(false);
        connection.setRequestProperty("charset", "utf-8");
        connection.setRequestProperty("Connection", "close");
        connection.setRequestProperty("Authorization", "AccessKey " + this.accessKey);
        connection.setRequestProperty("User-agent", this.userAgentString);
        if (METHOD_POST.equals(requestType) || METHOD_PATCH.equals(requestType)) {
            connection.setRequestMethod(requestType);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            DateFormat df = this.getDateFormat();
            mapper.setDateFormat(df);
            String json = mapper.writeValueAsString(postData);
            connection.getOutputStream().write(json.getBytes(String.valueOf(StandardCharsets.UTF_8)));
        } else if (METHOD_DELETE.equals(requestType)) {
            connection.setDoOutput(false);
            connection.setRequestMethod(METHOD_DELETE);
            connection.setRequestProperty("Content-Type", "text/plain");
        } else {
            connection.setDoOutput(false);
            connection.setRequestMethod(METHOD_GET);
            connection.setRequestProperty("Content-Type", "text/plain");
        }
        return connection;
    }

    private DateFormat getDateFormat() {
        double javaVersion = 0.0;
        try {
            javaVersion = this.getVersion();
        }
        catch (GeneralException generalException) {
            // empty catch block
        }
        if (javaVersion > 1.6) {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        }
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZ");
    }

    private double getVersion() throws GeneralException {
        String version = System.getProperty("java.version");
        try {
            int pos = version.indexOf(46);
            pos = version.indexOf(46, pos + 1);
            return Double.parseDouble(version.substring(0, pos));
        }
        catch (RuntimeException e) {
            throw new GeneralException(e);
        }
    }

    private List<ErrorReport> getErrorReportOrNull(String body) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode jsonNode = (JsonNode)objectMapper.readValue(body, JsonNode.class);
            ErrorReport[] errors = (ErrorReport[])objectMapper.readValue(jsonNode.get("errors").toString(), ErrorReport[].class);
            List<ErrorReport> result = Arrays.asList(errors);
            if (result.isEmpty()) {
                return null;
            }
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getClientVersion() {
        return "2.1.1";
    }

    public String getUserAgentString() {
        return this.userAgentString;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    private void saveClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getPathVariables(Map<String, Object> map) {
        StringBuilder bpath = new StringBuilder();
        for (Map.Entry<String, Object> param : map.entrySet()) {
            if (bpath.length() > 1) {
                bpath.append("&");
            }
            try {
                bpath.append(URLEncoder.encode(param.getKey(), String.valueOf(StandardCharsets.UTF_8))).append("=").append(URLEncoder.encode(String.valueOf(param.getValue()), String.valueOf(StandardCharsets.UTF_8)));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return bpath.toString();
    }
}

