/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.mptracker.trackers;

import android.content.Context;
import android.util.Log;
import com.mercadopago.mptracker.model.PaymentIntent;
import com.mercadopago.mptracker.model.TrackIntent;
import com.mercadopago.mptracker.service.TrackingService;
import com.mercadopago.mptracker.util.HttpClientUtil;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class MPTrackerService {
    private static final String API_BETA_VERSION = "beta";
    private static final String API_PROD_VERSION = "v1";
    private static final String BASE_URL = "https://api.mercadopago.com/";
    private static MPTrackerService mMPTrackerServiceInstance;
    private String mTrackPath = "v1";

    protected MPTrackerService() {
    }

    public static synchronized MPTrackerService getInstance() {
        if (mMPTrackerServiceInstance == null) {
            mMPTrackerServiceInstance = new MPTrackerService();
        }
        return mMPTrackerServiceInstance;
    }

    public void trackToken(String cardToken, String flavor, String sdkPlatform, String sdkType, String publicKey, String sdkVersion, String site, Context context) {
        TrackIntent trackIntent = new TrackIntent();
        trackIntent.setPublicKey(publicKey);
        trackIntent.setCardToken(cardToken);
        trackIntent.setFlavor(flavor);
        trackIntent.setPlatform(sdkPlatform);
        trackIntent.setType(sdkType);
        trackIntent.setSdkVersion(sdkVersion);
        trackIntent.setSite(site);
        Retrofit retrofitBuilder = new Retrofit.Builder().client(HttpClientUtil.getClient(context)).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).baseUrl(BASE_URL).build();
        TrackingService service = (TrackingService)retrofitBuilder.create(TrackingService.class);
        Call<Void> call = service.trackToken(trackIntent, this.mTrackPath);
        call.enqueue((Callback)new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                if (response.code() == 400) {
                    Log.e((String)"Failure", (String)"Error 400, parameter invalid");
                }
            }

            public void onFailure(Call<Void> call, Throwable t) {
                Log.e((String)"Failure", (String)"Service failure");
            }
        });
    }

    public void trackPaymentId(Long paymentId, String flavor, String sdkPlatform, String sdkType, String publicKey, String sdkVersion, String site, Context context) {
        PaymentIntent trackIntent = new PaymentIntent();
        trackIntent.setPublicKey(publicKey);
        trackIntent.setPaymentId(paymentId.toString());
        trackIntent.setFlavor(flavor);
        trackIntent.setPlatform(sdkPlatform);
        trackIntent.setType(sdkType);
        trackIntent.setSdkVersion(sdkVersion);
        trackIntent.setSite(site);
        Retrofit retrofitBuilder = new Retrofit.Builder().client(HttpClientUtil.getClient(context)).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).baseUrl(BASE_URL).build();
        TrackingService service = (TrackingService)retrofitBuilder.create(TrackingService.class);
        Call<Void> call = service.trackPaymentId(trackIntent, this.mTrackPath);
        call.enqueue((Callback)new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                if (response.code() == 400) {
                    Log.e((String)"Failure", (String)"Error 400, parameter invalid");
                }
            }

            public void onFailure(Call<Void> call, Throwable t) {
                Log.e((String)"Failure", (String)"Service failure");
            }
        });
    }

    public void enableTestMode() {
        this.mTrackPath = API_BETA_VERSION;
    }
}

