/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.mptracker;

import android.content.Context;
import android.text.TextUtils;
import com.mercadopago.mptracker.listeners.TracksListener;
import com.mercadopago.mptracker.trackers.MPTrackerService;
import java.util.HashMap;
import java.util.Map;

public class MPTracker {
    private static MPTracker mMPTrackerInstance;
    private TracksListener mTracksListener;
    private String mFlavor;
    private String mPublicKey;
    private String mSdkVersion;
    private String mSiteId;
    private Context mContext;
    private static final String SDK_PLATFORM = "Android";
    private static final String SDK_TYPE = "native";
    private static final String NO_SCREEN = "NO_SCREEN";
    private static final String DEFAULT_SITE = "MLA";
    private Boolean trackerInitialized = false;

    protected MPTracker() {
    }

    public static synchronized MPTracker getInstance() {
        if (mMPTrackerInstance == null) {
            mMPTrackerInstance = new MPTracker();
        }
        return mMPTrackerInstance;
    }

    public void setTracksListener(TracksListener tracksListener) {
        this.mTracksListener = tracksListener;
    }

    private void trackScreenLaunchedListener(String screenName) {
        if (this.mTracksListener != null) {
            this.mTracksListener.onScreenLaunched(screenName);
        }
    }

    private void trackEventPerformedListener(Map<String, String> eventMap) {
        if (this.mTracksListener != null) {
            this.mTracksListener.onEventPerformed(eventMap);
        }
    }

    public void trackPayment(String screenName, String action, Long paymentId, String paymentMethodId, String status, String statusDetail, String typeId, Integer installments, Integer issuerId) {
        if (this.trackerInitialized.booleanValue()) {
            if (!this.isCardPaymentType(typeId).booleanValue()) {
                MPTrackerService.getInstance().trackPaymentId(paymentId, this.mFlavor, SDK_PLATFORM, SDK_TYPE, this.mPublicKey, this.mSdkVersion, this.mSiteId, this.mContext);
            }
            if (!TextUtils.isEmpty((CharSequence)action)) {
                // empty if block
            }
            HashMap<String, String> eventMap = new HashMap<String, String>();
            eventMap.put("screen_name", screenName);
            eventMap.put("payment_id", "" + paymentId);
            eventMap.put("status", status);
            eventMap.put("status_detail", statusDetail);
            eventMap.put("type_id", typeId);
            eventMap.put("payment_method", paymentMethodId);
            eventMap.put("installments", "" + installments);
            eventMap.put("issuer_id", "" + issuerId);
            this.trackEventPerformedListener(eventMap);
        }
    }

    public void trackToken(String token) {
        if (this.trackerInitialized.booleanValue() && !TextUtils.isEmpty((CharSequence)token)) {
            MPTrackerService.getInstance().trackToken(token, this.mFlavor, SDK_PLATFORM, SDK_TYPE, this.mPublicKey, this.mSdkVersion, this.mSiteId, this.mContext);
        }
    }

    public void trackEvent(String screenName, String action, String flavor, String publicKey, String siteId, String sdkVersion, Context context) {
        this.initTracker(flavor, publicKey, siteId, sdkVersion, context);
        if (this.trackerInitialized.booleanValue()) {
            if (!TextUtils.isEmpty((CharSequence)action)) {
                // empty if block
            }
            HashMap<String, String> eventMap = new HashMap<String, String>();
            eventMap.put("screen_name", screenName);
            eventMap.put("action", action);
            this.trackEventPerformedListener(eventMap);
        }
    }

    public void trackEvent(String screenName, String action, String flavor, String publicKey, String sdkVersion, Context context) {
        this.initTracker(flavor, publicKey, this.getSiteId(), sdkVersion, context);
        if (this.trackerInitialized.booleanValue()) {
            if (!TextUtils.isEmpty((CharSequence)action)) {
                // empty if block
            }
            HashMap<String, String> eventMap = new HashMap<String, String>();
            eventMap.put("screen_name", screenName);
            eventMap.put("action", action);
            this.trackEventPerformedListener(eventMap);
        }
    }

    public void trackEvent(String screenName, String action, String result, String flavor, String publicKey, String siteId, String sdkVersion, Context context) {
        this.initTracker(flavor, publicKey, siteId, sdkVersion, context);
        if (this.trackerInitialized.booleanValue()) {
            if (TextUtils.isEmpty((CharSequence)action) || !TextUtils.isEmpty((CharSequence)result)) {
                // empty if block
            }
            HashMap<String, String> eventMap = new HashMap<String, String>();
            eventMap.put("screen_name", screenName);
            eventMap.put("result", result);
            eventMap.put("action", action);
            this.trackEventPerformedListener(eventMap);
        }
    }

    public void trackEvent(String screenName, String action, String result, String flavor) {
        this.initTracker(flavor, this.mPublicKey, this.mSiteId, this.mSdkVersion, this.mContext);
        if (this.trackerInitialized.booleanValue()) {
            if (TextUtils.isEmpty((CharSequence)action) || !TextUtils.isEmpty((CharSequence)result)) {
                // empty if block
            }
            HashMap<String, String> eventMap = new HashMap<String, String>();
            eventMap.put("screen_name", screenName);
            eventMap.put("result", result);
            eventMap.put("action", action);
            this.trackEventPerformedListener(eventMap);
        }
    }

    public void trackScreen(String name, String flavor, String publicKey, String siteId, String sdkVersion, Context context) {
        this.initTracker(flavor, publicKey, siteId, sdkVersion, context);
        if (this.trackerInitialized.booleanValue()) {
            if (this.areScreenParametersValid(name, context)) {
                // empty if block
            }
            this.trackScreenLaunchedListener(name);
        }
    }

    public void trackScreen(String name, String flavor, String publicKey, String sdkVersion, Context context) {
        this.initTracker(flavor, publicKey, this.getSiteId(), sdkVersion, context);
        if (this.trackerInitialized.booleanValue()) {
            if (this.areScreenParametersValid(name, context)) {
                // empty if block
            }
            this.trackScreenLaunchedListener(name);
        }
    }

    private void initTracker(String flavor, String publicKey, String siteId, String sdkVersion, Context context) {
        if (!this.isTrackerInitialized() && this.areInitParametersValid(flavor, publicKey, siteId, sdkVersion, context)) {
            this.trackerInitialized = true;
            this.mFlavor = flavor;
            this.mPublicKey = publicKey;
            this.mSiteId = siteId;
            this.mSdkVersion = sdkVersion;
            this.mContext = context;
        }
    }

    private boolean areInitParametersValid(String flavor, String publicKey, String siteId, String sdkVersion, Context context) {
        return !TextUtils.isEmpty((CharSequence)flavor) && !TextUtils.isEmpty((CharSequence)publicKey) && !TextUtils.isEmpty((CharSequence)sdkVersion) && !TextUtils.isEmpty((CharSequence)siteId) && context != null;
    }

    private boolean areScreenParametersValid(String name, Context context) {
        return !TextUtils.isEmpty((CharSequence)name) && context != null;
    }

    private boolean isTrackerInitialized() {
        return this.mFlavor != null && this.mPublicKey != null && this.mSdkVersion != null && this.mSiteId != null && this.mContext != null;
    }

    private String getPath(String name) {
        StringBuilder path = new StringBuilder();
        if (TextUtils.isEmpty((CharSequence)name)) {
            path.append("F" + this.mFlavor + "/" + NO_SCREEN);
            return path.toString();
        }
        path.append("F" + this.mFlavor + "/" + name);
        return path.toString();
    }

    private String getSiteId() {
        return this.mSiteId == null ? DEFAULT_SITE : this.mSiteId;
    }

    private Boolean isCardPaymentType(String paymentTypeId) {
        return paymentTypeId.equals("credit_card") || paymentTypeId.equals("debit_card") || paymentTypeId.equals("prepaid_card");
    }

    public void enableTestMode() {
        MPTrackerService.getInstance().enableTestMode();
    }
}

