/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.mercadopago.model.AccountMoney;
import com.mercadopago.model.Card;
import com.mercadopago.model.CustomSearchItem;
import com.mercadopago.model.Issuer;
import com.mercadopago.model.OneTapMetadata;
import com.mercadopago.model.PaymentMethod;
import com.mercadopago.model.PaymentMethodSearchItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PaymentMethodSearch
implements Serializable {
    private List<PaymentMethodSearchItem> groups;
    @SerializedName(value="custom_options")
    private List<CustomSearchItem> customSearchItems;
    @SerializedName(value="one_tap")
    private OneTapMetadata oneTapMetadata;
    private List<PaymentMethod> paymentMethods;
    private List<Card> cards;
    private AccountMoney accountMoney;

    public List<PaymentMethodSearchItem> getGroups() {
        return this.groups;
    }

    public List<PaymentMethod> getPaymentMethods() {
        return this.paymentMethods;
    }

    public void setGroups(List<PaymentMethodSearchItem> groups) {
        this.groups = groups;
    }

    public boolean hasSearchItems() {
        return this.groups != null && !this.groups.isEmpty();
    }

    public PaymentMethod getPaymentMethodBySearchItem(PaymentMethodSearchItem item) {
        PaymentMethod requiredPaymentMethod = null;
        if (this.paymentMethods != null && item != null && item.getId() != null) {
            for (PaymentMethod currentPaymentMethod : this.paymentMethods) {
                if (!this.itemMatchesPaymentMethod(item, currentPaymentMethod)) continue;
                requiredPaymentMethod = currentPaymentMethod;
                requiredPaymentMethod.setPaymentTypeId(this.getPaymentTypeIdFromItem(item, currentPaymentMethod));
            }
        }
        return requiredPaymentMethod;
    }

    private String getPaymentTypeIdFromItem(PaymentMethodSearchItem item, PaymentMethod paymentMethod) {
        String itemIdWithoutPaymentMethod = item.getId().replaceFirst(paymentMethod.getId(), "");
        String paymentType = itemIdWithoutPaymentMethod.isEmpty() ? paymentMethod.getPaymentTypeId() : itemIdWithoutPaymentMethod.substring(1);
        return paymentType;
    }

    private boolean itemMatchesPaymentMethod(PaymentMethodSearchItem item, PaymentMethod paymentMethod) {
        return item.getId().startsWith(paymentMethod.getId());
    }

    public PaymentMethodSearchItem getSearchItemByPaymentMethod(PaymentMethod selectedPaymentMethod) {
        PaymentMethodSearchItem requiredItem = null;
        if (selectedPaymentMethod != null) {
            requiredItem = this.searchItemMatchingPaymentMethod(selectedPaymentMethod);
        }
        return requiredItem;
    }

    private PaymentMethodSearchItem searchItemMatchingPaymentMethod(PaymentMethod paymentMethod) {
        return this.searchItemInList(this.groups, paymentMethod);
    }

    private PaymentMethodSearchItem searchItemInList(List<PaymentMethodSearchItem> list, PaymentMethod paymentMethod) {
        PaymentMethodSearchItem requiredItem = null;
        for (PaymentMethodSearchItem currentItem : list) {
            if (this.itemMatchesPaymentMethod(currentItem, paymentMethod) && currentItem.getId().equals(paymentMethod.getId())) {
                requiredItem = currentItem;
                break;
            }
            if (this.itemMatchesPaymentMethod(currentItem, paymentMethod)) {
                String potentialPaymentType = currentItem.getId().replaceFirst(paymentMethod.getId(), "");
                if (!potentialPaymentType.endsWith(paymentMethod.getPaymentTypeId())) continue;
                requiredItem = currentItem;
                break;
            }
            if (!currentItem.hasChildren() || (requiredItem = this.searchItemInList(currentItem.getChildren(), paymentMethod)) == null) continue;
            break;
        }
        return requiredItem;
    }

    @Nullable
    public PaymentMethod getPaymentMethodById(String paymentMethodId) {
        PaymentMethod foundPaymentMethod = null;
        if (this.paymentMethods != null) {
            for (PaymentMethod paymentMethod : this.paymentMethods) {
                if (!paymentMethod.getId().equals(paymentMethodId)) continue;
                foundPaymentMethod = paymentMethod;
                break;
            }
        }
        return foundPaymentMethod;
    }

    public Card getCardById(String cardId) {
        Card foundCard = null;
        if (this.cards != null) {
            for (Card card : this.cards) {
                if (!card.getId().equals(cardId)) continue;
                foundCard = card;
                break;
            }
        }
        return foundCard;
    }

    public List<CustomSearchItem> getCustomSearchItems() {
        return this.customSearchItems;
    }

    public List<Card> getCards() {
        return this.cards;
    }

    public boolean hasCustomSearchItems() {
        return this.customSearchItems != null && !this.customSearchItems.isEmpty();
    }

    public AccountMoney getAccountMoney() {
        return this.accountMoney;
    }

    public void setAccountMoney(AccountMoney accountMoney) {
        this.accountMoney = accountMoney;
    }

    public boolean hasSavedCards() {
        return this.cards != null && !this.cards.isEmpty();
    }

    public void setCards(List<Card> cards, String lastFourDigitsText) {
        if (cards != null) {
            this.customSearchItems = new ArrayList<CustomSearchItem>();
            this.cards = new ArrayList<Card>();
            for (Card card : cards) {
                CustomSearchItem searchItem = new CustomSearchItem();
                searchItem.setDescription(lastFourDigitsText + " " + card.getLastFourDigits());
                searchItem.setType(card.getPaymentMethod().getPaymentTypeId());
                searchItem.setId(card.getId());
                searchItem.setPaymentMethodId(card.getPaymentMethod().getId());
                this.customSearchItems.add(searchItem);
                this.cards.add(card);
            }
        }
    }

    public boolean hasOneTapMetadata() {
        return this.oneTapMetadata != null && this.getOneTapMetadata().isValidOneTapType();
    }

    public void setCards(List<Card> cards) {
        this.cards = cards;
    }

    public void setPaymentMethods(List<PaymentMethod> paymentMethods) {
        this.paymentMethods = paymentMethods;
    }

    public OneTapMetadata getOneTapMetadata() {
        return this.oneTapMetadata;
    }

    @Nullable
    public Issuer getIssuer(@NonNull String cardId) {
        Card foundCard = this.getCardById(cardId);
        return foundCard == null ? null : foundCard.getIssuer();
    }

    @Nullable
    public String getLastFourDigits(@NonNull String cardId) {
        Card foundCard = this.getCardById(cardId);
        return foundCard == null ? null : foundCard.getLastFourDigits();
    }
}

