/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.mercadopago.lite.util.ParcelableUtil;
import com.mercadopago.model.FinancialInstitution;
import com.mercadopago.model.SecurityCode;
import com.mercadopago.model.Setting;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

public class PaymentMethod
implements Parcelable,
Serializable {
    private String id;
    private String name;
    private String paymentTypeId;
    private String status;
    private String secureThumbnail;
    private String deferredCapture;
    private Integer accreditationTime;
    private String merchantAccountId;
    private List<Setting> settings;
    private List<String> additionalInfoNeeded;
    private List<FinancialInstitution> financialInstitutions;
    @Nullable
    private BigDecimal minAllowedAmount;
    @Nullable
    private BigDecimal maxAllowedAmount;
    public static final Parcelable.Creator<PaymentMethod> CREATOR = new Parcelable.Creator<PaymentMethod>(){

        public PaymentMethod createFromParcel(Parcel in) {
            return new PaymentMethod(in);
        }

        public PaymentMethod[] newArray(int size) {
            return new PaymentMethod[size];
        }
    };

    public PaymentMethod(String id, String name, String paymentTypeId) {
        this.id = id;
        this.name = name;
        this.paymentTypeId = paymentTypeId;
    }

    public PaymentMethod(String id) {
        this.id = id;
    }

    @VisibleForTesting
    public PaymentMethod() {
    }

    public boolean isIssuerRequired() {
        return this.isAdditionalInfoNeeded("issuer_id");
    }

    public boolean isSecurityCodeRequired(String bin) {
        Setting setting = Setting.getSettingByBin(this.settings, bin);
        return setting != null && setting.getSecurityCode() != null && setting.getSecurityCode().getLength() != 0;
    }

    public boolean isIdentificationTypeRequired() {
        return this.isAdditionalInfoNeeded("cardholder_identification_type");
    }

    public boolean isIdentificationNumberRequired() {
        return this.isAdditionalInfoNeeded("cardholder_identification_number");
    }

    public List<String> getAdditionalInfoNeeded() {
        return this.additionalInfoNeeded;
    }

    public void setAdditionalInfoNeeded(List<String> additionalInfoNeeded) {
        this.additionalInfoNeeded = additionalInfoNeeded;
    }

    public List<FinancialInstitution> getFinancialInstitutions() {
        return this.financialInstitutions;
    }

    public void setFinancialInstitutions(List<FinancialInstitution> financialInstitutions) {
        this.financialInstitutions = financialInstitutions;
    }

    private boolean isAdditionalInfoNeeded(String param) {
        if (this.additionalInfoNeeded != null && this.additionalInfoNeeded.size() > 0) {
            for (int i = 0; i < this.additionalInfoNeeded.size(); ++i) {
                if (!this.additionalInfoNeeded.get(i).equals(param)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidForBin(String bin) {
        return Setting.getSettingByBin(this.getSettings(), bin) != null;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSecureThumbnail() {
        return this.secureThumbnail;
    }

    public void setSecureThumbnail(String secureThumbnail) {
        this.secureThumbnail = secureThumbnail;
    }

    public String getDeferredCapture() {
        return this.deferredCapture;
    }

    public void setDeferredCapture(String deferredCapture) {
        this.deferredCapture = deferredCapture;
    }

    @Nullable
    public BigDecimal getMinAllowedAmount() {
        return this.minAllowedAmount;
    }

    public void setMinAllowedAmount(@Nullable BigDecimal minAllowedAmount) {
        this.minAllowedAmount = minAllowedAmount;
    }

    @Nullable
    public BigDecimal getMaxAllowedAmount() {
        return this.maxAllowedAmount;
    }

    public void setMaxAllowedAmount(@Nullable BigDecimal maxAllowedAmount) {
        this.maxAllowedAmount = maxAllowedAmount;
    }

    public void setAccreditationTime(Integer accreditationTime) {
        this.accreditationTime = accreditationTime;
    }

    public Integer getAccreditationTime() {
        return this.accreditationTime;
    }

    public String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    public void setMerchantAccountId(String merchantAccountId) {
        this.merchantAccountId = merchantAccountId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPaymentTypeId() {
        return this.paymentTypeId;
    }

    public void setPaymentTypeId(String paymentTypeId) {
        this.paymentTypeId = paymentTypeId;
    }

    public List<Setting> getSettings() {
        return this.settings;
    }

    public void setSettings(List<Setting> settings) {
        this.settings = settings;
    }

    protected PaymentMethod(Parcel in) {
        this.additionalInfoNeeded = in.createStringArrayList();
        this.id = in.readString();
        this.name = in.readString();
        this.paymentTypeId = in.readString();
        this.status = in.readString();
        this.secureThumbnail = in.readString();
        this.deferredCapture = in.readString();
        this.settings = in.createTypedArrayList(Setting.CREATOR);
        this.accreditationTime = ParcelableUtil.getOptionalInteger(in);
        this.merchantAccountId = in.readString();
        this.financialInstitutions = in.createTypedArrayList(FinancialInstitution.CREATOR);
        String minString = in.readString();
        this.minAllowedAmount = minString != null ? new BigDecimal(minString) : null;
        String maxString = in.readString();
        this.maxAllowedAmount = maxString != null ? new BigDecimal(maxString) : null;
    }

    public String toString() {
        return this.name;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStringList(this.additionalInfoNeeded);
        dest.writeString(this.id);
        dest.writeString(this.name);
        dest.writeString(this.paymentTypeId);
        dest.writeString(this.status);
        dest.writeString(this.secureThumbnail);
        dest.writeString(this.deferredCapture);
        dest.writeTypedList(this.settings);
        ParcelableUtil.writeOptional(dest, this.accreditationTime);
        dest.writeString(this.merchantAccountId);
        dest.writeTypedList(this.financialInstitutions);
        dest.writeString(this.minAllowedAmount != null ? this.minAllowedAmount.toString() : null);
        dest.writeString(this.maxAllowedAmount != null ? this.maxAllowedAmount.toString() : null);
    }

    @Nullable
    public SecurityCode getSecurityCode() {
        SecurityCode securityCode = null;
        if (this.settings != null && !this.settings.isEmpty()) {
            securityCode = this.settings.get(0).getSecurityCode();
        }
        return securityCode;
    }
}

