/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.mercadopago.lite.util.CurrenciesUtil;
import com.mercadopago.lite.util.ParcelableUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Locale;

public class Discount
implements Serializable,
Parcelable {
    private String id;
    private String name;
    private String currencyId;
    private BigDecimal percentOff;
    private BigDecimal amountOff;
    private BigDecimal couponAmount;
    public static final Parcelable.Creator<Discount> CREATOR = new Parcelable.Creator<Discount>(){

        public Discount createFromParcel(Parcel in) {
            return new Discount(in);
        }

        public Discount[] newArray(int size) {
            return new Discount[size];
        }
    };

    protected Discount(Builder builder) {
        this.id = builder.id;
        this.currencyId = builder.currencyId;
        this.couponAmount = builder.couponAmount;
        this.name = builder.name;
        this.percentOff = builder.percentOff;
        this.amountOff = builder.amountOff;
    }

    public BigDecimal getAmountOff() {
        return this.amountOff;
    }

    public BigDecimal getCouponAmount() {
        return this.couponAmount;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public BigDecimal getPercentOff() {
        return this.percentOff;
    }

    public BigDecimal getAmountWithDiscount(BigDecimal amount) {
        return amount.subtract(this.couponAmount);
    }

    public boolean hasPercentOff() {
        return this.percentOff != null && !BigDecimal.ZERO.equals(this.percentOff);
    }

    private Discount(Parcel in) {
        this.id = in.readString();
        this.name = in.readString();
        this.currencyId = in.readString();
        this.percentOff = ParcelableUtil.getOptionalBigDecimal(in);
        this.amountOff = ParcelableUtil.getOptionalBigDecimal(in);
        this.couponAmount = new BigDecimal(in.readString());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.name);
        dest.writeString(this.currencyId);
        ParcelableUtil.writeOptional(dest, this.percentOff);
        ParcelableUtil.writeOptional(dest, this.amountOff);
        dest.writeString(this.couponAmount.toString());
    }

    public String getDiscountTermsUrl() {
        return String.format(Locale.US, "https://api.mercadolibre.com/campaigns/%s/terms_and_conditions?format_type=html", this.id);
    }

    public static final class Builder {
        private String id;
        private String currencyId;
        private BigDecimal couponAmount;
        private String name;
        private BigDecimal percentOff;
        private BigDecimal amountOff;

        public Builder(@NonNull String id, @NonNull String currencyId, @NonNull BigDecimal couponAmount) {
            this.id = id;
            this.currencyId = currencyId;
            this.couponAmount = couponAmount;
            this.setPercentOff(BigDecimal.ZERO);
            this.setAmountOff(BigDecimal.ZERO);
        }

        public Builder setName(@NonNull String name) {
            this.name = name;
            return this;
        }

        public Builder setPercentOff(@NonNull BigDecimal percentOff) {
            this.percentOff = percentOff;
            return this;
        }

        public Builder setAmountOff(@NonNull BigDecimal amountOff) {
            this.amountOff = amountOff;
            return this;
        }

        public Discount build() {
            if (!CurrenciesUtil.isValidCurrency(this.currencyId)) {
                throw new IllegalStateException("invalid currency id");
            }
            return new Discount(this);
        }
    }
}

