/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.mercadopago.lite.util.ParcelableUtil;
import java.io.Serializable;
import java.math.BigDecimal;

public class Campaign
implements Serializable,
Parcelable {
    private String id;
    private String codeType;
    private BigDecimal maxCouponAmount;
    private static final String CODE_TYPE_SINGLE = "single";
    private static final String CODE_TYPE_MULTIPLE = "multiple";
    private static final String CODE_TYPE_NONE = "none";
    public static final Parcelable.Creator<Campaign> CREATOR = new Parcelable.Creator<Campaign>(){

        public Campaign createFromParcel(Parcel in) {
            return new Campaign(in);
        }

        public Campaign[] newArray(int size) {
            return new Campaign[size];
        }
    };

    private Campaign(Builder builder) {
        this.id = builder.id;
        this.maxCouponAmount = builder.maxCouponAmount;
        this.codeType = builder.codeType;
    }

    public String getId() {
        return this.id;
    }

    public BigDecimal getMaxCouponAmount() {
        return this.maxCouponAmount;
    }

    public String getCodeType() {
        return this.codeType;
    }

    public boolean hasMaxCouponAmount() {
        return this.maxCouponAmount != null && BigDecimal.ZERO.compareTo(this.maxCouponAmount) < 0;
    }

    public boolean isSingleCodeDiscountCampaign() {
        return CODE_TYPE_SINGLE.contains(this.codeType);
    }

    public boolean isMultipleCodeDiscountCampaign() {
        return CODE_TYPE_MULTIPLE.contains(this.codeType);
    }

    public boolean isDirectDiscountCampaign() {
        return CODE_TYPE_NONE.contains(this.codeType);
    }

    private Campaign(Parcel in) {
        this.id = in.readString();
        this.maxCouponAmount = ParcelableUtil.getBigDecimalReadByte(in);
        this.codeType = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        ParcelableUtil.writeByte(dest, this.maxCouponAmount);
        dest.writeString(this.codeType);
    }

    public static class Builder {
        private String id;
        private BigDecimal maxCouponAmount = BigDecimal.ZERO;
        private String codeType;

        public Builder(@NonNull String id) {
            this.id = id;
        }

        public Builder setMaxCouponAmount(BigDecimal maxCouponAmount) {
            this.maxCouponAmount = maxCouponAmount;
            return this;
        }

        public Builder setCodeType(String codeType) {
            this.codeType = codeType;
            return this;
        }

        public Campaign build() {
            return new Campaign(this);
        }
    }
}

