/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.preferences;

import android.support.annotation.NonNull;
import android.support.annotation.Size;
import com.google.gson.annotations.SerializedName;
import com.mercadopago.lite.exceptions.CheckoutPreferenceException;
import com.mercadopago.lite.util.TextUtil;
import com.mercadopago.model.Item;
import com.mercadopago.model.Payer;
import com.mercadopago.model.PaymentTypes;
import com.mercadopago.model.Site;
import com.mercadopago.model.Sites;
import com.mercadopago.preferences.PaymentPreference;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class CheckoutPreference
implements Serializable {
    private String id;
    private String siteId;
    @NonNull
    private List<Item> items;
    private Payer payer;
    @SerializedName(value="payment_methods")
    private PaymentPreference paymentPreference;
    private Date expirationDateTo;
    private Date expirationDateFrom;
    private Site localPreferenceSite;
    private BigDecimal marketplaceFee;
    private BigDecimal shippingCost;
    private String operationType;
    private Integer differentialPricingId;
    private BigDecimal conceptAmount;
    private String conceptId;

    private CheckoutPreference(Builder builder) {
        this.items = builder.items;
        this.expirationDateFrom = builder.expirationDateFrom;
        this.expirationDateTo = builder.expirationDateTo;
        this.localPreferenceSite = builder.localPreferenceSite;
        this.marketplaceFee = builder.marketplaceFee;
        this.shippingCost = builder.shippingCost;
        this.operationType = builder.operationType;
        this.differentialPricingId = builder.differentialPricingId;
        this.conceptAmount = builder.conceptAmount;
        this.conceptId = builder.conceptId;
        this.payer = this.getPayer(builder);
        PaymentPreference paymentPreference = new PaymentPreference();
        paymentPreference.setExcludedPaymentTypeIds(builder.excludedPaymentTypes);
        paymentPreference.setExcludedPaymentMethodIds(builder.excludedPaymentMethods);
        paymentPreference.setMaxAcceptedInstallments(builder.maxInstallments);
        paymentPreference.setDefaultInstallments(builder.defaultInstallments);
        this.paymentPreference = paymentPreference;
    }

    @NonNull
    private Payer getPayer(Builder builder) {
        Payer payer = new Payer();
        payer.setEmail(builder.payerEmail);
        payer.setAccessToken(builder.payerAccessToken);
        return payer;
    }

    public void validate() throws CheckoutPreferenceException {
        if (!Item.validItems(this.items)) {
            throw new CheckoutPreferenceException(0);
        }
        if (!this.hasEmail()) {
            throw new CheckoutPreferenceException(6);
        }
        if (this.isExpired().booleanValue()) {
            throw new CheckoutPreferenceException(1);
        }
        if (!this.isActive().booleanValue()) {
            throw new CheckoutPreferenceException(2);
        }
        if (!this.validInstallmentsPreference()) {
            throw new CheckoutPreferenceException(3);
        }
        if (!this.validPaymentTypeExclusion()) {
            throw new CheckoutPreferenceException(4);
        }
    }

    private boolean hasEmail() {
        return this.payer != null && !TextUtil.isEmpty(this.payer.getEmail());
    }

    public boolean validPaymentTypeExclusion() {
        return this.paymentPreference == null || this.paymentPreference.excludedPaymentTypesValid();
    }

    public boolean validInstallmentsPreference() {
        return this.paymentPreference == null || this.paymentPreference.installmentPreferencesValid();
    }

    public Boolean isExpired() {
        Date date = new Date();
        return this.expirationDateTo != null && date.after(this.expirationDateTo);
    }

    public Boolean isActive() {
        Date date = new Date();
        return this.expirationDateFrom == null || date.after(this.expirationDateFrom);
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public BigDecimal getMarketplaceFee() {
        return this.marketplaceFee;
    }

    public BigDecimal getShippingCost() {
        return this.shippingCost;
    }

    public Site getLocalPreferenceSite() {
        return this.localPreferenceSite;
    }

    public Integer getDifferentialPricingId() {
        return this.differentialPricingId;
    }

    public BigDecimal getConceptAmount() {
        return this.conceptAmount;
    }

    public String getConceptId() {
        return this.conceptId;
    }

    public BigDecimal getTotalAmount() {
        return Item.getTotalAmountWith(this.items);
    }

    public List<String> getExcludedPaymentTypes() {
        if (this.paymentPreference != null) {
            return this.paymentPreference.getExcludedPaymentTypes();
        }
        return null;
    }

    public Site getSite() {
        Site site = this.localPreferenceSite == null ? Sites.getById(this.siteId) : this.localPreferenceSite;
        return site;
    }

    @NonNull
    public List<Item> getItems() {
        return this.items;
    }

    public Payer getPayer() {
        return this.payer;
    }

    public Integer getMaxInstallments() {
        if (this.paymentPreference != null) {
            return this.paymentPreference.getMaxInstallments();
        }
        return null;
    }

    public Integer getDefaultInstallments() {
        if (this.paymentPreference != null) {
            return this.paymentPreference.getDefaultInstallments();
        }
        return null;
    }

    public List<String> getExcludedPaymentMethods() {
        if (this.paymentPreference != null) {
            return this.paymentPreference.getExcludedPaymentMethodIds();
        }
        return null;
    }

    public Date getExpirationDateFrom() {
        return this.expirationDateFrom;
    }

    public Date getExpirationDateTo() {
        return this.expirationDateTo;
    }

    public String getDefaultPaymentMethodId() {
        if (this.paymentPreference != null) {
            return this.paymentPreference.getDefaultPaymentMethodId();
        }
        return null;
    }

    public PaymentPreference getPaymentPreference() {
        return this.paymentPreference;
    }

    public String getId() {
        return this.id;
    }

    public static class Builder {
        private final List<Item> items;
        private final Site localPreferenceSite;
        private final String payerEmail;
        private final List<String> excludedPaymentMethods;
        private final List<String> excludedPaymentTypes;
        private Integer maxInstallments;
        private Integer defaultInstallments;
        private Date expirationDateTo;
        private Date expirationDateFrom;
        private String payerAccessToken;
        private boolean excludeAccountMoney = true;
        private BigDecimal marketplaceFee;
        private BigDecimal shippingCost;
        private String operationType;
        private Integer differentialPricingId;
        private BigDecimal conceptAmount;
        private String conceptId;

        public Builder(@NonNull Site site, @NonNull String payerEmail, @Size(min=1L) @NonNull List<Item> items) {
            this.items = items;
            this.payerEmail = payerEmail;
            this.localPreferenceSite = site;
            this.excludedPaymentMethods = new ArrayList<String>();
            this.excludedPaymentTypes = new ArrayList<String>();
        }

        public Builder addExcludedPaymentMethod(@NonNull String paymentMethodId) {
            this.excludedPaymentMethods.add(paymentMethodId);
            return this;
        }

        public Builder addExcludedPaymentMethods(@NonNull List<String> paymentMethodIds) {
            this.excludedPaymentMethods.addAll(paymentMethodIds);
            return this;
        }

        public Builder addExcludedPaymentType(@NonNull String paymentTypeId) {
            this.excludedPaymentTypes.add(paymentTypeId);
            return this;
        }

        public Builder addExcludedPaymentTypes(@NonNull List<String> paymentTypeIds) {
            this.excludedPaymentTypes.addAll(paymentTypeIds);
            return this;
        }

        public Builder setMaxInstallments(Integer maxInstallments) {
            this.maxInstallments = maxInstallments;
            return this;
        }

        public Builder setDefaultInstallments(Integer defaultInstallments) {
            this.defaultInstallments = defaultInstallments;
            return this;
        }

        public Builder setExpirationDate(Date date) {
            this.expirationDateTo = date;
            return this;
        }

        public Builder setActiveFrom(Date date) {
            this.expirationDateFrom = date;
            return this;
        }

        public Builder setPayerAccessToken(String payerAccessToken) {
            this.payerAccessToken = payerAccessToken;
            return this;
        }

        public Builder enableAccountMoney() {
            this.excludeAccountMoney = false;
            return this;
        }

        public Builder setMarketplaceFee(BigDecimal marketplaceFee) {
            this.marketplaceFee = marketplaceFee;
            return this;
        }

        public Builder setShippingCost(BigDecimal shippingCost) {
            this.shippingCost = shippingCost;
            return this;
        }

        public Builder setOperationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        public Builder setDifferentialPricingId(Integer differentialPricingId) {
            this.differentialPricingId = differentialPricingId;
            return this;
        }

        public Builder setConceptAmount(BigDecimal conceptAmount) {
            this.conceptAmount = conceptAmount;
            return this;
        }

        public Builder setConceptId(String conceptId) {
            this.conceptId = conceptId;
            return this;
        }

        public CheckoutPreference build() {
            if (this.excludeAccountMoney) {
                this.addExcludedPaymentType(PaymentTypes.ACCOUNT_MONEY);
            }
            return new CheckoutPreference(this);
        }
    }
}

