/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import com.mercadopago.lite.util.ParcelableUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PayerCost
implements Parcelable,
Serializable {
    private static final String CFT = "CFT";
    private static final String TEA = "TEA";
    private Integer installments;
    private List<String> labels;
    private String recommendedMessage;
    private BigDecimal installmentRate;
    private BigDecimal totalAmount;
    private BigDecimal minAllowedAmount;
    private BigDecimal maxAllowedAmount;
    private BigDecimal installmentAmount;
    public static final Parcelable.Creator<PayerCost> CREATOR = new Parcelable.Creator<PayerCost>(){

        public PayerCost createFromParcel(Parcel in) {
            return new PayerCost(in);
        }

        public PayerCost[] newArray(int size) {
            return new PayerCost[size];
        }
    };

    public Integer getInstallments() {
        return this.installments;
    }

    public void setInstallments(Integer installments) {
        this.installments = installments;
    }

    public BigDecimal getInstallmentRate() {
        return this.installmentRate;
    }

    public void setInstallmentRate(BigDecimal installmentRate) {
        this.installmentRate = installmentRate;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public BigDecimal getInstallmentAmount() {
        return this.installmentAmount;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public String getTEAPercent() {
        return this.getRates().get(TEA);
    }

    public String getCFTPercent() {
        return this.getRates().get(CFT);
    }

    public Map<String, String> getRates() {
        HashMap<String, String> ratesMap = new HashMap<String, String>();
        if (this.isValidLabels().booleanValue()) {
            for (String label : this.labels) {
                String[] ratesRaw;
                if (!label.contains(CFT) && !label.contains(TEA)) continue;
                for (String rate : ratesRaw = label.split("\\|")) {
                    String[] rates = rate.split("_");
                    ratesMap.put(rates[0], rates[1]);
                }
            }
        }
        return ratesMap;
    }

    public Boolean hasRates() {
        return this.hasTEA() != false && this.hasCFT() != false;
    }

    public Boolean hasCFT() {
        return this.getCFTPercent() != null;
    }

    public Boolean hasTEA() {
        return this.getTEAPercent() != null;
    }

    private Boolean isValidLabels() {
        return this.labels != null && this.labels.size() > 0;
    }

    public boolean hasMultipleInstallments() {
        return this.installments != null && this.installments > 1;
    }

    public String toString() {
        return this.installments.toString();
    }

    @VisibleForTesting
    public PayerCost() {
    }

    protected PayerCost(Parcel in) {
        this.installments = ParcelableUtil.getIntegerReadByte(in);
        this.labels = in.createStringArrayList();
        this.recommendedMessage = in.readString();
        this.installmentRate = new BigDecimal(in.readString());
        this.totalAmount = new BigDecimal(in.readString());
        this.minAllowedAmount = new BigDecimal(in.readString());
        this.maxAllowedAmount = new BigDecimal(in.readString());
        this.installmentAmount = new BigDecimal(in.readString());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelableUtil.writeByte(dest, this.installments);
        dest.writeStringList(this.labels);
        dest.writeString(this.recommendedMessage);
        dest.writeString(this.installmentRate.toString());
        dest.writeString(this.totalAmount.toString());
        dest.writeString(this.minAllowedAmount.toString());
        dest.writeString(this.maxAllowedAmount.toString());
        dest.writeString(this.installmentAmount.toString());
    }
}

