/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.model;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Looper;
import android.os.StatFs;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class Fingerprint {
    private static final String TAG = "Fingerprint";
    private static final String SHARED_PREFS_FINGERPRINT_LOCATION = "FINGERPRINT_LOCATION";
    public static final String PLATFORM_PROPERTY = "ro.product.cpu.abi";
    private final transient Context mContext;
    private final transient LocationManager mLocationManager;
    private final transient LocationListener mLocationListener;
    public ArrayList<VendorId> vendorIds;
    public String model;
    public String os;
    public String systemVersion;
    public String resolution;
    public Long ram;
    public long diskSpace;
    public long freeDiskSpace;
    public VendorSpecificAttributes vendorSpecificAttributes;
    public Location location;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSystemProperty(String propName) {
        String line;
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop " + propName);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            line = input.readLine();
            input.close();
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)("Unable to read sysprop " + propName), (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Exception while closing InputStream", (Throwable)e);
                }
            }
        }
        return line;
    }

    public Fingerprint(Context context) {
        this.mContext = context;
        this.mLocationManager = (LocationManager)this.mContext.getSystemService("location");
        this.mLocationListener = new FingerprintLocationListener();
        this.registerLocationUpdate(context);
        this.vendorIds = this.getVendorIds();
        this.model = this.getModel();
        this.os = this.getOs();
        this.systemVersion = this.getSystemVersion();
        this.resolution = this.getResolution();
        this.ram = this.getRam();
        this.diskSpace = this.getDiskSpace();
        this.freeDiskSpace = this.getFreeDiskSpace();
        this.vendorSpecificAttributes = this.getVendorSpecificAttributes();
        this.location = this.getLocation(context);
    }

    @SuppressLint(value={"MissingPermission"})
    private void registerLocationUpdate(Context context) {
        if (this.isLocationPermissionGranted(context) && this.mLocationManager.getAllProviders().contains("network")) {
            this.mLocationManager.requestLocationUpdates("network", 0L, 0.0f, this.mLocationListener, Looper.getMainLooper());
        }
    }

    private boolean isLocationPermissionGranted(Context context) {
        return this.mLocationManager.getAllProviders().contains("network") && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0 || ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0;
    }

    public ArrayList<VendorId> getVendorIds() {
        String randomId;
        ArrayList<VendorId> vendorIds = new ArrayList<VendorId>();
        String androidId = Fingerprint.getAndroidId(this.mContext);
        vendorIds.add(new VendorId("android_id", androidId));
        if (!TextUtils.isEmpty((CharSequence)Build.SERIAL) && !"unknown".equals(Build.SERIAL)) {
            vendorIds.add(new VendorId("serial", Build.SERIAL));
        }
        if (!TextUtils.isEmpty((CharSequence)(randomId = SecureRandomId.getValue(this.mContext)))) {
            vendorIds.add(new VendorId("fsuuid", randomId));
        }
        return vendorIds;
    }

    public static String getAndroidId(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public Location getLocation(Context context) {
        Location diskLocation = Location.fromDisk(context);
        Location resolvedLocation = this.getLocationFromNetworkOrDefault(context, diskLocation);
        return resolvedLocation.hasLocation() ? resolvedLocation : null;
    }

    public String getModel() {
        return Build.MODEL;
    }

    public String getOs() {
        return "android";
    }

    public String getSystemVersion() {
        return Fingerprint.getDeviceSystemVersion();
    }

    public static String getDeviceSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getDeviceResolution(Context context) {
        WindowManager manager = (WindowManager)context.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        return display.getWidth() + "x" + display.getHeight();
    }

    public String getResolution() {
        return Fingerprint.getDeviceResolution(this.mContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getRam() {
        Long ram = null;
        RandomAccessFile reader = null;
        try {
            reader = new RandomAccessFile("/proc/meminfo", "r");
            String load = reader.readLine();
            Pattern pattern = Pattern.compile("(\\d+)");
            Matcher matcher = pattern.matcher(load);
            if (matcher.find()) {
                ram = Long.valueOf(matcher.group(0));
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return ram;
    }

    public static float getDeviceScreenDensity(Context context) {
        return context.getResources().getDisplayMetrics().density;
    }

    public long getDiskSpace() {
        StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
        return (long)statFs.getBlockSize() * (long)statFs.getBlockCount() / 0x100000L;
    }

    public long getFreeDiskSpace() {
        StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
        return (long)statFs.getBlockSize() * (long)statFs.getAvailableBlocks() / 0x100000L;
    }

    public VendorSpecificAttributes getVendorSpecificAttributes() {
        return new VendorSpecificAttributes();
    }

    @SuppressLint(value={"MissingPermission"})
    private Location getLocationFromNetworkOrDefault(Context context, Location defLocation) {
        android.location.Location cached;
        if (this.isLocationPermissionGranted(context) && (cached = this.mLocationManager.getLastKnownLocation("network")) != null) {
            Location location = new Location(cached.getLatitude(), cached.getLongitude());
            location.save(context);
            return location;
        }
        return defLocation;
    }

    private class FingerprintLocationListener
    implements LocationListener {
        private FingerprintLocationListener() {
        }

        public void onLocationChanged(android.location.Location location) {
            Location newLocation = new Location(location.getLatitude(), location.getLongitude());
            newLocation.save(Fingerprint.this.mContext);
            try {
                Fingerprint.this.mLocationManager.removeUpdates(Fingerprint.this.mLocationListener);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onStatusChanged(String s, int i, Bundle bundle) {
        }

        public void onProviderEnabled(String s) {
        }

        public void onProviderDisabled(String s) {
        }
    }

    private class VendorSpecificAttributes {
        boolean featureCamera = this.getFeatureCamera();
        boolean featureFlash = this.getFeatureFlash();
        boolean featureFrontCamera = this.getFeatureFrontCamera();
        String product = this.getProduct();
        String device = this.getDevice();
        String platform = this.getPlatform();
        String brand = this.getBrand();
        boolean featureAccelerometer = this.getFeatureAccelerometer();
        boolean featureBluetooth = this.getFeatureBluetooth();
        boolean featureCompass = this.getFeatureCompass();
        boolean featureGps = this.getFeatureGps();
        boolean featureGyroscope = this.getFeatureGyroscope();
        boolean featureMicrophone = this.getFeatureMicrophone();
        boolean featureNfc = this.getFeatureNfc();
        boolean featureTelephony = this.getFeatureTelephony();
        boolean featureTouchScreen = this.getFeatureTouchScreen();
        String manufacturer = this.getManufacturer();
        float screenDensity = this.getScreenDensity();

        private VendorSpecificAttributes() {
        }

        public boolean getFeatureCamera() {
            return Fingerprint.this.mContext.getPackageManager().hasSystemFeature("android.hardware.camera");
        }

        public boolean getFeatureFlash() {
            return Fingerprint.this.mContext.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
        }

        public boolean getFeatureFrontCamera() {
            return Fingerprint.this.mContext.getPackageManager().hasSystemFeature("android.hardware.camera.front");
        }

        public String getProduct() {
            return Build.PRODUCT;
        }

        public String getDevice() {
            return Build.DEVICE;
        }

        public String getPlatform() {
            return Fingerprint.getSystemProperty(Fingerprint.PLATFORM_PROPERTY);
        }

        public String getBrand() {
            return Build.BRAND;
        }

        public boolean getFeatureAccelerometer() {
            return Fingerprint.this.mContext.getPackageManager().hasSystemFeature("android.hardware.sensor.accelerometer");
        }

        public boolean getFeatureBluetooth() {
            return Fingerprint.this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth");
        }

        public boolean getFeatureCompass() {
            return Fingerprint.this.mContext.getPackageManager().hasSystemFeature("android.hardware.sensor.compass");
        }

        public boolean getFeatureGps() {
            return Fingerprint.this.mContext.getPackageManager().hasSystemFeature("android.hardware.location.gps");
        }

        public boolean getFeatureGyroscope() {
            return Fingerprint.this.mContext.getPackageManager().hasSystemFeature("android.hardware.sensor.gyroscope");
        }

        public boolean getFeatureMicrophone() {
            return Fingerprint.this.mContext.getPackageManager().hasSystemFeature("android.hardware.microphone");
        }

        public boolean getFeatureNfc() {
            return Fingerprint.this.mContext.getPackageManager().hasSystemFeature("android.hardware.nfc");
        }

        public boolean getFeatureTelephony() {
            return Fingerprint.this.mContext.getPackageManager().hasSystemFeature("android.hardware.telephony");
        }

        public boolean getFeatureTouchScreen() {
            return Fingerprint.this.mContext.getPackageManager().hasSystemFeature("android.hardware.touchscreen");
        }

        public String getManufacturer() {
            return Build.MANUFACTURER;
        }

        public float getScreenDensity() {
            return Fingerprint.getDeviceScreenDensity(Fingerprint.this.mContext);
        }
    }

    private class VendorId {
        private final String name;
        private final String value;

        public VendorId(String mname, String mvalue) {
            this.name = mname;
            this.value = mvalue;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class Location {
        private static final String LOCATION_TIMESTAMP = "timestamp";
        private static final String LOCATION_LATITUDE = "latitude";
        private static final String LOCATION_LONGITUDE = "longitude";
        private final JSONObject location;

        private Location(@NonNull JSONObject location) {
            this.location = location;
        }

        Location(double latitude, double longitude) {
            this.location = new JSONObject();
            try {
                this.location.put(LOCATION_TIMESTAMP, System.currentTimeMillis() / 1000L);
                this.location.put(LOCATION_LATITUDE, latitude);
                this.location.put(LOCATION_LONGITUDE, longitude);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }

        static Location fromDisk(Context context) {
            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
            String cache = prefs.getString(Fingerprint.SHARED_PREFS_FINGERPRINT_LOCATION, null);
            return cache == null ? Location.invalidLocation() : Location.fromString(cache);
        }

        private static Location fromString(String cache) {
            try {
                JSONObject jsonObject = new JSONObject(cache);
                return new Location(jsonObject);
            }
            catch (JSONException exception) {
                return Location.invalidLocation();
            }
        }

        private static Location invalidLocation() {
            return new Location(new JSONObject());
        }

        public String toString() {
            Gson gson = new Gson();
            try {
                return gson.toJson((Object)this);
            }
            catch (Exception exception) {
                return null;
            }
        }

        boolean hasLocation() {
            return this.location.has(LOCATION_LATITUDE) && this.location.has(LOCATION_LATITUDE);
        }

        public void save(Context context) {
            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(Fingerprint.SHARED_PREFS_FINGERPRINT_LOCATION, this.location.toString());
            editor.apply();
        }
    }

    private static class SecureRandomId {
        private static final String FILENAME_FSUUID = "fsuuid";
        private static String mFSUUID = null;

        private SecureRandomId() {
        }

        private static String readFile(File file) throws IOException {
            RandomAccessFile f = new RandomAccessFile(file, "r");
            byte[] bytes = new byte[(int)f.length()];
            f.readFully(bytes);
            f.close();
            return new String(bytes);
        }

        private static void writeFile(File file) throws IOException {
            FileOutputStream out = new FileOutputStream(file);
            SecureRandom random = new SecureRandom();
            String id = new BigInteger(64, random).toString(16);
            out.write(id.getBytes());
            out.close();
        }

        public static synchronized String getValue(Context context) {
            if (mFSUUID == null) {
                String path = Environment.getExternalStorageDirectory().getAbsolutePath();
                File file = new File(path + "/" + context.getPackageName(), FILENAME_FSUUID);
                try {
                    boolean dirs;
                    if (!file.exists() && (dirs = file.getParentFile().mkdirs())) {
                        SecureRandomId.writeFile(file);
                    }
                    mFSUUID = SecureRandomId.readFile(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return mFSUUID;
        }
    }
}

