/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import com.mercadopago.lite.util.CurrenciesUtil;
import com.mercadopago.lite.util.ParcelableUtil;
import java.io.Serializable;
import java.math.BigDecimal;

public class Discount
implements Parcelable,
Serializable {
    private String id;
    private String name;
    private String currencyId;
    private String couponCode;
    private String concept;
    private String campaignId;
    private BigDecimal percentOff;
    private BigDecimal amountOff;
    private BigDecimal couponAmount;
    public static final Parcelable.Creator<Discount> CREATOR = new Parcelable.Creator<Discount>(){

        public Discount createFromParcel(Parcel in) {
            return new Discount(in);
        }

        public Discount[] newArray(int size) {
            return new Discount[size];
        }
    };

    @VisibleForTesting
    public Discount() {
    }

    public String getCouponCode() {
        return this.couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public BigDecimal getAmountOff() {
        return this.amountOff;
    }

    public BigDecimal getCouponAmount() {
        return this.couponAmount;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getPercentOff() {
        return this.percentOff;
    }

    public void setPercentOff(BigDecimal percentOff) {
        this.percentOff = percentOff;
    }

    public BigDecimal getAmountWithDiscount(BigDecimal amount) {
        return amount.subtract(this.couponAmount);
    }

    public void setAmountOff(BigDecimal amountOff) {
        this.amountOff = amountOff;
    }

    public void setCouponAmount(BigDecimal couponAmount) {
        this.couponAmount = couponAmount;
    }

    public Boolean hasPercentOff() {
        return this.percentOff != null && !this.percentOff.equals(new BigDecimal(0));
    }

    public void setConcept(String concept) {
        this.concept = concept;
    }

    public String getConcept() {
        return this.concept;
    }

    public boolean isValid() {
        return this.isDiscountCurrencyIdValid() != false && this.isAmountValid(this.couponAmount) != false && this.id != null;
    }

    private Boolean isDiscountCurrencyIdValid() {
        return this.currencyId != null && CurrenciesUtil.isValidCurrency(this.currencyId);
    }

    private Boolean isAmountValid(BigDecimal amount) {
        return amount != null && amount.compareTo(BigDecimal.ZERO) >= 0;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    protected Discount(Parcel in) {
        this.id = in.readString();
        this.name = in.readString();
        this.currencyId = in.readString();
        this.couponCode = in.readString();
        this.concept = in.readString();
        this.campaignId = in.readString();
        this.percentOff = ParcelableUtil.getBigDecimalReadByte(in);
        this.amountOff = ParcelableUtil.getBigDecimalReadByte(in);
        this.couponAmount = new BigDecimal(in.readString());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.name);
        dest.writeString(this.currencyId);
        dest.writeString(this.couponCode);
        dest.writeString(this.concept);
        dest.writeString(this.campaignId);
        ParcelableUtil.writeByte(dest, this.percentOff);
        ParcelableUtil.writeByte(dest, this.amountOff);
        dest.writeString(this.couponAmount.toString());
    }
}

