/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.lite.core;

import android.annotation.SuppressLint;
import android.net.ConnectivityManager;
import com.mercadopago.lite.util.NoConnectivityException;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Response;

public class ConnectivityStateInterceptor
implements Interceptor {
    private final ConnectivityManager connectivityManager;

    public ConnectivityStateInterceptor(ConnectivityManager connectivityManager) {
        this.connectivityManager = connectivityManager;
    }

    @SuppressLint(value={"MissingPermission"})
    public Response intercept(Interceptor.Chain chain) throws IOException {
        if (this.connectivityManager.getActiveNetworkInfo() == null || !this.connectivityManager.getActiveNetworkInfo().isAvailable() || !this.connectivityManager.getActiveNetworkInfo().isConnected()) {
            throw new NoConnectivityException();
        }
        return chain.proceed(chain.request());
    }
}

