/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.lite.preferences;

import com.google.gson.annotations.SerializedName;
import com.mercadopago.lite.model.Item;
import com.mercadopago.lite.model.Payer;
import com.mercadopago.lite.preferences.PaymentPreference;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class CheckoutPreference {
    private String id;
    private List<Item> items;
    private Payer payer;
    @SerializedName(value="payment_methods")
    private PaymentPreference paymentPreference;
    private Date expirationDateTo;
    private Date expirationDateFrom;
    private String siteId;

    public Boolean isExpired() {
        Date date = new Date();
        return this.expirationDateTo != null && date.after(this.expirationDateTo);
    }

    public Boolean isActive() {
        Date date = new Date();
        return this.expirationDateFrom == null || date.after(this.expirationDateFrom);
    }

    public void setExpirationDate(Date date) {
        this.expirationDateTo = date;
    }

    public void setActiveFrom(Date date) {
        this.expirationDateFrom = date;
    }

    public void setPaymentPreference(PaymentPreference paymentPreference) {
        this.paymentPreference = paymentPreference;
    }

    public BigDecimal getAmount() {
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (this.items != null) {
            for (Item item : this.items) {
                if (item != null && item.getUnitPrice() != null && item.getQuantity() != null) {
                    totalAmount = totalAmount.add(item.getUnitPrice().multiply(new BigDecimal(item.getQuantity())));
                    continue;
                }
                return null;
            }
        }
        return totalAmount;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public Payer getPayer() {
        return this.payer;
    }

    public void setPayer(Payer payer) {
        this.payer = payer;
    }

    public Integer getMaxInstallments() {
        if (this.paymentPreference != null) {
            return this.paymentPreference.getMaxInstallments();
        }
        return null;
    }

    public Integer getDefaultInstallments() {
        if (this.paymentPreference != null) {
            return this.paymentPreference.getDefaultInstallments();
        }
        return null;
    }

    public List<String> getExcludedPaymentMethods() {
        if (this.paymentPreference != null) {
            return this.paymentPreference.getExcludedPaymentMethodIds();
        }
        return null;
    }

    public List<String> getExcludedPaymentTypes() {
        if (this.paymentPreference != null) {
            return this.paymentPreference.getExcludedPaymentTypeIds();
        }
        return null;
    }

    public String getDefaultPaymentMethodId() {
        if (this.paymentPreference != null) {
            return this.paymentPreference.getDefaultPaymentMethodId();
        }
        return null;
    }

    public PaymentPreference getPaymentPreference() {
        return this.paymentPreference;
    }

    public String getSite() {
        return this.siteId;
    }

    public boolean hasId() {
        return this.getId() != null;
    }
}

