/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.lite.model;

import android.content.Context;
import android.text.TextUtils;
import com.mercadopago.lite.model.Cardholder;
import com.mercadopago.lite.model.Device;
import com.mercadopago.lite.model.IdentificationType;
import com.mercadopago.lite.model.PaymentMethod;
import com.mercadopago.lite.model.Setting;
import java.util.Calendar;
import java.util.Locale;

public class CardToken {
    private static final Calendar now = Calendar.getInstance();
    private Cardholder cardholder;
    private String cardNumber;
    private Device device;
    private Integer expirationMonth;
    private Integer expirationYear;
    private String securityCode;

    public boolean validateCardNumber(PaymentMethod paymentMethod) {
        Setting setting;
        boolean isValidCardNumber = true;
        if (this.cardNumber == null || this.cardNumber.isEmpty()) {
            isValidCardNumber = false;
        }
        if ((setting = Setting.getSettingByBin(paymentMethod.getSettings(), this.cardNumber.length() >= 6 ? this.cardNumber.substring(0, 6) : "")) == null) {
            isValidCardNumber = false;
        } else {
            String luhnAlgorithm;
            int cardLength = setting.getCardNumber().getLength();
            if (this.cardNumber.trim().length() != cardLength) {
                isValidCardNumber = false;
            }
            if ("standard".equals(luhnAlgorithm = setting.getCardNumber().getValidation()) && !this.checkLuhn(this.cardNumber)) {
                isValidCardNumber = false;
            }
        }
        return isValidCardNumber;
    }

    private boolean checkLuhn(String cardNumber) {
        int sum = 0;
        boolean alternate = false;
        if (cardNumber == null || cardNumber.length() == 0) {
            return false;
        }
        for (int i = cardNumber.length() - 1; i >= 0; --i) {
            int n = Integer.parseInt(cardNumber.substring(i, i + 1));
            if (alternate && (n *= 2) > 9) {
                n = n % 10 + 1;
            }
            sum += n;
            alternate = !alternate;
        }
        return sum % 10 == 0;
    }

    public boolean validateSecurityCode(PaymentMethod paymentMethod) {
        return this.validateSecurityCode(this.securityCode, paymentMethod, (this.cardNumber != null ? this.cardNumber.length() : 0) >= 6 ? this.cardNumber.substring(0, 6) : "");
    }

    private boolean validateSecurityCode(String securityCode, PaymentMethod paymentMethod, String bin) {
        boolean isValidSecurityCode = true;
        if (paymentMethod != null) {
            Setting setting = Setting.getSettingByBin(paymentMethod.getSettings(), bin);
            if (setting != null) {
                int cvvLength = setting.getSecurityCode().getLength();
                if (securityCode == null || cvvLength != 0 && securityCode.trim().length() != cvvLength) {
                    isValidSecurityCode = false;
                }
            } else {
                isValidSecurityCode = false;
            }
        }
        return isValidSecurityCode;
    }

    public boolean validateExpiryDate(Integer month, Integer year) {
        if (!this.validateExpMonth(month)) {
            return false;
        }
        if (!this.validateExpYear(year)) {
            return false;
        }
        return !this.hasMonthPassed(month, year);
    }

    private boolean validateExpMonth(Integer month) {
        return month == null ? false : month >= 1 && month <= 12;
    }

    private boolean validateExpYear(Integer year) {
        return year == null ? false : !this.hasYearPassed(year);
    }

    private boolean hasMonthPassed(int month, int year) {
        return this.hasYearPassed(year) || this.normalizeYear(year).intValue() == now.get(1) && month < now.get(2) + 1;
    }

    private boolean hasYearPassed(int year) {
        int normalized = this.normalizeYear(year);
        return normalized < now.get(1);
    }

    private Integer normalizeYear(Integer year) {
        if (year != null && year < 100 && year >= 0) {
            String currentYear = String.valueOf(now.get(1));
            String prefix = currentYear.substring(0, currentYear.length() - 2);
            year = Integer.parseInt(String.format(Locale.US, "%s%02d", prefix, year));
        }
        return year;
    }

    public boolean validateCardholderName() {
        return this.cardholder != null && this.cardholder.getName() != null && !this.cardholder.getName().isEmpty();
    }

    public boolean validateIdentificationNumber(IdentificationType identificationType) {
        if (identificationType != null) {
            if (this.cardholder != null && this.cardholder.getIdentification() != null && this.cardholder.getIdentification().getNumber() != null) {
                int len = this.cardholder.getIdentification().getNumber().length();
                Integer min = identificationType.getMinLength();
                Integer max = identificationType.getMaxLength();
                if (min != null && max != null) {
                    return len <= max && len >= min;
                }
                return this.validateIdentificationNumber();
            }
            return false;
        }
        return this.validateIdentificationNumber();
    }

    public boolean validateIdentificationNumber() {
        return this.cardholder == null ? false : (this.cardholder.getIdentification() == null ? false : (!this.validateIdentificationType() ? false : !TextUtils.isEmpty((CharSequence)this.cardholder.getIdentification().getNumber())));
    }

    private boolean validateIdentificationType() {
        return this.cardholder == null ? false : (this.cardholder.getIdentification() == null ? false : !TextUtils.isEmpty((CharSequence)this.cardholder.getIdentification().getType()));
    }

    public static Calendar getNow() {
        return now;
    }

    public Cardholder getCardholder() {
        return this.cardholder;
    }

    public void setCardholder(Cardholder cardholder) {
        this.cardholder = cardholder;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Context context) {
        this.device = new Device(context);
    }

    public Integer getExpirationMonth() {
        return this.expirationMonth;
    }

    public void setExpirationMonth(Integer expirationMonth) {
        this.expirationMonth = expirationMonth;
    }

    public Integer getExpirationYear() {
        return this.expirationYear;
    }

    public void setExpirationYear(Integer expirationYear) {
        this.expirationYear = expirationYear;
    }

    public String getSecurityCode() {
        return this.securityCode;
    }

    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }
}

