/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.lite.core;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import com.google.gson.Gson;
import com.mercadopago.lite.adapters.ErrorHandlingCallAdapter;
import com.mercadopago.lite.callbacks.Callback;
import com.mercadopago.lite.controllers.CustomServicesHandler;
import com.mercadopago.lite.core.Settings;
import com.mercadopago.lite.model.BankDeal;
import com.mercadopago.lite.model.Campaign;
import com.mercadopago.lite.model.CardToken;
import com.mercadopago.lite.model.Customer;
import com.mercadopago.lite.model.Discount;
import com.mercadopago.lite.model.IdentificationType;
import com.mercadopago.lite.model.Installment;
import com.mercadopago.lite.model.Instructions;
import com.mercadopago.lite.model.Issuer;
import com.mercadopago.lite.model.Payer;
import com.mercadopago.lite.model.Payment;
import com.mercadopago.lite.model.PaymentMethod;
import com.mercadopago.lite.model.PaymentMethodSearch;
import com.mercadopago.lite.model.SavedCardToken;
import com.mercadopago.lite.model.SavedESCCardToken;
import com.mercadopago.lite.model.Site;
import com.mercadopago.lite.model.Token;
import com.mercadopago.lite.model.requests.PayerIntent;
import com.mercadopago.lite.model.requests.SecurityCodeIntent;
import com.mercadopago.lite.preferences.CheckoutPreference;
import com.mercadopago.lite.preferences.ServicePreference;
import com.mercadopago.lite.services.BankDealService;
import com.mercadopago.lite.services.CheckoutService;
import com.mercadopago.lite.services.CustomService;
import com.mercadopago.lite.services.DiscountService;
import com.mercadopago.lite.services.GatewayService;
import com.mercadopago.lite.services.IdentificationService;
import com.mercadopago.lite.services.PaymentService;
import com.mercadopago.lite.util.HttpClientUtil;
import com.mercadopago.lite.util.JsonUtil;
import com.mercadopago.lite.util.TextUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class MercadoPagoServices {
    private static final String MP_API_BASE_URL = "https://api.mercadopago.com";
    private static final String PAYMENT_RESULT_API_VERSION = "1.4";
    private static final String PAYMENT_METHODS_OPTIONS_API_VERSION = "1.4";
    public static final int DEFAULT_CONNECT_TIMEOUT = 10;
    public static final int DEFAULT_READ_TIMEOUT = 20;
    public static final int DEFAULT_WRITE_TIMEOUT = 20;
    public static final int DEFAULT_PAYMENT_CONNECT_TIMEOUT = 10;
    public static final int DEFAULT_PAYMENT_READ_TIMEOUT = 20;
    public static final int DEFAULT_PAYMENT_WRITE_TIMEOUT = 20;
    private ServicePreference mServicePreference;
    private String mPublicKey;
    private String mPrivateKey;
    private Context mContext;
    private String mProcessingMode;
    private Boolean mBetaEnvironment;

    private MercadoPagoServices(Builder builder) {
        this.mContext = builder.mContext;
        this.mPublicKey = builder.mPublicKey;
        this.mPrivateKey = builder.mPrivateKey;
        this.mServicePreference = CustomServicesHandler.getInstance().getServicePreference();
        this.mProcessingMode = this.mServicePreference != null ? this.mServicePreference.getProcessingModeString() : "aggregator";
        this.mBetaEnvironment = builder.mBetaEnvironment;
        this.disableConnectionReuseIfNecessary();
    }

    public void getCheckoutPreference(String checkoutPreferenceId, Callback<CheckoutPreference> callback) {
        CheckoutService service = (CheckoutService)this.getDefaultRetrofit().create(CheckoutService.class);
        service.getPreference(Settings.servicesVersion, checkoutPreferenceId, this.mPublicKey).enqueue(callback);
    }

    public void getInstructions(Long paymentId, String paymentTypeId, Callback<Instructions> callback) {
        CheckoutService service = (CheckoutService)this.getDefaultRetrofit().create(CheckoutService.class);
        service.getPaymentResult(Settings.servicesVersion, this.mContext.getResources().getConfiguration().locale.getLanguage(), paymentId, this.mPublicKey, this.mPrivateKey, paymentTypeId, "1.4").enqueue(callback);
    }

    public void getPaymentMethodSearch(BigDecimal amount, List<String> excludedPaymentTypes, List<String> excludedPaymentMethods, Payer payer, Site site, Callback<PaymentMethodSearch> callback) {
        PayerIntent payerIntent = new PayerIntent(payer);
        CheckoutService service = (CheckoutService)this.getDefaultRetrofit().create(CheckoutService.class);
        String separator = ",";
        String excludedPaymentTypesAppended = this.getListAsString(excludedPaymentTypes, separator);
        String excludedPaymentMethodsAppended = this.getListAsString(excludedPaymentMethods, separator);
        String siteId = site == null ? "" : site.getId();
        service.getPaymentMethodSearch(Settings.servicesVersion, this.mContext.getResources().getConfiguration().locale.getLanguage(), this.mPublicKey, amount, excludedPaymentTypesAppended, excludedPaymentMethodsAppended, payerIntent, siteId, "1.4", this.mProcessingMode).enqueue(callback);
    }

    public void createToken(final SavedCardToken savedCardToken, final Callback<Token> callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                savedCardToken.setDevice(MercadoPagoServices.this.mContext);
                GatewayService service = (GatewayService)MercadoPagoServices.this.getGatewayRetrofit().create(GatewayService.class);
                service.getToken(MercadoPagoServices.this.mPublicKey, MercadoPagoServices.this.mPrivateKey, savedCardToken).enqueue(callback);
            }
        }).start();
    }

    public void createToken(final CardToken cardToken, final Callback<Token> callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                cardToken.setDevice(MercadoPagoServices.this.mContext);
                GatewayService service = (GatewayService)MercadoPagoServices.this.getGatewayRetrofit().create(GatewayService.class);
                service.getToken(MercadoPagoServices.this.mPublicKey, MercadoPagoServices.this.mPrivateKey, cardToken).enqueue(callback);
            }
        }).start();
    }

    public void createToken(final SavedESCCardToken savedESCCardToken, final Callback<Token> callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                savedESCCardToken.setDevice(MercadoPagoServices.this.mContext);
                GatewayService service = (GatewayService)MercadoPagoServices.this.getGatewayRetrofit().create(GatewayService.class);
                service.getToken(MercadoPagoServices.this.mPublicKey, MercadoPagoServices.this.mPrivateKey, savedESCCardToken).enqueue(callback);
            }
        }).start();
    }

    public void cloneToken(String tokenId, Callback<Token> callback) {
        GatewayService service = (GatewayService)this.getGatewayRetrofit().create(GatewayService.class);
        service.getToken(tokenId, this.mPublicKey, this.mPrivateKey).enqueue(callback);
    }

    public void putSecurityCode(String tokenId, SecurityCodeIntent securityCodeIntent, Callback<Token> callback) {
        GatewayService service = (GatewayService)this.getGatewayRetrofit().create(GatewayService.class);
        service.getToken(tokenId, this.mPublicKey, this.mPrivateKey, securityCodeIntent).enqueue(callback);
    }

    public void getBankDeals(Callback<List<BankDeal>> callback) {
        BankDealService service = (BankDealService)this.getDefaultRetrofit().create(BankDealService.class);
        service.getBankDeals(this.mPublicKey, this.mPrivateKey, this.mContext.getResources().getConfiguration().locale.toString()).enqueue(callback);
    }

    public void getIdentificationTypes(Callback<List<IdentificationType>> callback) {
        IdentificationService service = (IdentificationService)this.getDefaultRetrofit().create(IdentificationService.class);
        service.getIdentificationTypes(this.mPublicKey, this.mPrivateKey).enqueue(callback);
    }

    public void getInstallments(String bin, BigDecimal amount, Long issuerId, String paymentMethodId, Callback<List<Installment>> callback) {
        PaymentService service = (PaymentService)this.getDefaultRetrofit().create(PaymentService.class);
        service.getInstallments(Settings.servicesVersion, this.mPublicKey, this.mPrivateKey, bin, amount, issuerId, paymentMethodId, this.mContext.getResources().getConfiguration().locale.toString(), this.mProcessingMode).enqueue(callback);
    }

    public void getIssuers(String paymentMethodId, String bin, Callback<List<Issuer>> callback) {
        PaymentService service = (PaymentService)this.getDefaultRetrofit().create(PaymentService.class);
        service.getIssuers(Settings.servicesVersion, this.mPublicKey, this.mPrivateKey, paymentMethodId, bin, this.mProcessingMode).enqueue(callback);
    }

    public void getPaymentMethods(Callback<List<PaymentMethod>> callback) {
        PaymentService service = (PaymentService)this.getDefaultRetrofit().create(PaymentService.class);
        service.getPaymentMethods(this.mPublicKey, this.mPrivateKey).enqueue(callback);
    }

    public void getDirectDiscount(String amount, String payerEmail, Callback<Discount> callback) {
        DiscountService service = (DiscountService)this.getDefaultRetrofit().create(DiscountService.class);
        service.getDirectDiscount(this.mPublicKey, amount, payerEmail).enqueue(callback);
    }

    public void getCodeDiscount(String amount, String payerEmail, String couponCode, Callback<Discount> callback) {
        DiscountService service = (DiscountService)this.getDefaultRetrofit().create(DiscountService.class);
        service.getCodeDiscount(this.mPublicKey, amount, payerEmail, couponCode).enqueue(callback);
    }

    public void getCampaigns(Callback<List<Campaign>> callback) {
        DiscountService service = (DiscountService)this.getDefaultRetrofit().create(DiscountService.class);
        service.getCampaigns(this.mPublicKey).enqueue(callback);
    }

    public void createCheckoutPreference(String url, String uri, Callback<CheckoutPreference> callback) {
        CustomService customService = this.getCustomService(url);
        customService.createPreference(uri, null).enqueue(callback);
    }

    public void createCheckoutPreference(String url, String uri, Map<String, Object> bodyInfo, Callback<CheckoutPreference> callback) {
        CustomService customService = this.getCustomService(url);
        customService.createPreference(uri, bodyInfo).enqueue(callback);
    }

    public void getCustomer(String url, String uri, Callback<Customer> callback) {
        CustomService customService = this.getCustomService(url);
        customService.getCustomer(uri, null).enqueue(callback);
    }

    public void getCustomer(String url, String uri, @NonNull Map<String, String> additionalInfo, Callback<Customer> callback) {
        if (additionalInfo == null) {
            additionalInfo = new HashMap<String, String>();
        }
        CustomService customService = this.getCustomService(url);
        customService.getCustomer(uri, additionalInfo).enqueue(callback);
    }

    public void createPayment(String baseUrl, String uri, Map<String, Object> paymentData, @NonNull Map<String, String> query, Callback<Payment> callback) {
        if (query == null) {
            query = new HashMap<String, String>();
        }
        CustomService customService = this.getCustomService(baseUrl, 10, 20, 20);
        customService.createPayment(Settings.servicesVersion, MercadoPagoServices.ripFirstSlash(uri), paymentData, query).enqueue(callback);
    }

    public void createPayment(String transactionId, String baseUrl, String uri, Map<String, Object> paymentData, @NonNull Map<String, String> query, Callback<Payment> callback) {
        if (query == null) {
            query = new HashMap<String, String>();
        }
        CustomService customService = this.getCustomService(baseUrl, 10, 20, 20);
        customService.createPayment(transactionId, MercadoPagoServices.ripFirstSlash(uri), paymentData, query).enqueue(callback);
    }

    public void getDirectDiscount(String transactionAmount, String payerEmail, String url, String uri, @NonNull Map<String, String> discountAdditionalInfo, Callback<Discount> callback) {
        if (discountAdditionalInfo == null) {
            discountAdditionalInfo = new HashMap<String, String>();
        }
        CustomService customService = this.getCustomService(url);
        customService.getDirectDiscount(MercadoPagoServices.ripFirstSlash(uri), transactionAmount, payerEmail, discountAdditionalInfo).enqueue(callback);
    }

    public void getCodeDiscount(String discountCode, String transactionAmount, String payerEmail, Context context, String url, String uri, @NonNull Map<String, String> discountAdditionalInfo, Callback<Discount> callback) {
        if (discountAdditionalInfo == null) {
            discountAdditionalInfo = new HashMap<String, String>();
        }
        CustomService customService = this.getCustomService(url);
        customService.getCodeDiscount(MercadoPagoServices.ripFirstSlash(uri), transactionAmount, payerEmail, discountCode, discountAdditionalInfo).enqueue(callback);
    }

    private Retrofit getDefaultRetrofit() {
        return this.getDefaultRetrofit(10, 20, 20);
    }

    private Retrofit getDefaultRetrofit(int connectTimeout, int readTimeout, int writeTimeout) {
        String baseUrl = this.mServicePreference != null && !TextUtil.isEmpty(this.mServicePreference.getDefaultBaseURL()) ? this.mServicePreference.getDefaultBaseURL() : MP_API_BASE_URL;
        return this.getRetrofit(baseUrl, connectTimeout, readTimeout, writeTimeout);
    }

    private Retrofit getGatewayRetrofit() {
        return this.getGatewayRetrofit(10, 20, 20);
    }

    private Retrofit getGatewayRetrofit(int connectTimeout, int readTimeout, int writeTimeout) {
        String baseUrl = this.mServicePreference != null && !TextUtil.isEmpty(this.mServicePreference.getGatewayBaseURL()) ? this.mServicePreference.getGatewayBaseURL() : (this.mServicePreference != null && !TextUtil.isEmpty(this.mServicePreference.getDefaultBaseURL()) ? this.mServicePreference.getDefaultBaseURL() : MP_API_BASE_URL);
        return this.getRetrofit(baseUrl, connectTimeout, readTimeout, writeTimeout);
    }

    private CustomService getCustomService(String url) {
        return this.getCustomService(url, 10, 20, 20);
    }

    private CustomService getCustomService(String baseUrl, int connectTimeout, int readTimeout, int writeTimeout) {
        Retrofit retrofit = this.getRetrofit(baseUrl, connectTimeout, readTimeout, writeTimeout);
        return (CustomService)retrofit.create(CustomService.class);
    }

    private static String ripFirstSlash(String uri) {
        return uri.startsWith("/") ? uri.substring(1) : uri;
    }

    private Retrofit getRetrofit(String baseUrl, int connectTimeout, int readTimeout, int writeTimeout) {
        return new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)JsonUtil.getInstance().getGson())).client(HttpClientUtil.getClient(this.mContext, connectTimeout, readTimeout, writeTimeout)).addCallAdapterFactory((CallAdapter.Factory)new ErrorHandlingCallAdapter.ErrorHandlingCallAdapterFactory()).build();
    }

    private void disableConnectionReuseIfNecessary() {
        if (Build.VERSION.SDK_INT < 14) {
            System.setProperty("http.keepAlive", "false");
        }
    }

    private String getListAsString(List<String> list, String separator) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null) {
            for (String typeId : list) {
                stringBuilder.append(typeId);
                if (typeId.equals(list.get(list.size() - 1))) continue;
                stringBuilder.append(separator);
            }
        }
        return stringBuilder.toString();
    }

    public static class Builder {
        private Context mContext = null;
        private String mPublicKey = null;
        public String mPrivateKey;
        public ServicePreference mServicePreference;
        private Boolean mBetaEnvironment;

        public Builder setContext(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("context is null");
            }
            this.mContext = context;
            return this;
        }

        public Builder setPrivateKey(String key) {
            this.mPrivateKey = key;
            return this;
        }

        public Builder setPublicKey(String key) {
            this.mPublicKey = key;
            return this;
        }

        public Builder setServicePreference(ServicePreference servicePreference) {
            this.mServicePreference = servicePreference;
            return this;
        }

        public Builder setBetaEnvironment(Boolean betaEnvironment) {
            this.mBetaEnvironment = betaEnvironment;
            return this;
        }

        public MercadoPagoServices build() {
            if (this.mContext == null) {
                throw new IllegalStateException("context is null");
            }
            if (TextUtil.isEmpty(this.mPublicKey) && TextUtil.isEmpty(this.mPrivateKey)) {
                throw new IllegalStateException("key is null");
            }
            return new MercadoPagoServices(this);
        }
    }
}

