/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.util;

import android.content.Context;
import com.mercadopago.core.Settings;
import java.io.File;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;

public class HttpClientUtil {
    private static OkHttpClient client;
    private static OkHttpClient customClient;

    public static synchronized OkHttpClient getClient(Context context, int connectTimeout, int readTimeout, int writeTimeout) {
        if (HttpClientUtil.customClientSet()) {
            return customClient;
        }
        if (client == null) {
            HttpClientUtil.createClient(context, connectTimeout, readTimeout, writeTimeout);
        }
        return client;
    }

    private static void createClient(Context context, int connectTimeout, int readTimeout, int writeTimeout) {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        interceptor.setLevel(Settings.OKHTTP_LOGGING);
        int cacheSize = 0xA00000;
        Cache cache = new Cache(new File(context.getCacheDir().getPath() + "okhttp"), (long)cacheSize);
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().connectTimeout((long)connectTimeout, TimeUnit.SECONDS).writeTimeout((long)writeTimeout, TimeUnit.SECONDS).readTimeout((long)readTimeout, TimeUnit.SECONDS).cache(cache).addInterceptor((Interceptor)interceptor);
        client = okHttpClientBuilder.build();
    }

    public static void setCustomClient(OkHttpClient client) {
        customClient = client;
    }

    public static void removeCustomClient() {
        customClient = null;
    }

    private static boolean customClientSet() {
        return customClient != null;
    }
}

