/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.util;

import android.text.Html;
import android.text.Spanned;
import com.mercadopago.model.Currency;
import com.mercadopago.util.TextUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CurrenciesUtil {
    public static final String CURRENCY_ARGENTINA = "ARS";
    public static final String CURRENCY_BRAZIL = "BRL";
    public static final String CURRENCY_CHILE = "CLP";
    public static final String CURRENCY_COLOMBIA = "COP";
    public static final String CURRENCY_MEXICO = "MXN";
    public static final String CURRENCY_VENEZUELA = "VEF";
    public static final String CURRENCY_USA = "USD";
    public static final String CURRENCY_PERU = "PEN";
    public static final String CURRENCY_URUGUAY = "UYU";
    private static Map<String, Currency> currenciesList = new HashMap<String, Currency>(){
        {
            this.put(CurrenciesUtil.CURRENCY_ARGENTINA, new Currency(CurrenciesUtil.CURRENCY_ARGENTINA, "Peso argentino", "$", 2, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_BRAZIL, new Currency(CurrenciesUtil.CURRENCY_BRAZIL, "Real", "R$", 2, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_CHILE, new Currency(CurrenciesUtil.CURRENCY_CHILE, "Peso chileno", "$", 0, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_COLOMBIA, new Currency(CurrenciesUtil.CURRENCY_COLOMBIA, "Peso colombiano", "$", 0, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_MEXICO, new Currency(CurrenciesUtil.CURRENCY_MEXICO, "Peso mexicano", "$", 2, Character.valueOf(".".charAt(0)), Character.valueOf(",".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_VENEZUELA, new Currency(CurrenciesUtil.CURRENCY_VENEZUELA, "Bolivar fuerte", "BsF", 2, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_USA, new Currency(CurrenciesUtil.CURRENCY_USA, "Dolar americano", "US$", 2, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_PERU, new Currency(CurrenciesUtil.CURRENCY_PERU, "Soles", "S/.", 2, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_URUGUAY, new Currency(CurrenciesUtil.CURRENCY_URUGUAY, "Peso Uruguayo", "$", 2, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
        }
    };

    protected CurrenciesUtil() {
    }

    public static String formatNumber(BigDecimal amount, String currencyId) {
        Currency currency = currenciesList.get(currencyId);
        if (currency != null) {
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator(currency.getDecimalSeparator().charValue());
            dfs.setGroupingSeparator(currency.getThousandsSeparator().charValue());
            DecimalFormat df = new DecimalFormat();
            df.setDecimalFormatSymbols(dfs);
            df.setMinimumFractionDigits(currency.getDecimalPlaces());
            df.setMaximumFractionDigits(currency.getDecimalPlaces());
            return currency.getSymbol() + " " + df.format(amount);
        }
        return null;
    }

    public static Spanned getFormattedAmount(BigDecimal amount, String currencyId) {
        String originalNumber = CurrenciesUtil.formatNumber(amount, currencyId);
        Spanned amountText = CurrenciesUtil.formatCurrencyInText(amount, currencyId, originalNumber, false, true);
        return amountText;
    }

    public static Spanned formatNumber(BigDecimal amount, String currencyId, boolean symbolUp, boolean decimalsUp) {
        Currency currency = currenciesList.get(currencyId);
        if (currency != null) {
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator(currency.getDecimalSeparator().charValue());
            dfs.setGroupingSeparator(currency.getThousandsSeparator().charValue());
            DecimalFormat df = new DecimalFormat();
            df.setDecimalFormatSymbols(dfs);
            df.setMinimumFractionDigits(currency.getDecimalPlaces());
            df.setMaximumFractionDigits(currency.getDecimalPlaces());
            String formatedAmount = df.format(amount);
            String spannedString = CurrenciesUtil.getSpannedString(currency, formatedAmount, symbolUp, decimalsUp);
            return Html.fromHtml((String)spannedString);
        }
        return null;
    }

    private static String getSpannedString(Currency currency, String formattedAmount, boolean symbolUp, boolean decimalsUp) {
        if (formattedAmount.contains(currency.getSymbol())) {
            formattedAmount = formattedAmount.replace(currency.getSymbol(), "");
        }
        int decimalDivisionIndex = formattedAmount.indexOf(currency.getDecimalSeparator().charValue());
        String wholeNumber = null;
        String decimals = null;
        if (decimalDivisionIndex == -1) {
            wholeNumber = formattedAmount;
        } else {
            wholeNumber = formattedAmount.substring(0, decimalDivisionIndex);
            decimals = formattedAmount.substring(decimalDivisionIndex + 1, formattedAmount.length());
        }
        StringBuilder htmlFormatBuilder = new StringBuilder();
        if (symbolUp) {
            htmlFormatBuilder.append("<sup><small><small>" + currency.getSymbol() + " </small></small></sup>");
        } else {
            htmlFormatBuilder.append(currency.getSymbol());
        }
        htmlFormatBuilder.append(wholeNumber);
        if (decimals != null) {
            if (decimalsUp) {
                htmlFormatBuilder.append("<sup><small><small> " + decimals + "</small></small></sup>");
            } else {
                htmlFormatBuilder.append(decimals);
            }
        }
        return htmlFormatBuilder.toString();
    }

    public static Spanned formatCurrencyInText(BigDecimal amount, String currencyId, String originalText, boolean symbolUp, boolean decimalsUp) {
        return CurrenciesUtil.formatCurrencyInText("", amount, currencyId, originalText, symbolUp, decimalsUp);
    }

    public static Spanned formatCurrencyInText(String amountPrefix, BigDecimal amount, String currencyId, String originalText, boolean symbolUp, boolean decimalsUp) {
        Spanned spannedAmount;
        Currency currency = currenciesList.get(currencyId);
        String formattedAmount = CurrenciesUtil.formatNumber(amount, currencyId);
        if (formattedAmount != null) {
            String spannedString = CurrenciesUtil.getSpannedString(currency, formattedAmount, symbolUp, decimalsUp);
            String formattedText = originalText;
            if (originalText.contains(formattedAmount)) {
                formattedText = originalText.replace(formattedAmount, amountPrefix + spannedString);
            }
            spannedAmount = Html.fromHtml((String)formattedText);
        } else {
            spannedAmount = Html.fromHtml((String)originalText);
        }
        return spannedAmount;
    }

    public static boolean isValidCurrency(String currencyId) {
        return !TextUtil.isEmpty(currencyId) && currenciesList.containsKey(currencyId);
    }

    public static List<Currency> getAllCurrencies() {
        return new ArrayList<Currency>(currenciesList.values());
    }

    public static Currency getCurrency(String currencyKey) {
        return currenciesList.get(currencyKey);
    }
}

