/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.util;

import android.app.Activity;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.mercadopago.model.ApiException;
import com.mercadopago.model.Cause;
import com.mercadopago.services.R;
import com.mercadopago.util.JsonUtil;
import retrofit2.Response;

public class ApiUtil {
    public static <T> ApiException getApiException(Response<T> response) {
        ApiException apiException = null;
        try {
            String errorString = response.errorBody().string();
            apiException = JsonUtil.getInstance().fromJson(errorString, ApiException.class);
        }
        catch (Exception exception) {
        }
        finally {
            if (apiException == null) {
                apiException = new ApiException();
                apiException.setStatus(response.code());
            }
        }
        return apiException;
    }

    public static ApiException getApiException(Throwable throwable) {
        ApiException apiException = new ApiException();
        try {
            apiException.setMessage(throwable.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return apiException;
    }

    public static void finishWithApiException(Activity activity, ApiException apiException) {
        throw new RuntimeException("Deprecated");
    }

    public static boolean checkConnection(Context context) {
        if (context != null) {
            try {
                boolean HaveConnectedWifi = false;
                boolean HaveConnectedMobile = false;
                ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo ni = cm.getActiveNetworkInfo();
                if (ni != null && ni.isConnected()) {
                    if (ni.getType() == 1 && ni.isConnectedOrConnecting()) {
                        HaveConnectedWifi = true;
                    }
                    if (ni.getType() == 0 && ni.isConnectedOrConnecting()) {
                        HaveConnectedMobile = true;
                    }
                }
                return HaveConnectedWifi || HaveConnectedMobile;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    public static String getApiExceptionMessage(Context context, ApiException apiException) {
        String message;
        if (apiException.getCause() != null && !apiException.getCause().isEmpty()) {
            String errorCode;
            Cause cause = apiException.getCause().get(0);
            switch (errorCode = cause.getCode()) {
                case "2021": {
                    message = context.getString(R.string.mpsdk_customer_not_allowed_to_operate);
                    break;
                }
                case "2022": {
                    message = context.getString(R.string.mpsdk_collector_not_allowed_to_operate);
                    break;
                }
                case "2035": {
                    message = context.getString(R.string.mpsdk_invalid_users_involved);
                    break;
                }
                case "3000": {
                    message = context.getString(R.string.mpsdk_customer_equal_to_collector);
                    break;
                }
                case "3001": {
                    message = context.getString(R.string.mpsdk_invalid_card_holder_name);
                    break;
                }
                case "3010": {
                    message = context.getString(R.string.mpsdk_unauthorized_client);
                    break;
                }
                case "3012": {
                    message = context.getString(R.string.mpsdk_payment_method_not_found);
                    break;
                }
                case "3013": {
                    message = context.getString(R.string.mpsdk_invalid_security_code);
                    break;
                }
                case "3014": {
                    message = context.getString(R.string.mpsdk_security_code_required);
                    break;
                }
                case "3015": {
                    message = context.getString(R.string.mpsdk_invalid_payment_method);
                    break;
                }
                case "3017": {
                    message = context.getString(R.string.mpsdk_invalid_card_number);
                    break;
                }
                case "3019": {
                    message = context.getString(R.string.mpsdk_empty_card_expiration_month);
                    break;
                }
                case "3020": {
                    message = context.getString(R.string.mpsdk_empty_card_expiration_year);
                    break;
                }
                case "3021": {
                    message = context.getString(R.string.mpsdk_empty_card_holder_name);
                    break;
                }
                case "3022": {
                    message = context.getString(R.string.mpsdk_empty_document_number);
                    break;
                }
                case "3023": {
                    message = context.getString(R.string.mpsdk_empty_document_type);
                    break;
                }
                case "3028": {
                    message = context.getString(R.string.mpsdk_invalid_payment_type_id);
                    break;
                }
                case "3029": {
                    message = context.getString(R.string.mpsdk_invalid_payment_method);
                    break;
                }
                case "3030": {
                    message = context.getString(R.string.mpsdk_invalid_card_expiration_month);
                    break;
                }
                case "4000": {
                    message = context.getString(R.string.mpsdk_invalid_card_expiration_year);
                    break;
                }
                case "4050": {
                    message = context.getString(R.string.mpsdk_invalid_payer_email);
                    break;
                }
                default: {
                    message = context.getString(R.string.mpsdk_standard_error_message);
                    break;
                }
            }
        } else {
            message = context.getString(R.string.mpsdk_standard_error_message);
        }
        return message;
    }

    public class StatusCodes {
        public static final int INTERNAL_SERVER_ERROR = 500;
        public static final int PROCESSING = 503;
        public static final int BAD_REQUEST = 400;
        public static final int NOT_FOUND = 404;
    }
}

