/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.preferences;

import com.google.gson.annotations.SerializedName;
import com.mercadopago.constants.PaymentTypes;
import com.mercadopago.constants.Sites;
import com.mercadopago.exceptions.CheckoutPreferenceException;
import com.mercadopago.model.Item;
import com.mercadopago.model.Payer;
import com.mercadopago.model.Site;
import com.mercadopago.preferences.PaymentPreference;
import com.mercadopago.util.CurrenciesUtil;
import com.mercadopago.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CheckoutPreference {
    private String id;
    private List<Item> items;
    private Payer payer;
    @SerializedName(value="payment_methods")
    private PaymentPreference paymentPreference;
    private Date expirationDateTo;
    private Date expirationDateFrom;
    private String siteId;
    private Site localPreferenceSite;

    public CheckoutPreference(Builder builder) {
        this.items = builder.items;
        this.expirationDateFrom = builder.expirationDateFrom;
        this.expirationDateTo = builder.expirationDateTo;
        this.localPreferenceSite = builder.localPreferenceSite;
        Payer payer = new Payer();
        payer.setEmail(builder.payerEmail);
        payer.setAccessToken(builder.payerAccessToken);
        this.payer = payer;
        PaymentPreference paymentPreference = new PaymentPreference();
        paymentPreference.setExcludedPaymentTypeIds(builder.excludedPaymentTypes);
        paymentPreference.setExcludedPaymentMethodIds(builder.excludedPaymentMethods);
        paymentPreference.setMaxAcceptedInstallments(builder.maxInstallments);
        paymentPreference.setDefaultInstallments(builder.defaultInstallments);
        this.paymentPreference = paymentPreference;
        this.id = builder.id;
    }

    public void validate() throws CheckoutPreferenceException {
        if (this.hasId() && !this.itemsValid().booleanValue()) {
            throw new CheckoutPreferenceException(0);
        }
        if (this.hasId() && !this.hasEmail()) {
            throw new CheckoutPreferenceException(6);
        }
        if (this.isExpired().booleanValue()) {
            throw new CheckoutPreferenceException(1);
        }
        if (!this.isActive().booleanValue()) {
            throw new CheckoutPreferenceException(2);
        }
        if (!this.validInstallmentsPreference()) {
            throw new CheckoutPreferenceException(3);
        }
        if (!this.validPaymentTypeExclusion()) {
            throw new CheckoutPreferenceException(4);
        }
    }

    private boolean hasEmail() {
        return this.payer != null && !TextUtil.isEmpty(this.payer.getEmail());
    }

    public boolean validPaymentTypeExclusion() {
        return this.paymentPreference == null || this.paymentPreference.excludedPaymentTypesValid();
    }

    public boolean validInstallmentsPreference() {
        return this.paymentPreference == null || this.paymentPreference.installmentPreferencesValid();
    }

    public Boolean itemsValid() {
        boolean valid = true;
        if (this.items == null || this.items.isEmpty() || this.items.get(0) == null) {
            valid = false;
        } else if (TextUtil.isEmpty(this.items.get(0).getCurrencyId())) {
            valid = false;
        } else {
            String firstCurrencyId = this.items.get(0).getCurrencyId();
            for (Item item : this.items) {
                String currentCurrencyId = item.getCurrencyId();
                if (this.isItemValid(item) && currentCurrencyId.equals(firstCurrencyId)) continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    private boolean isItemValid(Item item) {
        Boolean valid = true;
        if (item == null) {
            valid = false;
        } else if (item.getId() == null) {
            valid = false;
        } else if (item.getQuantity() == null || item.getQuantity() < 1) {
            valid = false;
        } else if (item.getUnitPrice() == null || item.getUnitPrice().compareTo(BigDecimal.ZERO) < 0) {
            valid = false;
        } else if (item.getCurrencyId() == null) {
            valid = false;
        } else if (!CurrenciesUtil.isValidCurrency(item.getCurrencyId())) {
            valid = false;
        }
        return valid;
    }

    public Boolean isExpired() {
        Date date = new Date();
        return this.expirationDateTo != null && date.after(this.expirationDateTo);
    }

    public Boolean isActive() {
        Date date = new Date();
        return this.expirationDateFrom == null || date.after(this.expirationDateFrom);
    }

    public void setExpirationDate(Date date) {
        this.expirationDateTo = date;
    }

    public void setActiveFrom(Date date) {
        this.expirationDateFrom = date;
    }

    public void setPaymentPreference(PaymentPreference paymentPreference) {
        this.paymentPreference = paymentPreference;
    }

    public BigDecimal getAmount() {
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (this.items != null) {
            for (Item item : this.items) {
                if (item != null && item.getUnitPrice() != null && item.getQuantity() != null) {
                    totalAmount = totalAmount.add(item.getUnitPrice().multiply(new BigDecimal(item.getQuantity())));
                    continue;
                }
                return null;
            }
        }
        return totalAmount;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public Payer getPayer() {
        return this.payer;
    }

    public void setPayer(Payer payer) {
        this.payer = payer;
    }

    public Integer getMaxInstallments() {
        if (this.paymentPreference != null) {
            return this.paymentPreference.getMaxInstallments();
        }
        return null;
    }

    public Integer getDefaultInstallments() {
        if (this.paymentPreference != null) {
            return this.paymentPreference.getDefaultInstallments();
        }
        return null;
    }

    public List<String> getExcludedPaymentMethods() {
        if (this.paymentPreference != null) {
            return this.paymentPreference.getExcludedPaymentMethodIds();
        }
        return null;
    }

    public List<String> getExcludedPaymentTypes() {
        if (this.paymentPreference != null) {
            return this.paymentPreference.getExcludedPaymentTypes();
        }
        return null;
    }

    public String getDefaultPaymentMethodId() {
        if (this.paymentPreference != null) {
            return this.paymentPreference.getDefaultPaymentMethodId();
        }
        return null;
    }

    public PaymentPreference getPaymentPreference() {
        return this.paymentPreference;
    }

    public Site getSite() {
        if (this.localPreferenceSite == null) {
            return Sites.getById(this.siteId);
        }
        return this.localPreferenceSite;
    }

    public boolean hasId() {
        return this.getId() != null;
    }

    public static class Builder {
        private List<Item> items = new ArrayList<Item>();
        private List<String> excludedPaymentMethods = new ArrayList<String>();
        private List<String> excludedPaymentTypes = new ArrayList<String>();
        private Integer maxInstallments;
        private Integer defaultInstallments;
        private String payerEmail;
        private Date expirationDateTo;
        private Date expirationDateFrom;
        private Site localPreferenceSite;
        private String payerAccessToken;
        private boolean excludeAccountMoney = true;
        private String id;

        public Builder addItem(Item item) {
            if (item != null) {
                this.items.add(item);
            }
            return this;
        }

        public Builder addItems(List<Item> items) {
            if (items != null) {
                this.items.addAll(items);
            }
            return this;
        }

        public Builder addExcludedPaymentMethod(String paymentMethodId) {
            if (paymentMethodId != null) {
                this.excludedPaymentMethods.add(paymentMethodId);
            }
            return this;
        }

        public Builder addExcludedPaymentMethods(List<String> paymentMethodIds) {
            if (paymentMethodIds != null) {
                this.excludedPaymentMethods.addAll(paymentMethodIds);
            }
            return this;
        }

        public Builder addExcludedPaymentType(String paymentTypeId) {
            if (paymentTypeId != null) {
                this.excludedPaymentTypes.add(paymentTypeId);
            }
            return this;
        }

        public Builder addExcludedPaymentTypes(List<String> paymentTypeIds) {
            if (paymentTypeIds != null) {
                this.excludedPaymentTypes.addAll(paymentTypeIds);
            }
            return this;
        }

        public Builder setMaxInstallments(Integer maxInstallments) {
            this.maxInstallments = maxInstallments;
            return this;
        }

        public Builder setDefaultInstallments(Integer defaultInstallments) {
            this.defaultInstallments = defaultInstallments;
            return this;
        }

        public Builder setPayerEmail(String payerEmail) {
            this.payerEmail = payerEmail;
            return this;
        }

        public Builder setSite(Site site) {
            this.localPreferenceSite = site;
            return this;
        }

        public Builder setExpirationDate(Date date) {
            this.expirationDateTo = date;
            return this;
        }

        public Builder setActiveFrom(Date date) {
            this.expirationDateFrom = date;
            return this;
        }

        public Builder setPayerAccessToken(String payerAccessToken) {
            this.payerAccessToken = payerAccessToken;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder enableAccountMoney() {
            this.excludeAccountMoney = false;
            return this;
        }

        public CheckoutPreference build() {
            if (this.items == null || this.items.isEmpty()) {
                throw new IllegalStateException("Items required");
            }
            if (this.localPreferenceSite == null) {
                throw new IllegalStateException("Site is required");
            }
            if (this.excludeAccountMoney) {
                this.addExcludedPaymentType(PaymentTypes.ACCOUNT_MONEY);
            }
            return new CheckoutPreference(this);
        }
    }
}

