/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.model;

import android.content.Context;
import android.text.TextUtils;
import com.mercadopago.model.Card;
import com.mercadopago.model.CardToken;
import com.mercadopago.model.Device;
import com.mercadopago.services.R;

public class SavedCardToken {
    private String cardId;
    private String securityCode;
    private Device device;

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Context context) {
        this.device = new Device(context);
    }

    public String getCardId() {
        return this.cardId;
    }

    public void setCardId(String cardNumber) {
        this.cardId = cardNumber;
    }

    public String getSecurityCode() {
        return this.securityCode;
    }

    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }

    public SavedCardToken(String cardId, String securityCode) {
        this.cardId = cardId;
        this.securityCode = securityCode;
    }

    public boolean validate() {
        return this.validateCardId() && this.validateSecurityCode();
    }

    public boolean validateCardId() {
        return !TextUtils.isEmpty((CharSequence)this.cardId) && TextUtils.isDigitsOnly((CharSequence)this.cardId);
    }

    public boolean validateSecurityCode() {
        return CardToken.validateSecurityCode(this.securityCode);
    }

    public void validateSecurityCode(Context context, Card card) throws Exception {
        if (this.securityCode != null) {
            int cvvLength;
            int n = cvvLength = card.getSecurityCode() != null ? card.getSecurityCode().getLength() : 0;
            if (cvvLength != 0 && this.securityCode.length() != cvvLength) {
                throw new Exception(context.getString(R.string.mpsdk_invalid_cvv_length, new Object[]{cvvLength}));
            }
        } else {
            throw new Exception(context.getString(R.string.mpsdk_invalid_field));
        }
    }
}

