/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.model;

import com.mercadopago.model.Issuer;
import com.mercadopago.model.PayerCost;
import com.mercadopago.model.PaymentMethod;
import com.mercadopago.model.Token;

public class PaymentRecovery {
    private Token mToken;
    private String mStatus;
    private String mStatusDetail;
    private PaymentMethod mPaymentMethod;
    private PayerCost mPayerCost;
    private Issuer mIssuer;

    public PaymentRecovery(Token token, PaymentMethod paymentMethod, PayerCost payerCost, Issuer issuer, String paymentStatus, String paymentStatusDetail) {
        this.validate(token, paymentMethod, payerCost, issuer, paymentStatus, paymentStatusDetail);
        this.mToken = token;
        this.mPaymentMethod = paymentMethod;
        this.mPayerCost = payerCost;
        this.mIssuer = issuer;
        this.mStatusDetail = paymentStatusDetail;
    }

    private void validate(Token token, PaymentMethod paymentMethod, PayerCost payerCost, Issuer issuer, String paymentStatus, String paymentStatusDetail) {
        if (token == null) {
            throw new IllegalStateException("token is null");
        }
        if (paymentMethod == null) {
            throw new IllegalStateException("payment method is null");
        }
        if (payerCost == null) {
            throw new IllegalStateException("payer cost is null");
        }
        if (issuer == null) {
            throw new IllegalStateException("issuer is null");
        }
        if (!this.isRecoverablePaymentStatus(paymentStatus, paymentStatusDetail)) {
            throw new IllegalStateException("this payment is not recoverable");
        }
    }

    public Token getToken() {
        return this.mToken;
    }

    public PaymentMethod getPaymentMethod() {
        return this.mPaymentMethod;
    }

    public PayerCost getPayerCost() {
        return this.mPayerCost;
    }

    public Issuer getIssuer() {
        return this.mIssuer;
    }

    public boolean isTokenRecoverable() {
        return this.isStatusDetailCallForAuthorize(this.mStatusDetail);
    }

    private boolean isRecoverablePaymentStatus(String paymentStatus, String paymentStatusDetail) {
        return "rejected".equals(paymentStatus) && this.isPaymentStatusRecoverable(paymentStatusDetail);
    }

    private boolean isPaymentStatusRecoverable(String statusDetail) {
        return "cc_rejected_bad_filled_other".equals(statusDetail) || "cc_rejected_bad_filled_card_number".equals(statusDetail) || "cc_rejected_bad_filled_security_code".equals(statusDetail) || "cc_rejected_bad_filled_date".equals(statusDetail) || "cc_rejected_call_for_authorize".equals(statusDetail);
    }

    private Boolean isStatusDetailCallForAuthorize(String statusDetail) {
        return statusDetail != null && "cc_rejected_call_for_authorize".equals(statusDetail);
    }
}

