/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.model;

import com.google.gson.annotations.SerializedName;
import com.mercadopago.model.AccountMoney;
import com.mercadopago.model.Card;
import com.mercadopago.model.CustomSearchItem;
import com.mercadopago.model.PaymentMethod;
import com.mercadopago.model.PaymentMethodSearchItem;
import java.util.ArrayList;
import java.util.List;

public class PaymentMethodSearch {
    private List<PaymentMethodSearchItem> groups;
    @SerializedName(value="custom_options")
    private List<CustomSearchItem> customSearchItems;
    private List<PaymentMethod> paymentMethods;
    private List<Card> cards;
    private AccountMoney accountMoney;

    public List<PaymentMethodSearchItem> getGroups() {
        return this.groups;
    }

    public List<PaymentMethod> getPaymentMethods() {
        return this.paymentMethods;
    }

    public boolean hasSearchItems() {
        return this.groups != null && !this.groups.isEmpty();
    }

    public PaymentMethod getPaymentMethodBySearchItem(PaymentMethodSearchItem item) {
        PaymentMethod requiredPaymentMethod = null;
        if (this.paymentMethods != null && item != null && item.getId() != null) {
            for (PaymentMethod currentPaymentMethod : this.paymentMethods) {
                if (!this.itemMatchesPaymentMethod(item, currentPaymentMethod)) continue;
                requiredPaymentMethod = currentPaymentMethod;
                requiredPaymentMethod.setPaymentTypeId(this.getPaymentTypeIdFromItem(item, currentPaymentMethod));
            }
        }
        return requiredPaymentMethod;
    }

    private String getPaymentTypeIdFromItem(PaymentMethodSearchItem item, PaymentMethod paymentMethod) {
        String itemIdWithoutPaymentMethod = item.getId().replaceFirst(paymentMethod.getId(), "");
        String paymentType = itemIdWithoutPaymentMethod.isEmpty() ? paymentMethod.getPaymentTypeId() : itemIdWithoutPaymentMethod.substring(1);
        return paymentType;
    }

    private boolean itemMatchesPaymentMethod(PaymentMethodSearchItem item, PaymentMethod paymentMethod) {
        return item.getId().startsWith(paymentMethod.getId());
    }

    public PaymentMethodSearchItem getSearchItemByPaymentMethod(PaymentMethod selectedPaymentMethod) {
        PaymentMethodSearchItem requiredItem = null;
        if (selectedPaymentMethod != null) {
            requiredItem = this.searchItemMatchingPaymentMethod(selectedPaymentMethod);
        }
        return requiredItem;
    }

    private PaymentMethodSearchItem searchItemMatchingPaymentMethod(PaymentMethod paymentMethod) {
        return this.searchItemInList(this.groups, paymentMethod);
    }

    private PaymentMethodSearchItem searchItemInList(List<PaymentMethodSearchItem> list, PaymentMethod paymentMethod) {
        PaymentMethodSearchItem requiredItem = null;
        for (PaymentMethodSearchItem currentItem : list) {
            if (this.itemMatchesPaymentMethod(currentItem, paymentMethod) && currentItem.getId().equals(paymentMethod.getId())) {
                requiredItem = currentItem;
                break;
            }
            if (this.itemMatchesPaymentMethod(currentItem, paymentMethod)) {
                String potentialPaymentType = currentItem.getId().replaceFirst(paymentMethod.getId(), "");
                if (!potentialPaymentType.endsWith(paymentMethod.getPaymentTypeId())) continue;
                requiredItem = currentItem;
                break;
            }
            if (!currentItem.hasChildren() || (requiredItem = this.searchItemInList(currentItem.getChildren(), paymentMethod)) == null) continue;
            break;
        }
        return requiredItem;
    }

    public PaymentMethod getPaymentMethodById(String paymentMethodId) {
        PaymentMethod foundPaymentMethod = null;
        if (this.paymentMethods != null) {
            for (PaymentMethod paymentMethod : this.paymentMethods) {
                if (!paymentMethod.getId().equals(paymentMethodId)) continue;
                foundPaymentMethod = paymentMethod;
                break;
            }
        }
        return foundPaymentMethod;
    }

    public Card getCardById(String cardId) {
        Card foundCard = null;
        if (this.cards != null) {
            for (Card card : this.cards) {
                if (!card.getId().equals(cardId)) continue;
                foundCard = card;
                break;
            }
        }
        return foundCard;
    }

    public List<CustomSearchItem> getCustomSearchItems() {
        return this.customSearchItems;
    }

    public boolean hasCustomSearchItems() {
        return this.customSearchItems != null && !this.customSearchItems.isEmpty();
    }

    public List<Card> getCards() {
        return this.cards;
    }

    public AccountMoney getAccountMoney() {
        return this.accountMoney;
    }

    public boolean hasSavedCards() {
        return this.cards != null && !this.cards.isEmpty();
    }

    public void addCards(List<Card> cards, String lastFourDigitsText) {
        if (cards != null) {
            if (this.customSearchItems == null) {
                this.customSearchItems = new ArrayList<CustomSearchItem>();
            }
            if (this.cards == null) {
                this.cards = new ArrayList<Card>();
            }
            for (Card card : cards) {
                CustomSearchItem searchItem = new CustomSearchItem();
                searchItem.setDescription(lastFourDigitsText + " " + card.getLastFourDigits());
                searchItem.setType(card.getPaymentMethod().getPaymentTypeId());
                searchItem.setId(card.getId());
                searchItem.setPaymentMethodId(card.getPaymentMethod().getId());
                this.customSearchItems.add(searchItem);
                this.cards.add(card);
            }
        }
    }
}

