/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.model;

import com.mercadopago.model.Setting;
import java.math.BigDecimal;
import java.util.List;

public class PaymentMethod {
    private List<String> additionalInfoNeeded;
    private String id;
    private String name;
    private String paymentTypeId;
    private String status;
    private String secureThumbnail;
    private String thumbnail;
    private String deferredCapture;
    private List<Setting> settings;
    private BigDecimal minAllowedAmount;
    private BigDecimal maxAllowedAmount;
    private Integer accreditationTime;

    public List<String> getAdditionalInfoNeeded() {
        return this.additionalInfoNeeded;
    }

    public void setAdditionalInfoNeeded(List<String> additionalInfoNeeded) {
        this.additionalInfoNeeded = additionalInfoNeeded;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPaymentTypeId() {
        return this.paymentTypeId;
    }

    public void setPaymentTypeId(String paymentTypeId) {
        this.paymentTypeId = paymentTypeId;
    }

    public List<Setting> getSettings() {
        return this.settings;
    }

    public void setSettings(List<Setting> settings) {
        this.settings = settings;
    }

    public String toString() {
        return this.name;
    }

    public boolean isIssuerRequired() {
        return this.isAdditionalInfoNeeded("issuer_id");
    }

    public boolean isSecurityCodeRequired(String bin) {
        Setting setting = Setting.getSettingByBin(this.settings, bin);
        return setting != null && setting.getSecurityCode() != null && setting.getSecurityCode().getLength() != 0;
    }

    public boolean isIdentificationTypeRequired() {
        return this.isAdditionalInfoNeeded("cardholder_identification_type");
    }

    public boolean isIdentificationNumberRequired() {
        return this.isAdditionalInfoNeeded("cardholder_identification_number");
    }

    private boolean isAdditionalInfoNeeded(String param) {
        if (this.additionalInfoNeeded != null && this.additionalInfoNeeded.size() > 0) {
            for (int i = 0; i < this.additionalInfoNeeded.size(); ++i) {
                if (!this.additionalInfoNeeded.get(i).equals(param)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidForBin(String bin) {
        return Setting.getSettingByBin(this.getSettings(), bin) != null;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSecureThumbnail() {
        return this.secureThumbnail;
    }

    public void setSecureThumbnail(String secureThumbnail) {
        this.secureThumbnail = secureThumbnail;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public String getDeferredCapture() {
        return this.deferredCapture;
    }

    public void setDeferredCapture(String deferredCapture) {
        this.deferredCapture = deferredCapture;
    }

    public BigDecimal getMinAllowedAmount() {
        return this.minAllowedAmount;
    }

    public void setMinAllowedAmount(BigDecimal minAllowedAmount) {
        this.minAllowedAmount = minAllowedAmount;
    }

    public BigDecimal getMaxAllowedAmount() {
        return this.maxAllowedAmount;
    }

    public void setMaxAllowedAmount(BigDecimal maxAllowedAmount) {
        this.maxAllowedAmount = maxAllowedAmount;
    }

    public void setAccreditationTime(Integer accreditationTime) {
        this.accreditationTime = accreditationTime;
    }

    public Integer getAccreditationTime() {
        return this.accreditationTime;
    }
}

