/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.model;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PayerCost {
    public static final String CFT = "CFT";
    public static final String TEA = "TEA";
    private Integer installments;
    private BigDecimal installmentRate;
    private List<String> labels;
    private BigDecimal minAllowedAmount;
    private BigDecimal maxAllowedAmount;
    private String recommendedMessage;
    private BigDecimal installmentAmount;
    private BigDecimal totalAmount;

    public Integer getInstallments() {
        return this.installments;
    }

    public void setInstallments(Integer installments) {
        this.installments = installments;
    }

    public BigDecimal getInstallmentRate() {
        return this.installmentRate;
    }

    public void setInstallmentRate(BigDecimal installmentRate) {
        this.installmentRate = installmentRate;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public BigDecimal getMinAllowedAmount() {
        return this.minAllowedAmount;
    }

    public void setMinAllowedAmount(BigDecimal minAllowedAmount) {
        this.minAllowedAmount = minAllowedAmount;
    }

    public BigDecimal getMaxAllowedAmount() {
        return this.maxAllowedAmount;
    }

    public void setMaxAllowedAmount(BigDecimal maxAllowedAmount) {
        this.maxAllowedAmount = maxAllowedAmount;
    }

    public String getRecommendedMessage() {
        return this.recommendedMessage;
    }

    public void setRecommendedMessage(String recommendedMessage) {
        this.recommendedMessage = recommendedMessage;
    }

    public BigDecimal getInstallmentAmount() {
        return this.installmentAmount;
    }

    public void setInstallmentAmount(BigDecimal installmentAmount) {
        this.installmentAmount = installmentAmount;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getTEAPercent() {
        return this.getRates().get(TEA);
    }

    public String getCFTPercent() {
        return this.getRates().get(CFT);
    }

    public Map<String, String> getRates() {
        HashMap<String, String> ratesMap = new HashMap<String, String>();
        if (this.isValidLabels().booleanValue()) {
            for (String label : this.labels) {
                String[] ratesRaw;
                if (!label.contains(CFT) && !label.contains(TEA)) continue;
                for (String rate : ratesRaw = label.split("\\|")) {
                    String[] rates = rate.split("_");
                    ratesMap.put(rates[0], rates[1]);
                }
            }
        }
        return ratesMap;
    }

    public Boolean hasRates() {
        return this.hasTEA() != false && this.hasCFT() != false;
    }

    public Boolean hasCFT() {
        return this.getCFTPercent() != null;
    }

    public Boolean hasTEA() {
        return this.getTEAPercent() != null;
    }

    private Boolean isValidLabels() {
        return this.labels != null && this.labels.size() > 0;
    }

    public String toString() {
        return this.installments.toString();
    }
}

