/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.model;

import android.content.Context;
import android.text.TextUtils;
import com.mercadopago.model.Cardholder;
import com.mercadopago.model.Device;
import com.mercadopago.model.Identification;
import com.mercadopago.model.IdentificationType;
import com.mercadopago.model.PaymentMethod;
import com.mercadopago.model.Setting;
import com.mercadopago.services.R;
import java.util.Calendar;
import java.util.Locale;

public class CardToken {
    private static final Calendar now = Calendar.getInstance();
    public static final int MIN_LENGTH_NUMBER = 10;
    public static final int MAX_LENGTH_NUMBER = 19;
    private Cardholder cardholder;
    private String cardNumber;
    private Device device;
    private Integer expirationMonth;
    private Integer expirationYear;
    private String securityCode;

    public CardToken(String cardNumber, Integer expirationMonth, Integer expirationYear, String securityCode, String cardholderName, String identificationType, String identificationNumber) {
        this.cardNumber = this.normalizeCardNumber(cardNumber);
        this.expirationMonth = expirationMonth;
        this.expirationYear = CardToken.normalizeYear(expirationYear);
        this.securityCode = securityCode;
        this.cardholder = new Cardholder();
        this.cardholder.setName(cardholderName);
        Identification identification = new Identification();
        identification.setNumber(identificationNumber);
        identification.setType(identificationType);
        this.cardholder.setIdentification(identification);
    }

    public Cardholder getCardholder() {
        return this.cardholder;
    }

    public void setCardholder(Cardholder cardholder) {
        this.cardholder = cardholder;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Context context) {
        this.device = new Device(context);
    }

    public Integer getExpirationMonth() {
        return this.expirationMonth;
    }

    public void setExpirationMonth(Integer expirationMonth) {
        this.expirationMonth = expirationMonth;
    }

    public Integer getExpirationYear() {
        return this.expirationYear;
    }

    public void setExpirationYear(Integer expirationYear) {
        this.expirationYear = CardToken.normalizeYear(expirationYear);
    }

    public String getSecurityCode() {
        return this.securityCode;
    }

    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }

    public boolean validate(boolean includeSecurityCode) {
        boolean result;
        boolean bl = result = this.validateCardNumber() && this.validateExpiryDate() && this.validateIdentification() && this.validateCardholderName();
        if (includeSecurityCode) {
            result = result && this.validateSecurityCode();
        }
        return result;
    }

    public boolean validateCardNumber() {
        return !TextUtils.isEmpty((CharSequence)this.cardNumber) && this.cardNumber.length() > 10 && this.cardNumber.length() < 19;
    }

    public void validateCardNumber(Context context, PaymentMethod paymentMethod) throws Exception {
        if (TextUtils.isEmpty((CharSequence)this.cardNumber)) {
            throw new Exception(context.getString(R.string.mpsdk_invalid_empty_card));
        }
        Setting setting = Setting.getSettingByBin(paymentMethod.getSettings(), this.cardNumber.length() >= 6 ? this.cardNumber.substring(0, 6) : "");
        if (setting == null) {
            throw new Exception(context.getString(R.string.mpsdk_invalid_card_bin));
        }
        int cardLength = setting.getCardNumber().getLength();
        if (this.cardNumber.trim().length() != cardLength) {
            throw new Exception(context.getString(R.string.mpsdk_invalid_card_length, new Object[]{cardLength}));
        }
        String luhnAlgorithm = setting.getCardNumber().getValidation();
        if ("standard".equals(luhnAlgorithm) && !CardToken.checkLuhn(this.cardNumber)) {
            throw new Exception(context.getString(R.string.mpsdk_invalid_card_luhn));
        }
    }

    public boolean validateSecurityCode() {
        return CardToken.validateSecurityCode(this.securityCode);
    }

    public static boolean validateSecurityCode(String securityCode) {
        return securityCode == null || !TextUtils.isEmpty((CharSequence)securityCode) && securityCode.length() >= 3 && securityCode.length() <= 4;
    }

    public void validateSecurityCode(Context context, PaymentMethod paymentMethod) throws Exception {
        CardToken.validateSecurityCode(context, this.securityCode, paymentMethod, (this.cardNumber != null ? this.cardNumber.length() : 0) >= 6 ? this.cardNumber.substring(0, 6) : "");
    }

    public static void validateSecurityCode(Context context, String securityCode, PaymentMethod paymentMethod, String bin) throws Exception {
        if (paymentMethod != null) {
            Setting setting = Setting.getSettingByBin(paymentMethod.getSettings(), bin);
            if (setting != null) {
                int cvvLength = setting.getSecurityCode().getLength();
                if (securityCode == null || cvvLength != 0 && securityCode.trim().length() != cvvLength) {
                    throw new Exception(context.getString(R.string.mpsdk_invalid_cvv_length, new Object[]{cvvLength}));
                }
            } else {
                throw new Exception(context.getString(R.string.mpsdk_invalid_field));
            }
        }
    }

    public boolean validateExpiryDate() {
        return CardToken.validateExpiryDate(this.expirationMonth, this.expirationYear);
    }

    public static boolean validateExpiryDate(Integer month, Integer year) {
        if (!CardToken.validateExpMonth(month)) {
            return false;
        }
        if (!CardToken.validateExpYear(year)) {
            return false;
        }
        return !CardToken.hasMonthPassed(month, year);
    }

    public static boolean validateExpMonth(Integer month) {
        return month == null ? false : month >= 1 && month <= 12;
    }

    public static boolean validateExpYear(Integer year) {
        return year == null ? false : !CardToken.hasYearPassed(year);
    }

    public boolean validateIdentification() {
        return this.validateIdentificationType() && this.validateIdentificationNumber();
    }

    public boolean validateIdentificationType() {
        return this.cardholder == null ? false : (this.cardholder.getIdentification() == null ? false : !TextUtils.isEmpty((CharSequence)this.cardholder.getIdentification().getType()));
    }

    public boolean validateIdentificationNumber() {
        return this.cardholder == null ? false : (this.cardholder.getIdentification() == null ? false : (!this.validateIdentificationType() ? false : !TextUtils.isEmpty((CharSequence)this.cardholder.getIdentification().getNumber())));
    }

    public boolean validateIdentificationNumber(IdentificationType identificationType) {
        if (identificationType != null) {
            if (this.cardholder != null && this.cardholder.getIdentification() != null && this.cardholder.getIdentification().getNumber() != null) {
                int len = this.cardholder.getIdentification().getNumber().length();
                Integer min = identificationType.getMinLength();
                Integer max = identificationType.getMaxLength();
                if (min != null && max != null) {
                    return len <= max && len >= min;
                }
                return this.validateIdentificationNumber();
            }
            return false;
        }
        return this.validateIdentificationNumber();
    }

    public boolean validateCardholderName() {
        return this.cardholder == null ? false : !TextUtils.isEmpty((CharSequence)this.cardholder.getName());
    }

    public static boolean checkLuhn(String cardNumber) {
        int sum = 0;
        boolean alternate = false;
        if (cardNumber == null || cardNumber.length() == 0) {
            return false;
        }
        for (int i = cardNumber.length() - 1; i >= 0; --i) {
            int n = Integer.parseInt(cardNumber.substring(i, i + 1));
            if (alternate && (n *= 2) > 9) {
                n = n % 10 + 1;
            }
            sum += n;
            alternate = !alternate;
        }
        return sum % 10 == 0;
    }

    private static boolean hasYearPassed(int year) {
        int normalized = CardToken.normalizeYear(year);
        return normalized < now.get(1);
    }

    private static boolean hasMonthPassed(int month, int year) {
        return CardToken.hasYearPassed(year) || CardToken.normalizeYear(year).intValue() == now.get(1) && month < now.get(2) + 1;
    }

    private static Integer normalizeYear(Integer year) {
        if (year != null && year < 100 && year >= 0) {
            String currentYear = String.valueOf(now.get(1));
            String prefix = currentYear.substring(0, currentYear.length() - 2);
            year = Integer.parseInt(String.format(Locale.US, "%s%02d", prefix, year));
        }
        return year;
    }

    private String normalizeCardNumber(String number) {
        return number.trim().replaceAll("\\s+|-", "");
    }
}

