/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.model;

import com.mercadopago.model.Card;
import com.mercadopago.model.CardToken;
import com.mercadopago.model.Token;

public class CardInfo {
    private Integer cardNumberLength;
    private String lastFourDigits;
    private String firstSixDigits;

    public CardInfo(CardToken cardToken) {
        this.cardNumberLength = cardToken.getCardNumber().length();
        this.lastFourDigits = cardToken.getCardNumber().substring(this.cardNumberLength - 4, this.cardNumberLength);
        this.firstSixDigits = cardToken.getCardNumber().substring(0, 6);
    }

    public CardInfo(Token token) {
        this.cardNumberLength = token.getCardNumberLength();
        this.lastFourDigits = token.getLastFourDigits();
        this.firstSixDigits = token.getFirstSixDigits();
    }

    public CardInfo(Card card) {
        this.lastFourDigits = card.getLastFourDigits();
        this.firstSixDigits = card.getFirstSixDigits();
    }

    public static boolean canCreateCardInfo(Token token) {
        return token.getCardNumberLength() != null && token.getLastFourDigits() != null && token.getFirstSixDigits() != null;
    }

    public Integer getCardNumberLength() {
        return this.cardNumberLength;
    }

    public String getLastFourDigits() {
        return this.lastFourDigits;
    }

    public String getFirstSixDigits() {
        return this.firstSixDigits;
    }
}

