/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.core;

import android.content.Context;
import com.google.gson.Gson;
import com.mercadopago.adapters.ErrorHandlingCallAdapter;
import com.mercadopago.callbacks.Callback;
import com.mercadopago.controllers.CustomServicesHandler;
import com.mercadopago.model.BankDeal;
import com.mercadopago.model.Campaign;
import com.mercadopago.model.CardToken;
import com.mercadopago.model.Discount;
import com.mercadopago.model.IdentificationType;
import com.mercadopago.model.Installment;
import com.mercadopago.model.Instructions;
import com.mercadopago.model.Issuer;
import com.mercadopago.model.Payer;
import com.mercadopago.model.PayerIntent;
import com.mercadopago.model.Payment;
import com.mercadopago.model.PaymentBody;
import com.mercadopago.model.PaymentMethod;
import com.mercadopago.model.PaymentMethodSearch;
import com.mercadopago.model.SavedCardToken;
import com.mercadopago.model.SecurityCodeIntent;
import com.mercadopago.model.Site;
import com.mercadopago.model.Token;
import com.mercadopago.preferences.CheckoutPreference;
import com.mercadopago.preferences.ServicePreference;
import com.mercadopago.services.BankDealService;
import com.mercadopago.services.CheckoutService;
import com.mercadopago.services.DiscountService;
import com.mercadopago.services.GatewayService;
import com.mercadopago.services.IdentificationService;
import com.mercadopago.services.PaymentService;
import com.mercadopago.util.HttpClientUtil;
import com.mercadopago.util.JsonUtil;
import com.mercadopago.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class MercadoPagoServices {
    public static final int BIN_LENGTH = 6;
    private static final String MP_API_BASE_URL = "https://api.mercadopago.com";
    private static final String PAYMENT_RESULT_API_VERSION = "1.3.x";
    private static final String PAYMENT_METHODS_OPTIONS_API_VERSION = "1.3.x";
    public static final int DEFAULT_CONNECT_TIMEOUT = 10;
    public static final int DEFAULT_READ_TIMEOUT = 20;
    public static final int DEFAULT_WRITE_TIMEOUT = 20;
    public static final int DEFAULT_PAYMENT_CONNECT_TIMEOUT = 10;
    public static final int DEFAULT_PAYMENT_READ_TIMEOUT = 20;
    public static final int DEFAULT_PAYMENT_WRITE_TIMEOUT = 20;
    private ServicePreference mServicePreference;
    private String mPublicKey;
    private String mPrivateKey;
    private Context mContext;

    private MercadoPagoServices(Builder builder) {
        this.mContext = builder.mContext;
        this.mPublicKey = builder.mPublicKey;
        this.mPrivateKey = builder.mPrivateKey;
        this.mServicePreference = CustomServicesHandler.getInstance().getServicePreference();
        System.setProperty("http.keepAlive", "false");
    }

    public void getPreference(String checkoutPreferenceId, Callback<CheckoutPreference> callback) {
        CheckoutService service = (CheckoutService)this.getDefaultRetrofit().create(CheckoutService.class);
        service.getPreference(checkoutPreferenceId, this.mPublicKey).enqueue(callback);
    }

    public void getInstructions(Long paymentId, String paymentTypeId, Callback<Instructions> callback) {
        CheckoutService service = (CheckoutService)this.getDefaultRetrofit().create(CheckoutService.class);
        service.getPaymentResult(this.mContext.getResources().getConfiguration().locale.getLanguage(), paymentId, this.mPublicKey, paymentTypeId, "1.3.x").enqueue(callback);
    }

    public void getPaymentMethodSearch(BigDecimal amount, List<String> excludedPaymentTypes, List<String> excludedPaymentMethods, Payer payer, Site site, Callback<PaymentMethodSearch> callback) {
        PayerIntent payerIntent = new PayerIntent(payer);
        CheckoutService service = (CheckoutService)this.getDefaultRetrofit().create(CheckoutService.class);
        String separator = ",";
        String excludedPaymentTypesAppended = this.getListAsString(excludedPaymentTypes, separator);
        String excludedPaymentMethodsAppended = this.getListAsString(excludedPaymentMethods, separator);
        String siteId = site == null ? "" : site.getId();
        service.getPaymentMethodSearch(this.mContext.getResources().getConfiguration().locale.getLanguage(), this.mPublicKey, amount, excludedPaymentTypesAppended, excludedPaymentMethodsAppended, payerIntent, siteId, "1.3.x").enqueue(callback);
    }

    public void createPayment(PaymentBody paymentBody, Callback<Payment> callback) {
        CheckoutService service = (CheckoutService)this.getDefaultRetrofit(10, 20, 20).create(CheckoutService.class);
        service.createPayment(paymentBody.getTransactionId(), paymentBody).enqueue(callback);
    }

    public void createToken(final SavedCardToken savedCardToken, final Callback<Token> callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                savedCardToken.setDevice(MercadoPagoServices.this.mContext);
                GatewayService service = (GatewayService)MercadoPagoServices.this.getGatewayRetrofit().create(GatewayService.class);
                service.getToken(MercadoPagoServices.this.mPublicKey, MercadoPagoServices.this.mPrivateKey, savedCardToken).enqueue(callback);
            }
        }).start();
    }

    public void createToken(final CardToken cardToken, final Callback<Token> callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                cardToken.setDevice(MercadoPagoServices.this.mContext);
                GatewayService service = (GatewayService)MercadoPagoServices.this.getGatewayRetrofit().create(GatewayService.class);
                service.getToken(MercadoPagoServices.this.mPublicKey, MercadoPagoServices.this.mPrivateKey, cardToken).enqueue(callback);
            }
        }).start();
    }

    public void cloneToken(String tokenId, Callback<Token> callback) {
        GatewayService service = (GatewayService)this.getGatewayRetrofit().create(GatewayService.class);
        service.getToken(tokenId, this.mPublicKey, this.mPrivateKey).enqueue(callback);
    }

    public void putSecurityCode(String tokenId, SecurityCodeIntent securityCodeIntent, Callback<Token> callback) {
        GatewayService service = (GatewayService)this.getGatewayRetrofit().create(GatewayService.class);
        service.getToken(tokenId, this.mPublicKey, this.mPrivateKey, securityCodeIntent).enqueue(callback);
    }

    public void getBankDeals(Callback<List<BankDeal>> callback) {
        BankDealService service = (BankDealService)this.getDefaultRetrofit().create(BankDealService.class);
        service.getBankDeals(this.mPublicKey, this.mPrivateKey, this.mContext.getResources().getConfiguration().locale.toString()).enqueue(callback);
    }

    public void getIdentificationTypes(Callback<List<IdentificationType>> callback) {
        IdentificationService service = (IdentificationService)this.getDefaultRetrofit().create(IdentificationService.class);
        service.getIdentificationTypes(this.mPublicKey, this.mPrivateKey).enqueue(callback);
    }

    public void getInstallments(String bin, BigDecimal amount, Long issuerId, String paymentMethodId, Callback<List<Installment>> callback) {
        PaymentService service = (PaymentService)this.getDefaultRetrofit().create(PaymentService.class);
        service.getInstallments(this.mPublicKey, this.mPrivateKey, bin, amount, issuerId, paymentMethodId, this.mContext.getResources().getConfiguration().locale.toString()).enqueue(callback);
    }

    public void getIssuers(String paymentMethodId, String bin, Callback<List<Issuer>> callback) {
        PaymentService service = (PaymentService)this.getDefaultRetrofit().create(PaymentService.class);
        service.getIssuers(this.mPublicKey, this.mPrivateKey, paymentMethodId, bin).enqueue(callback);
    }

    public void getPaymentMethods(Callback<List<PaymentMethod>> callback) {
        PaymentService service = (PaymentService)this.getDefaultRetrofit().create(PaymentService.class);
        service.getPaymentMethods(this.mPublicKey, this.mPrivateKey).enqueue(callback);
    }

    public void getDirectDiscount(String amount, String payerEmail, Callback<Discount> callback) {
        DiscountService service = (DiscountService)this.getDefaultRetrofit().create(DiscountService.class);
        service.getDirectDiscount(this.mPublicKey, amount, payerEmail).enqueue(callback);
    }

    public void getCodeDiscount(String amount, String payerEmail, String couponCode, Callback<Discount> callback) {
        DiscountService service = (DiscountService)this.getDefaultRetrofit().create(DiscountService.class);
        service.getCodeDiscount(this.mPublicKey, amount, payerEmail, couponCode).enqueue(callback);
    }

    public void getCampaigns(Callback<List<Campaign>> callback) {
        DiscountService service = (DiscountService)this.getDefaultRetrofit().create(DiscountService.class);
        service.getCampaigns(this.mPublicKey).enqueue(callback);
    }

    public static List<PaymentMethod> getValidPaymentMethodsForBin(String bin, List<PaymentMethod> paymentMethods) {
        if (bin.length() == 6) {
            ArrayList<PaymentMethod> validPaymentMethods = new ArrayList<PaymentMethod>();
            for (PaymentMethod pm : paymentMethods) {
                if (!pm.isValidForBin(bin)) continue;
                validPaymentMethods.add(pm);
            }
            return validPaymentMethods;
        }
        throw new RuntimeException("Invalid bin: 6 digits needed, " + bin.length() + " found");
    }

    private Retrofit getDefaultRetrofit() {
        return this.getDefaultRetrofit(10, 20, 20);
    }

    private Retrofit getDefaultRetrofit(int connectTimeout, int readTimeout, int writeTimeout) {
        String baseUrl = this.mServicePreference != null && !TextUtil.isEmpty(this.mServicePreference.getDefaultBaseURL()) ? this.mServicePreference.getDefaultBaseURL() : MP_API_BASE_URL;
        return this.getRetrofit(baseUrl, connectTimeout, readTimeout, writeTimeout);
    }

    private Retrofit getGatewayRetrofit() {
        return this.getGatewayRetrofit(10, 20, 20);
    }

    private Retrofit getGatewayRetrofit(int connectTimeout, int readTimeout, int writeTimeout) {
        String baseUrl = this.mServicePreference != null && !TextUtil.isEmpty(this.mServicePreference.getGatewayBaseURL()) ? this.mServicePreference.getGatewayBaseURL() : (this.mServicePreference != null && !TextUtil.isEmpty(this.mServicePreference.getDefaultBaseURL()) ? this.mServicePreference.getDefaultBaseURL() : MP_API_BASE_URL);
        return this.getRetrofit(baseUrl, connectTimeout, readTimeout, writeTimeout);
    }

    private Retrofit getRetrofit(String baseUrl, int connectTimeout, int readTimeout, int writeTimeout) {
        return new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)JsonUtil.getInstance().getGson())).client(HttpClientUtil.getClient(this.mContext, connectTimeout, readTimeout, writeTimeout)).addCallAdapterFactory((CallAdapter.Factory)new ErrorHandlingCallAdapter.ErrorHandlingCallAdapterFactory()).build();
    }

    private String getListAsString(List<String> list, String separator) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null) {
            for (String typeId : list) {
                stringBuilder.append(typeId);
                if (typeId.equals(list.get(list.size() - 1))) continue;
                stringBuilder.append(separator);
            }
        }
        return stringBuilder.toString();
    }

    public static class Builder {
        private Context mContext = null;
        private String mPublicKey = null;
        public String mPrivateKey;
        public ServicePreference mServicePreference;

        public Builder setContext(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("context is null");
            }
            this.mContext = context;
            return this;
        }

        public Builder setPrivateKey(String key) {
            this.mPrivateKey = key;
            return this;
        }

        public Builder setPublicKey(String key) {
            this.mPublicKey = key;
            return this;
        }

        public Builder setServicePreference(ServicePreference servicePreference) {
            this.mServicePreference = servicePreference;
            return this;
        }

        public MercadoPagoServices build() {
            if (this.mContext == null) {
                throw new IllegalStateException("context is null");
            }
            if (TextUtil.isEmpty(this.mPublicKey) && TextUtil.isEmpty(this.mPrivateKey)) {
                throw new IllegalStateException("key is null");
            }
            return new MercadoPagoServices(this);
        }
    }
}

