package com.mercadopago.model;

import com.mercadopago.util.ApiUtil;

import java.util.List;

public class ApiException {

    private List<Cause> cause;
    private String error;
    private String message;
    private Integer status;

    public ApiException() {
    }

    public ApiException(String message, Integer status, String error, List<Cause> cause) {

        this.message = message;
        this.status = status;
        this.error = error;
        this.cause = cause;
    }

    public List<Cause> getCause() {
        return cause;
    }

    public void setCause(List<Cause> cause) {
        this.cause = cause;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public boolean isRecoverable() {
        return getStatus() == null || getStatus() != ApiUtil.StatusCodes.NOT_FOUND
                && (getCause() == null || getCause().isEmpty());
    }

    public class ErrorCodes {
        public static final String CUSTOMER_NOT_ALLOWED_TO_OPERATE = "2021";
        public static final String COLLECTOR_NOT_ALLOWED_TO_OPERATE = "2022";
        public static final String INVALID_USERS_INVOLVED = "2035";
        public static final String CUSTOMER_EQUAL_TO_COLLECTOR = "3000";
        public static final String INVALID_CARD_HOLDER_NAME = "3001";
        public static final String UNAUTHORIZED_CLIENT = "3010";
        public static final String PAYMENT_METHOD_NOT_FOUND = "3012";
        public static final String INVALID_SECURITY_CODE = "3013";
        public static final String SECURITY_CODE_REQUIRED = "3014";
        public static final String INVALID_PAYMENT_METHOD = "3015";
        public static final String INVALID_CARD_NUMBER = "3017";
        public static final String EMPTY_EXPIRATION_MONTH = "3019";
        public static final String EMPTY_EXPIRATION_YEAR = "3020";
        public static final String EMPTY_CARD_HOLDER_NAME = "3021";
        public static final String EMPTY_DOCUMENT_NUMBER = "3022";
        public static final String EMPTY_DOCUMENT_TYPE = "3023";
        public static final String INVALID_PAYMENT_TYPE_ID = "3028";
        public static final String INVALID_PAYMENT_METHOD_ID = "3029";
        public static final String INVALID_CARD_EXPIRATION_MONTH = "3030";
        public static final String INVALID_CARD_EXPIRATION_YEAR = "4000";
        public static final String INVALID_PAYER_EMAIL = "4050";
    }
}

