/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.payment;

import com.mercadopago.client.payment.PaymentReceiverAddressRequest;

public class PaymentShipmentsRequest {
    private final PaymentReceiverAddressRequest receiverAddress;
    private final boolean localPickup;
    private final boolean expressShipment;

    PaymentShipmentsRequest(PaymentReceiverAddressRequest receiverAddress, boolean localPickup, boolean expressShipment) {
        this.receiverAddress = receiverAddress;
        this.localPickup = localPickup;
        this.expressShipment = expressShipment;
    }

    public static PaymentShipmentsRequestBuilder builder() {
        return new PaymentShipmentsRequestBuilder();
    }

    public PaymentReceiverAddressRequest getReceiverAddress() {
        return this.receiverAddress;
    }

    public boolean isLocalPickup() {
        return this.localPickup;
    }

    public boolean isExpressShipment() {
        return this.expressShipment;
    }

    public static class PaymentShipmentsRequestBuilder {
        private PaymentReceiverAddressRequest receiverAddress;
        private boolean localPickup;
        private boolean expressShipment;

        PaymentShipmentsRequestBuilder() {
        }

        public PaymentShipmentsRequestBuilder receiverAddress(PaymentReceiverAddressRequest receiverAddress) {
            this.receiverAddress = receiverAddress;
            return this;
        }

        public PaymentShipmentsRequestBuilder localPickup(boolean localPickup) {
            this.localPickup = localPickup;
            return this;
        }

        public PaymentShipmentsRequestBuilder expressShipment(boolean expressShipment) {
            this.expressShipment = expressShipment;
            return this;
        }

        public PaymentShipmentsRequest build() {
            return new PaymentShipmentsRequest(this.receiverAddress, this.localPickup, this.expressShipment);
        }

        public String toString() {
            return "PaymentShipmentsRequest.PaymentShipmentsRequestBuilder(receiverAddress=" + this.receiverAddress + ", localPickup=" + this.localPickup + ", expressShipment=" + this.expressShipment + ")";
        }
    }
}

