/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.payment;

import com.mercadopago.client.payment.PaymentDiscountRequest;
import com.mercadopago.client.payment.PaymentFeeRequest;
import java.util.List;

public class PaymentRulesRequest {
    private List<PaymentDiscountRequest> discounts;
    private PaymentFeeRequest fine;
    private PaymentFeeRequest interest;

    PaymentRulesRequest(List<PaymentDiscountRequest> discounts, PaymentFeeRequest fine, PaymentFeeRequest interest) {
        this.discounts = discounts;
        this.fine = fine;
        this.interest = interest;
    }

    public static PaymentRulesRequestBuilder builder() {
        return new PaymentRulesRequestBuilder();
    }

    public List<PaymentDiscountRequest> getDiscounts() {
        return this.discounts;
    }

    public PaymentFeeRequest getFine() {
        return this.fine;
    }

    public PaymentFeeRequest getInterest() {
        return this.interest;
    }

    public static class PaymentRulesRequestBuilder {
        private List<PaymentDiscountRequest> discounts;
        private PaymentFeeRequest fine;
        private PaymentFeeRequest interest;

        PaymentRulesRequestBuilder() {
        }

        public PaymentRulesRequestBuilder discounts(List<PaymentDiscountRequest> discounts) {
            this.discounts = discounts;
            return this;
        }

        public PaymentRulesRequestBuilder fine(PaymentFeeRequest fine) {
            this.fine = fine;
            return this;
        }

        public PaymentRulesRequestBuilder interest(PaymentFeeRequest interest) {
            this.interest = interest;
            return this;
        }

        public PaymentRulesRequest build() {
            return new PaymentRulesRequest(this.discounts, this.fine, this.interest);
        }

        public String toString() {
            return "PaymentRulesRequest.PaymentRulesRequestBuilder(discounts=" + this.discounts + ", fine=" + this.fine + ", interest=" + this.interest + ")";
        }
    }
}

