/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.oauth;

public class RefreshOauthCredentialRequest {
    private final String grantType = "refresh_token";
    private final String clientSecret;
    private final String clientId;
    private final String refreshToken;

    RefreshOauthCredentialRequest(String clientSecret, String clientId, String refreshToken) {
        this.clientSecret = clientSecret;
        this.clientId = clientId;
        this.refreshToken = refreshToken;
    }

    public static RefreshOauthCredentialRequestBuilder builder() {
        return new RefreshOauthCredentialRequestBuilder();
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public static class RefreshOauthCredentialRequestBuilder {
        private String clientSecret;
        private String clientId;
        private String refreshToken;

        RefreshOauthCredentialRequestBuilder() {
        }

        public RefreshOauthCredentialRequestBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public RefreshOauthCredentialRequestBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public RefreshOauthCredentialRequestBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public RefreshOauthCredentialRequest build() {
            return new RefreshOauthCredentialRequest(this.clientSecret, this.clientId, this.refreshToken);
        }

        public String toString() {
            return "RefreshOauthCredentialRequest.RefreshOauthCredentialRequestBuilder(clientSecret=" + this.clientSecret + ", clientId=" + this.clientId + ", refreshToken=" + this.refreshToken + ")";
        }
    }
}

