/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.merchantorder;

import com.mercadopago.client.merchantorder.MerchantOrderReceiverAddressRequest;
import com.mercadopago.client.merchantorder.MerchantOrderShippingOptionRequest;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public class MerchantOrderShipmentRequest {
    private final Long id;
    private final String shippingType;
    private final String shippingMode;
    private final String pickingType;
    private final String status;
    private final String shippingSubstatus;
    private final List<Map<String, Object>> items;
    private final OffsetDateTime dateCreated;
    private final OffsetDateTime lastModified;
    private final OffsetDateTime dateFirstPrinted;
    private final String serviceId;
    private final Long senderId;
    private final Long receiverId;
    private final MerchantOrderReceiverAddressRequest receiverAddress;
    private final MerchantOrderShippingOptionRequest shippingOption;

    MerchantOrderShipmentRequest(Long id, String shippingType, String shippingMode, String pickingType, String status, String shippingSubstatus, List<Map<String, Object>> items, OffsetDateTime dateCreated, OffsetDateTime lastModified, OffsetDateTime dateFirstPrinted, String serviceId, Long senderId, Long receiverId, MerchantOrderReceiverAddressRequest receiverAddress, MerchantOrderShippingOptionRequest shippingOption) {
        this.id = id;
        this.shippingType = shippingType;
        this.shippingMode = shippingMode;
        this.pickingType = pickingType;
        this.status = status;
        this.shippingSubstatus = shippingSubstatus;
        this.items = items;
        this.dateCreated = dateCreated;
        this.lastModified = lastModified;
        this.dateFirstPrinted = dateFirstPrinted;
        this.serviceId = serviceId;
        this.senderId = senderId;
        this.receiverId = receiverId;
        this.receiverAddress = receiverAddress;
        this.shippingOption = shippingOption;
    }

    public static MerchantOrderShipmentRequestBuilder builder() {
        return new MerchantOrderShipmentRequestBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getShippingType() {
        return this.shippingType;
    }

    public String getShippingMode() {
        return this.shippingMode;
    }

    public String getPickingType() {
        return this.pickingType;
    }

    public String getStatus() {
        return this.status;
    }

    public String getShippingSubstatus() {
        return this.shippingSubstatus;
    }

    public List<Map<String, Object>> getItems() {
        return this.items;
    }

    public OffsetDateTime getDateCreated() {
        return this.dateCreated;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public OffsetDateTime getDateFirstPrinted() {
        return this.dateFirstPrinted;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public Long getSenderId() {
        return this.senderId;
    }

    public Long getReceiverId() {
        return this.receiverId;
    }

    public MerchantOrderReceiverAddressRequest getReceiverAddress() {
        return this.receiverAddress;
    }

    public MerchantOrderShippingOptionRequest getShippingOption() {
        return this.shippingOption;
    }

    public static class MerchantOrderShipmentRequestBuilder {
        private Long id;
        private String shippingType;
        private String shippingMode;
        private String pickingType;
        private String status;
        private String shippingSubstatus;
        private List<Map<String, Object>> items;
        private OffsetDateTime dateCreated;
        private OffsetDateTime lastModified;
        private OffsetDateTime dateFirstPrinted;
        private String serviceId;
        private Long senderId;
        private Long receiverId;
        private MerchantOrderReceiverAddressRequest receiverAddress;
        private MerchantOrderShippingOptionRequest shippingOption;

        MerchantOrderShipmentRequestBuilder() {
        }

        public MerchantOrderShipmentRequestBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public MerchantOrderShipmentRequestBuilder shippingType(String shippingType) {
            this.shippingType = shippingType;
            return this;
        }

        public MerchantOrderShipmentRequestBuilder shippingMode(String shippingMode) {
            this.shippingMode = shippingMode;
            return this;
        }

        public MerchantOrderShipmentRequestBuilder pickingType(String pickingType) {
            this.pickingType = pickingType;
            return this;
        }

        public MerchantOrderShipmentRequestBuilder status(String status) {
            this.status = status;
            return this;
        }

        public MerchantOrderShipmentRequestBuilder shippingSubstatus(String shippingSubstatus) {
            this.shippingSubstatus = shippingSubstatus;
            return this;
        }

        public MerchantOrderShipmentRequestBuilder items(List<Map<String, Object>> items) {
            this.items = items;
            return this;
        }

        public MerchantOrderShipmentRequestBuilder dateCreated(OffsetDateTime dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public MerchantOrderShipmentRequestBuilder lastModified(OffsetDateTime lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public MerchantOrderShipmentRequestBuilder dateFirstPrinted(OffsetDateTime dateFirstPrinted) {
            this.dateFirstPrinted = dateFirstPrinted;
            return this;
        }

        public MerchantOrderShipmentRequestBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public MerchantOrderShipmentRequestBuilder senderId(Long senderId) {
            this.senderId = senderId;
            return this;
        }

        public MerchantOrderShipmentRequestBuilder receiverId(Long receiverId) {
            this.receiverId = receiverId;
            return this;
        }

        public MerchantOrderShipmentRequestBuilder receiverAddress(MerchantOrderReceiverAddressRequest receiverAddress) {
            this.receiverAddress = receiverAddress;
            return this;
        }

        public MerchantOrderShipmentRequestBuilder shippingOption(MerchantOrderShippingOptionRequest shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        public MerchantOrderShipmentRequest build() {
            return new MerchantOrderShipmentRequest(this.id, this.shippingType, this.shippingMode, this.pickingType, this.status, this.shippingSubstatus, this.items, this.dateCreated, this.lastModified, this.dateFirstPrinted, this.serviceId, this.senderId, this.receiverId, this.receiverAddress, this.shippingOption);
        }

        public String toString() {
            return "MerchantOrderShipmentRequest.MerchantOrderShipmentRequestBuilder(id=" + this.id + ", shippingType=" + this.shippingType + ", shippingMode=" + this.shippingMode + ", pickingType=" + this.pickingType + ", status=" + this.status + ", shippingSubstatus=" + this.shippingSubstatus + ", items=" + this.items + ", dateCreated=" + this.dateCreated + ", lastModified=" + this.lastModified + ", dateFirstPrinted=" + this.dateFirstPrinted + ", serviceId=" + this.serviceId + ", senderId=" + this.senderId + ", receiverId=" + this.receiverId + ", receiverAddress=" + this.receiverAddress + ", shippingOption=" + this.shippingOption + ")";
        }
    }
}

