/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client;

import com.google.gson.JsonObject;
import com.mercadopago.MercadoPagoConfig;
import com.mercadopago.core.MPRequestOptions;
import com.mercadopago.exceptions.MPApiException;
import com.mercadopago.exceptions.MPException;
import com.mercadopago.net.HttpMethod;
import com.mercadopago.net.MPHttpClient;
import com.mercadopago.net.MPRequest;
import com.mercadopago.net.MPResponse;
import com.mercadopago.net.MPSearchRequest;
import com.mercadopago.net.UrlFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class MercadoPagoClient {
    private static final String ACCEPT_HEADER_VALUE = "application/json";
    private static final String CONTENT_TYPE_HEADER_VALUE = "application/json; charset=UTF-8";
    protected final MPHttpClient httpClient;
    protected Map<String, String> defaultHeaders;

    public MercadoPagoClient(MPHttpClient httpClient) {
        this.httpClient = httpClient;
        this.defaultHeaders = new HashMap<String, String>();
        this.defaultHeaders.put("Accept", ACCEPT_HEADER_VALUE);
        this.defaultHeaders.put("X-Product-Id", "BC32A7VTRPP001U8NHJ0");
        this.defaultHeaders.put("User-Agent", String.format("MercadoPago Java SDK/%s", "2.1.9"));
        this.defaultHeaders.put("X-Tracking-Id", MercadoPagoConfig.TRACKING_ID);
        this.defaultHeaders.put("Content-Type", CONTENT_TYPE_HEADER_VALUE);
    }

    protected MPResponse send(MPRequest request) throws MPException, MPApiException {
        String uri = UrlFormatter.format(request.getUri(), request.getQueryParams());
        return this.httpClient.send(MPRequest.builder().uri(uri).method(request.getMethod()).headers(this.addDefaultHeaders(request)).payload(request.getPayload()).connectionRequestTimeout(this.addConnectionRequestTimeout(request, null)).connectionTimeout(this.addConnectionTimeout(request, null)).socketTimeout(this.addSocketTimeout(request, null)).build());
    }

    protected MPResponse send(MPRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        return this.send(this.buildRequest(request.getUri(), request.getMethod(), request.getPayload(), request.getQueryParams(), requestOptions));
    }

    protected MPResponse send(String path, HttpMethod method, JsonObject payload, Map<String, Object> queryParams) throws MPException, MPApiException {
        return this.send(path, method, payload, queryParams, null);
    }

    protected MPResponse send(String path, HttpMethod method, JsonObject payload, Map<String, Object> queryParams, MPRequestOptions requestOptions) throws MPException, MPApiException {
        MPRequest mpRequest = this.buildRequest(path, method, payload, queryParams, requestOptions);
        return this.send(mpRequest);
    }

    protected MPResponse search(String path, MPSearchRequest request) throws MPException, MPApiException {
        return this.search(path, request, null);
    }

    protected MPResponse search(String path, MPSearchRequest searchRequest, MPRequestOptions requestOptions) throws MPException, MPApiException {
        Map<String, Object> queryParams = Objects.nonNull(searchRequest) ? searchRequest.getParameters() : null;
        return this.send(path, HttpMethod.GET, null, queryParams, requestOptions);
    }

    protected MPResponse list(String path, MPRequestOptions requestOptions) throws MPException, MPApiException {
        return this.list(path, HttpMethod.GET, null, null, requestOptions);
    }

    protected MPResponse list(String path, HttpMethod method, JsonObject payload, Map<String, Object> queryParams, MPRequestOptions requestOptions) throws MPException, MPApiException {
        return this.send(path, method, payload, queryParams, requestOptions);
    }

    private MPRequest buildRequest(String path, HttpMethod method, JsonObject payload, Map<String, Object> queryParams, MPRequestOptions requestOptions) {
        return MPRequest.builder().uri(path).accessToken(this.getAccessToken(requestOptions)).payload(payload).method(method).queryParams(queryParams).headers(this.addCustomHeaders(path, requestOptions)).connectionRequestTimeout(this.addConnectionRequestTimeout(null, requestOptions)).connectionTimeout(this.addConnectionTimeout(null, requestOptions)).socketTimeout(this.addSocketTimeout(null, requestOptions)).build();
    }

    private int addSocketTimeout(MPRequest request, MPRequestOptions requestOptions) {
        if (Objects.nonNull(requestOptions) && requestOptions.getSocketTimeout() > 0) {
            return requestOptions.getSocketTimeout();
        }
        if (Objects.nonNull(request) && request.getSocketTimeout() > 0) {
            return request.getSocketTimeout();
        }
        return MercadoPagoConfig.getSocketTimeout();
    }

    private int addConnectionTimeout(MPRequest request, MPRequestOptions requestOptions) {
        if (Objects.nonNull(requestOptions) && requestOptions.getConnectionTimeout() > 0) {
            return requestOptions.getConnectionTimeout();
        }
        if (Objects.nonNull(request) && request.getConnectionTimeout() > 0) {
            return request.getConnectionTimeout();
        }
        return MercadoPagoConfig.getConnectionTimeout();
    }

    private int addConnectionRequestTimeout(MPRequest request, MPRequestOptions requestOptions) {
        if (Objects.nonNull(requestOptions) && requestOptions.getConnectionRequestTimeout() > 0) {
            return requestOptions.getConnectionRequestTimeout();
        }
        if (Objects.nonNull(request) && request.getConnectionRequestTimeout() > 0) {
            return request.getConnectionRequestTimeout();
        }
        return MercadoPagoConfig.getConnectionRequestTimeout();
    }

    private Map<String, String> addCustomHeaders(String uri, MPRequestOptions requestOptions) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (Objects.nonNull(requestOptions) && Objects.nonNull(requestOptions.getCustomHeaders())) {
            for (Map.Entry<String, String> entry : requestOptions.getCustomHeaders().entrySet()) {
                headers.put(entry.getKey(), entry.getValue());
            }
        }
        if (!uri.contains("/oauth/token")) {
            headers.put("Authorization", String.format("Bearer %s", this.getAccessToken(requestOptions)));
        }
        return headers;
    }

    private Map<String, String> addDefaultHeaders(MPRequest request) {
        HashMap<String, String> headers = Objects.nonNull(request.getHeaders()) ? request.getHeaders() : new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.defaultHeaders.entrySet()) {
            headers.put(entry.getKey(), entry.getValue());
        }
        if (this.shouldAddIdempotencyKey(request)) {
            headers.put("X-Idempotency-Key", request.createIdempotencyKey());
        }
        if (!request.getUri().contains("/oauth/token") && !headers.containsKey("Authorization")) {
            headers.put("Authorization", String.format("Bearer %s", this.getAccessToken(null)));
        }
        return headers;
    }

    private boolean shouldAddIdempotencyKey(MPRequest request) {
        return request.getMethod() == HttpMethod.POST;
    }

    private String getAccessToken(MPRequestOptions requestOptions) {
        return Objects.nonNull(requestOptions) && Objects.nonNull(requestOptions.getAccessToken()) && !requestOptions.getAccessToken().isEmpty() ? requestOptions.getAccessToken() : MercadoPagoConfig.getAccessToken();
    }
}

