/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago;

import com.mercadopago.net.MPDefaultHttpClient;
import com.mercadopago.net.MPHttpClient;
import java.util.Objects;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.StreamHandler;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpRequestRetryHandler;

public class MercadoPagoConfig {
    private static final Object $LOCK = new Object[0];
    public static final String CURRENT_VERSION = "2.1.9";
    public static final String PRODUCT_ID = "BC32A7VTRPP001U8NHJ0";
    public static final String TRACKING_ID = String.format("platform:%s,type:SDK%s,so;", MercadoPagoConfig.getJavaVersion(), "2.1.9");
    public static final String BASE_URL = "https://api.mercadopago.com";
    private static final int DEFAULT_MAX_CONNECTIONS = 10;
    private static final int DEFAULT_CONNECTION_TIMEOUT_MS = 20000;
    private static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT_MS = 20000;
    private static final int DEFAULT_SOCKET_TIMEOUT_MS = 20000;
    private static final String DEFAULT_METRICS_SCOPE = "prod";
    private static final Level DEFAULT_LOGGING_LEVEL = Level.OFF;
    private static volatile String accessToken;
    private static volatile String platformId;
    private static volatile String corporationId;
    private static volatile String integratorId;
    private static volatile StreamHandler loggingHandler;
    private static volatile String metricsScope;
    private static volatile Level loggingLevel;
    private static volatile int maxConnections;
    private static volatile int connectionTimeout;
    private static volatile int connectionRequestTimeout;
    private static volatile int socketTimeout;
    private static volatile MPHttpClient httpClient;
    private static HttpHost proxy;
    private static HttpRequestRetryHandler retryHandler;

    public static synchronized MPHttpClient getHttpClient() {
        if (Objects.isNull(httpClient)) {
            httpClient = new MPDefaultHttpClient();
        }
        return httpClient;
    }

    public static synchronized String getJavaVersion() {
        String version = System.getProperty("java.runtime.version");
        if (Objects.isNull(version)) {
            return null;
        }
        String major = version.replaceAll("^1\\.", "");
        int dotIndex = major.indexOf(46);
        if (dotIndex != -1) {
            major = major.substring(0, dotIndex);
        }
        return major + "|" + version;
    }

    public static StreamHandler getStreamHandler() {
        return Objects.nonNull(loggingHandler) ? loggingHandler : new ConsoleHandler();
    }

    public static String getAccessToken() {
        return accessToken;
    }

    public static void setAccessToken(String accessToken) {
        MercadoPagoConfig.accessToken = accessToken;
    }

    public static String getPlatformId() {
        return platformId;
    }

    public static void setPlatformId(String platformId) {
        MercadoPagoConfig.platformId = platformId;
    }

    public static String getCorporationId() {
        return corporationId;
    }

    public static void setCorporationId(String corporationId) {
        MercadoPagoConfig.corporationId = corporationId;
    }

    public static String getIntegratorId() {
        return integratorId;
    }

    public static void setIntegratorId(String integratorId) {
        MercadoPagoConfig.integratorId = integratorId;
    }

    public static StreamHandler getLoggingHandler() {
        return loggingHandler;
    }

    public static void setLoggingHandler(StreamHandler loggingHandler) {
        MercadoPagoConfig.loggingHandler = loggingHandler;
    }

    public static String getMetricsScope() {
        return metricsScope;
    }

    public static void setMetricsScope(String metricsScope) {
        MercadoPagoConfig.metricsScope = metricsScope;
    }

    public static Level getLoggingLevel() {
        return loggingLevel;
    }

    public static void setLoggingLevel(Level loggingLevel) {
        MercadoPagoConfig.loggingLevel = loggingLevel;
    }

    public static int getMaxConnections() {
        return maxConnections;
    }

    public static void setMaxConnections(int maxConnections) {
        MercadoPagoConfig.maxConnections = maxConnections;
    }

    public static int getConnectionTimeout() {
        return connectionTimeout;
    }

    public static void setConnectionTimeout(int connectionTimeout) {
        MercadoPagoConfig.connectionTimeout = connectionTimeout;
    }

    public static int getConnectionRequestTimeout() {
        return connectionRequestTimeout;
    }

    public static void setConnectionRequestTimeout(int connectionRequestTimeout) {
        MercadoPagoConfig.connectionRequestTimeout = connectionRequestTimeout;
    }

    public static int getSocketTimeout() {
        return socketTimeout;
    }

    public static void setSocketTimeout(int socketTimeout) {
        MercadoPagoConfig.socketTimeout = socketTimeout;
    }

    public static void setHttpClient(MPHttpClient httpClient) {
        MercadoPagoConfig.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpHost getProxy() {
        Object object = $LOCK;
        synchronized (object) {
            return proxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProxy(HttpHost proxy) {
        Object object = $LOCK;
        synchronized (object) {
            MercadoPagoConfig.proxy = proxy;
        }
    }

    public static HttpRequestRetryHandler getRetryHandler() {
        return retryHandler;
    }

    public static void setRetryHandler(HttpRequestRetryHandler retryHandler) {
        MercadoPagoConfig.retryHandler = retryHandler;
    }

    static {
        metricsScope = DEFAULT_METRICS_SCOPE;
        loggingLevel = DEFAULT_LOGGING_LEVEL;
        maxConnections = 10;
        connectionTimeout = 20000;
        connectionRequestTimeout = 20000;
        socketTimeout = 20000;
    }
}

