/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.payment;

import com.mercadopago.client.payment.PaymentTransactionDataRequest;

public class PaymentPointOfInteractionRequest {
    private final String linkedTo;
    private final String type;
    private final String subType;
    private final PaymentTransactionDataRequest transactionData;

    PaymentPointOfInteractionRequest(String linkedTo, String type, String subType, PaymentTransactionDataRequest transactionData) {
        this.linkedTo = linkedTo;
        this.type = type;
        this.subType = subType;
        this.transactionData = transactionData;
    }

    public static PaymentPointOfInteractionRequestBuilder builder() {
        return new PaymentPointOfInteractionRequestBuilder();
    }

    public String getLinkedTo() {
        return this.linkedTo;
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public PaymentTransactionDataRequest getTransactionData() {
        return this.transactionData;
    }

    public static class PaymentPointOfInteractionRequestBuilder {
        private String linkedTo;
        private String type;
        private String subType;
        private PaymentTransactionDataRequest transactionData;

        PaymentPointOfInteractionRequestBuilder() {
        }

        public PaymentPointOfInteractionRequestBuilder linkedTo(String linkedTo) {
            this.linkedTo = linkedTo;
            return this;
        }

        public PaymentPointOfInteractionRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public PaymentPointOfInteractionRequestBuilder subType(String subType) {
            this.subType = subType;
            return this;
        }

        public PaymentPointOfInteractionRequestBuilder transactionData(PaymentTransactionDataRequest transactionData) {
            this.transactionData = transactionData;
            return this;
        }

        public PaymentPointOfInteractionRequest build() {
            return new PaymentPointOfInteractionRequest(this.linkedTo, this.type, this.subType, this.transactionData);
        }

        public String toString() {
            return "PaymentPointOfInteractionRequest.PaymentPointOfInteractionRequestBuilder(linkedTo=" + this.linkedTo + ", type=" + this.type + ", subType=" + this.subType + ", transactionData=" + this.transactionData + ")";
        }
    }
}

